/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.services;

import com.systel.sync.services.common.ConfigurationService;
import com.systel.sync.services.common.ConnectionService;
import com.systel.sync.services.install.InstallService;
import com.systel.sync.services.install.InstallServiceInterface;
import com.systel.sync.services.language.LanguageService;
import com.systel.sync.services.language.LanguageServiceInterface;
import com.systel.sync.services.log.LogService;
import com.systel.sync.services.log.LogServiceInterface;
import com.systel.sync.services.nodes.local.NodesLocalService;
import com.systel.sync.services.nodes.local.NodesLocalServiceInterface;
import com.systel.sync.services.nodes.models.NodeModelsService;
import com.systel.sync.services.nodes.models.NodeModelsServiceInterface;
import com.systel.sync.services.nodes.remote.NodesRemoteService;
import com.systel.sync.services.nodes.remote.NodesRemoteServiceInterface;
import com.systel.sync.services.preferences.PreferencesService;
import com.systel.sync.services.preferences.PreferencesServiceInterface;
import com.systel.sync.services.salesmerge.local.SalesMergeLocalService;
import com.systel.sync.services.salesmerge.local.SalesMergeLocalServiceInterface;
import com.systel.sync.services.salesmerge.remote.SalesMergeRemoteService;
import com.systel.sync.services.salesmerge.remote.SalesMergeRemoteServiceInterface;
import com.systel.sync.services.scheduler.SchedulerService;
import com.systel.sync.services.scheduler.SchedulerServiceInterface;
import com.systel.sync.services.sync.local.SyncLocalService;
import com.systel.sync.services.sync.local.SyncLocalServiceInterface;
import com.systel.sync.services.sync.remote.SyncRemoteService;
import com.systel.sync.services.sync.remote.SyncRemoteServiceInterface;
import com.systel.sync.services.tools.ToolsService;
import com.systel.sync.services.tools.ToolsServiceInterface;
import com.systel.sync.services.users.UsersService;
import com.systel.sync.services.users.UsersServiceInterface;
import java.util.ResourceBundle;

public final class ServicesFacade {
    private final ConfigurationService configurationService;
    private final InstallServiceInterface installService;
    private final UsersServiceInterface usersService;
    private final NodesLocalServiceInterface nodesLocalService;
    private final NodesRemoteServiceInterface nodesRemoteService;
    private final NodeModelsServiceInterface nodeModelsService;
    private final SalesMergeLocalServiceInterface salesMergeLocalService;
    private final SalesMergeRemoteServiceInterface salesMergeRemoteService;
    private final SyncLocalServiceInterface syncLocalService;
    private final SyncRemoteServiceInterface syncRemoteService;
    private final SchedulerServiceInterface schedulerService;
    private final LogServiceInterface logService;
    private final LanguageServiceInterface languageService;
    private final PreferencesServiceInterface preferencesService;
    private final ToolsServiceInterface toolsService;

    public ServicesFacade(ConfigurationService configurationService, ConnectionService connectionService, ResourceBundle resourceBundle) {
        this.configurationService = configurationService;
        this.installService = new InstallService(configurationService);
        this.usersService = new UsersService(connectionService);
        this.nodesLocalService = new NodesLocalService(configurationService, connectionService, resourceBundle);
        this.nodesRemoteService = new NodesRemoteService(connectionService);
        this.nodeModelsService = new NodeModelsService(connectionService);
        this.salesMergeLocalService = new SalesMergeLocalService(connectionService);
        this.salesMergeRemoteService = new SalesMergeRemoteService(connectionService);
        this.syncLocalService = new SyncLocalService(connectionService, resourceBundle);
        this.syncRemoteService = new SyncRemoteService(connectionService, resourceBundle);
        this.schedulerService = new SchedulerService(connectionService);
        this.logService = new LogService(connectionService);
        this.languageService = new LanguageService(configurationService);
        this.preferencesService = new PreferencesService(configurationService, connectionService);
        this.toolsService = new ToolsService(configurationService, connectionService);
    }

    public InstallServiceInterface getInstallService() {
        return this.installService;
    }

    public UsersServiceInterface getUsersService() {
        return this.usersService;
    }

    public NodesLocalServiceInterface getNodesLocalService() {
        return this.nodesLocalService;
    }

    public NodesRemoteServiceInterface getNodesRemoteService() {
        return this.nodesRemoteService;
    }

    public NodeModelsServiceInterface getNodeModelsService() {
        return this.nodeModelsService;
    }

    public SalesMergeLocalServiceInterface getSalesMergeLocalService() {
        return this.salesMergeLocalService;
    }

    public SalesMergeRemoteServiceInterface getSalesMergeRemoteService() {
        return this.salesMergeRemoteService;
    }

    public SyncLocalServiceInterface getSyncLocalService() {
        return this.syncLocalService;
    }

    public SyncRemoteServiceInterface getSyncRemoteService() {
        return this.syncRemoteService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public SchedulerServiceInterface getSchedulerService() {
        return this.schedulerService;
    }

    public LogServiceInterface getLogService() {
        return this.logService;
    }

    public LanguageServiceInterface getLanguageService() {
        return this.languageService;
    }

    public PreferencesServiceInterface getPreferencesService() {
        return this.preferencesService;
    }

    public ToolsServiceInterface getToolsService() {
        return this.toolsService;
    }
}

