/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.log;

import com.systel.sync.common.sql.SQLDateTimeUtils;
import com.systel.sync.log.InsertLogRunnable;
import com.systel.sync.log.LogLevel;
import com.systel.sync.log.LogServiceInterface;
import com.systel.sync.log.ServiceLog;
import com.systel.sync.services.common.ConfigurationService;
import com.systel.sync.services.common.ConnectionException;
import com.systel.sync.services.common.ConnectionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class LogService
implements LogServiceInterface {
    private static LogService instance;
    private ConfigurationService configurationService;
    private ConnectionService connectionService;
    private ExecutorService executor;

    protected LogService() {
    }

    public void start(ConfigurationService configurationService, ConnectionService connectionService) {
        this.configurationService = configurationService;
        this.executor = Executors.newFixedThreadPool(1);
        this.connectionService = connectionService;
        System.setProperty("file.encoding", "UTF-8");
    }

    public static LogService getInstance() {
        try {
            instance.equals(instance);
        }
        catch (NullPointerException ex) {
            instance = new LogService();
        }
        return instance;
    }

    @Override
    public void error(String logPackages, String className, String message) {
        try {
            if (this.configurationService.getLogLevel().ordinal() >= LogLevel.Error.ordinal()) {
                this.executor.execute(new InsertLogRunnable(this.connectionService.getLocalConnection(), this.commonLog(logPackages, className, message, LogLevel.Error.name())));
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
    }

    @Override
    public void warning(String logPackages, String className, String message) {
        try {
            if (this.configurationService.getLogLevel().ordinal() >= LogLevel.Warning.ordinal()) {
                this.executor.execute(new InsertLogRunnable(this.connectionService.getLocalConnection(), this.commonLog(logPackages, className, message, LogLevel.Warning.name())));
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
    }

    @Override
    public void debug(String logPackages, String className, String message) {
        try {
            if (this.configurationService.getLogLevel().ordinal() >= LogLevel.Debug.ordinal()) {
                this.executor.execute(new InsertLogRunnable(this.connectionService.getLocalConnection(), this.commonLog(logPackages, className, message, LogLevel.Debug.name())));
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
    }

    @Override
    public void info(String logPackages, String className, String message) {
        try {
            if (this.configurationService.getLogLevel().ordinal() >= LogLevel.Info.ordinal()) {
                this.executor.execute(new InsertLogRunnable(this.connectionService.getLocalConnection(), this.commonLog(logPackages, className, message, LogLevel.Info.name())));
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
    }

    private ServiceLog commonLog(String logPackages, String className, String message, String type) {
        ServiceLog serviceLog = new ServiceLog();
        serviceLog.appPackage = logPackages;
        serviceLog.className = className;
        serviceLog.message = message;
        serviceLog.logType = type;
        serviceLog.threadId = Thread.currentThread().getId();
        serviceLog.timeStamp = SQLDateTimeUtils.now();
        return serviceLog;
    }
}

