/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.common.encryption;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class EncryptionUtils {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static BASE64Encoder enc = new BASE64Encoder();
    private static BASE64Decoder dec = new BASE64Decoder();

    public static String getHash(String txt, String hashType) {
        try {
            MessageDigest md = MessageDigest.getInstance(hashType);
            byte[] array = md.digest(txt.getBytes());
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < array.length; ++i) {
                sb.append(Integer.toHexString(array[i] & 0xFF | 0x100).substring(1, 3));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public static String md5(String txt) {
        return EncryptionUtils.getHash(txt, "MD5");
    }

    public static String sha1(String txt) {
        return EncryptionUtils.getHash(txt, "SHA1");
    }

    public static boolean isValidSHA1(String s2) {
        return s2.matches("[a-fA-F0-9]{40}");
    }

    public static boolean isValidMD5(String s2) {
        return s2.matches("[a-fA-F0-9]{32}");
    }

    public static String encode(String text) {
        try {
            return enc.encode(text.getBytes(DEFAULT_ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String decode(String text) {
        try {
            return new String(dec.decodeBuffer(text), DEFAULT_ENCODING);
        }
        catch (IOException e) {
            return null;
        }
    }
}

