/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.common;

import com.systel.sync.common.encryption.EncryptionUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import java.util.Scanner;

public class ConfigurationProperties {
    protected Properties properties = new Properties();
    protected String filePath;

    public ConfigurationProperties(String filePath) {
        this.setFilePath(filePath);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public void load() throws IOException {
        this.properties.load(new FileInputStream(this.getFilePath()));
    }

    public void loadEncrypted() throws IOException {
        String encryptedContent = new Scanner(new File(this.getFilePath())).useDelimiter("\\Z").next();
        String decoded = EncryptionUtils.decode(encryptedContent);
        decoded = decoded.substring(1, decoded.length() - 1);
        for (String couple : decoded.split(",")) {
            String[] decouple = couple.trim().split("=");
            this.properties.put(decouple[0], decouple[1]);
        }
    }

    public void save() throws IOException {
        this.properties.store(new FileOutputStream(this.getFilePath()), null);
    }

    public void saveEncrypted() throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(this.getFilePath()));
        out.write(EncryptionUtils.encode(this.properties.toString()));
        out.close();
    }
}

