/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.commandline.sync;

import com.google.common.eventbus.Subscribe;
import com.systel.sync.business.sync.events.SyncFailureEvent;
import com.systel.sync.business.sync.events.SyncProgressEvent;
import com.systel.sync.business.sync.events.SyncSuccessEvent;
import com.systel.sync.commandline.common.BaseCommand;
import com.systel.sync.commandline.common.BaseFactory;
import com.systel.sync.commandline.common.events.LogEvent;
import com.systel.sync.commandline.common.events.QuitEvent;

public class SyncCommand
implements BaseCommand {
    private BaseFactory factory;

    public SyncCommand(BaseFactory factory) {
        this.factory = factory;
        this.factory.getCommandEventBus().register(this);
        this.factory.getLibEventBus().register(this);
    }

    @Override
    public void onInitialize() {
    }

    @Override
    public void onFinalize() {
        this.factory.getLibEventBus().unregister(this);
        this.factory.getCommandEventBus().unregister(this);
        this.factory = null;
    }

    @Override
    public void execute(String ... args) {
        this.factory.getSync().diffSync((Long)null);
    }

    @Subscribe
    public void onSyncProgressEvent(SyncProgressEvent event) {
        this.factory.getEventHandlerContext().runOnThread(() -> this.factory.getCommandEventBus().post(new LogEvent(event.getMessage())));
    }

    @Subscribe
    public void onSyncSuccessEvent(SyncSuccessEvent event) {
        this.factory.getEventHandlerContext().runOnThread(() -> {
            this.factory.getCommandEventBus().post(new LogEvent(event.getMessage()));
            this.factory.getCommandEventBus().post(new QuitEvent());
        });
    }

    @Subscribe
    public void onSyncFailureEvent(SyncFailureEvent event) {
        this.factory.getEventHandlerContext().runOnThread(() -> {
            this.factory.getCommandEventBus().post(new LogEvent(event.getMessage()));
            this.factory.getCommandEventBus().post(new QuitEvent());
        });
    }
}

