/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.commandline.salesmerge;

import com.google.common.eventbus.Subscribe;
import com.systel.sync.business.salesmerge.events.SalesMergeFailureEvent;
import com.systel.sync.business.salesmerge.events.SalesMergeProgressEvent;
import com.systel.sync.business.salesmerge.events.SalesMergeSuccessEvent;
import com.systel.sync.commandline.common.BaseCommand;
import com.systel.sync.commandline.common.BaseFactory;
import com.systel.sync.commandline.common.events.LogEvent;
import com.systel.sync.commandline.common.events.QuitEvent;

public class SalesMergeCommand
implements BaseCommand {
    private BaseFactory factory;

    public SalesMergeCommand(BaseFactory factory) {
        this.factory = factory;
        this.factory.getCommandEventBus().register(this);
        this.factory.getLibEventBus().register(this);
    }

    @Override
    public void onInitialize() {
    }

    @Override
    public void onFinalize() {
        this.factory.getLibEventBus().unregister(this);
        this.factory.getCommandEventBus().unregister(this);
        this.factory = null;
    }

    @Override
    public void execute(String ... args) {
        this.factory.getSalesMerge().merge(false, null);
    }

    @Subscribe
    public void onSalesMergeProgressEvent(SalesMergeProgressEvent event) {
        this.factory.getEventHandlerContext().runOnThread(() -> this.factory.getCommandEventBus().post(new LogEvent(event.getMessage())));
    }

    @Subscribe
    public void onSalesMergeSuccessEvent(SalesMergeSuccessEvent event) {
        this.factory.getEventHandlerContext().runOnThread(() -> {
            this.factory.getCommandEventBus().post(new LogEvent(event.getMessage()));
            this.factory.getCommandEventBus().post(new QuitEvent());
        });
    }

    @Subscribe
    public void onSalesMergeFailureEvent(SalesMergeFailureEvent event) {
        this.factory.getEventHandlerContext().runOnThread(() -> {
            this.factory.getCommandEventBus().post(new LogEvent(event.getMessage()));
            this.factory.getCommandEventBus().post(new QuitEvent());
        });
    }
}

