/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.commandline;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.systel.sync.Context;
import com.systel.sync.commandline.CommandFactory;
import com.systel.sync.commandline.common.BaseCommand;
import com.systel.sync.commandline.common.events.QuitEvent;
import com.systel.sync.commandline.log.LogCommand;
import com.systel.sync.common.ConfigurationProperties;
import com.systel.sync.common.EventHandlerContext;
import com.systel.sync.common.UTF8Control;
import com.systel.sync.log.LogService;
import com.systel.sync.services.common.ConfigurationService;
import com.systel.sync.services.common.ConnectionService;
import java.util.Locale;
import java.util.ResourceBundle;

public class SyncCommandLine {
    private static SyncCommandLine instance;
    private EventHandlerContext eventHandlerContext;
    private ResourceBundle resourceBundle;
    private BaseCommand logCommand;
    private EventBus eventBus;
    private Context context;

    protected SyncCommandLine() {
        boolean encrypted = true;
        ConfigurationService configurationService = new ConfigurationService(new ConfigurationProperties("config.properties"), encrypted);
        ConnectionService connectionService = new ConnectionService(configurationService);
        LogService.getInstance().start(configurationService, connectionService);
        this.context = new Context(configurationService, connectionService);
        this.eventHandlerContext = new RunOnThread();
        this.resourceBundle = ResourceBundle.getBundle("strings/CommandLine", new Locale(configurationService.getLanguage(), configurationService.getCountry()), new UTF8Control());
        this.eventBus = new EventBus();
        this.eventBus.register(this);
        this.logCommand = new LogCommand(this.eventBus, this.resourceBundle, this.eventHandlerContext);
    }

    public static SyncCommandLine getInstance() {
        try {
            instance.equals(instance);
        }
        catch (NullPointerException ex) {
            instance = new SyncCommandLine();
        }
        return instance;
    }

    public EventHandlerContext getEventHandlerContext() {
        return this.eventHandlerContext;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public Context getContext() {
        return this.context;
    }

    public void help() {
        ResourceBundle resourceBundle = this.getResourceBundle();
        System.out.println(resourceBundle.getString("app.title"));
        System.out.println();
        System.out.println(resourceBundle.getString("help.commands"));
        System.out.println(resourceBundle.getString("help.commands.help"));
        System.out.println(resourceBundle.getString("help.commands.sync"));
        System.out.println(resourceBundle.getString("help.commands.sales.merge"));
    }

    public void quit() {
        this.eventBus.unregister(this);
        this.eventBus = null;
        this.logCommand = null;
        this.context.quit();
        System.exit(0);
    }

    @Subscribe
    public void onQuitEvent(QuitEvent event) {
        this.eventHandlerContext.runOnThread(() -> this.quit());
    }

    public static void main(String ... args) {
        try {
            String commandParam = args[1];
            CommandFactory.Builder commandBuilder = new CommandFactory.Builder();
            commandBuilder.build().getCommand(commandParam).execute(args);
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException ex) {
            SyncCommandLine.getInstance().help();
            SyncCommandLine.getInstance().quit();
        }
    }

    public static class RunOnThread
    implements EventHandlerContext {
        @Override
        public void runOnThread(Runnable runnable) {
            new Thread(runnable).start();
        }
    }
}

