/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.commandline;

import com.google.common.eventbus.EventBus;
import com.systel.sync.business.salesmerge.SalesMergeInterface;
import com.systel.sync.business.sync.SyncInterface;
import com.systel.sync.commandline.SyncCommandLine;
import com.systel.sync.commandline.common.BaseCommand;
import com.systel.sync.commandline.common.BaseFactory;
import com.systel.sync.commandline.salesmerge.SalesMergeCommand;
import com.systel.sync.commandline.sync.SyncCommand;
import com.systel.sync.common.EventHandlerContext;
import java.lang.reflect.InvocationTargetException;

public class CommandFactory
implements BaseFactory {
    private static final Class[] defaultClass = new Class[0];
    private static final Object[] defaultObject = new Object[0];

    protected CommandFactory() {
    }

    public BaseCommand getCommand(String commandParam) {
        BaseCommand command = null;
        try {
            command = (BaseCommand)this.getClass().getMethod(this.parseCommand(commandParam), defaultClass).invoke((Object)this, defaultObject);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            SyncCommandLine.getInstance().help();
            SyncCommandLine.getInstance().quit();
        }
        return command;
    }

    public String parseCommand(String commandParam) {
        String[] split = commandParam.split("-");
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (String s2 : split) {
            if (s2.equals("-")) continue;
            if (i < 1) {
                builder.append(s2);
            } else {
                builder.append(s2.replaceFirst(String.valueOf(s2.charAt(0)), String.valueOf(s2.charAt(0)).toUpperCase()));
            }
            ++i;
        }
        return builder.toString();
    }

    public BaseCommand salesMerge() {
        return new SalesMergeCommand(this);
    }

    public BaseCommand sync() {
        return new SyncCommand(this);
    }

    @Override
    public EventBus getCommandEventBus() {
        return SyncCommandLine.getInstance().getEventBus();
    }

    @Override
    public EventBus getLibEventBus() {
        return SyncCommandLine.getInstance().getContext().getEventBus();
    }

    @Override
    public EventHandlerContext getEventHandlerContext() {
        return SyncCommandLine.getInstance().getEventHandlerContext();
    }

    @Override
    public SyncInterface getSync() {
        return SyncCommandLine.getInstance().getContext().getSyncInterface();
    }

    @Override
    public SalesMergeInterface getSalesMerge() {
        return SyncCommandLine.getInstance().getContext().getSalesMergeInterface();
    }

    public static class Builder
    implements CommandFactoryBuilder {
        private CommandFactory commandFactory = new CommandFactory();

        @Override
        public CommandFactory build() {
            return this.commandFactory;
        }
    }

    public static interface CommandFactoryBuilder {
        public CommandFactory build();
    }
}

