/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.business.users;

import com.google.common.eventbus.EventBus;
import com.systel.sync.business.common.BusinessLog;
import com.systel.sync.business.common.entities.User;
import com.systel.sync.business.users.UsersInterface;
import com.systel.sync.business.users.events.SignInFailureEvent;
import com.systel.sync.business.users.events.SignInSuccessEvent;
import com.systel.sync.services.common.ServiceCallback;
import com.systel.sync.services.users.UsersServiceInterface;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;

public final class UsersManager
implements UsersInterface {
    private static final String LOG_TAG = UsersManager.class.getSimpleName();
    private final UsersServiceInterface service;
    private final ExecutorService executor;
    private final EventBus eventBus;
    private final ResourceBundle resourceBundle;
    private User user;

    public UsersManager(UsersServiceInterface service, EventBus eventBus, ExecutorService executor, ResourceBundle resourceBundle) {
        this.service = service;
        this.executor = executor;
        this.resourceBundle = resourceBundle;
        this.eventBus = eventBus;
        this.eventBus.register(this);
    }

    @Override
    public void signIn(User user) {
        this.executor.execute(() -> this.service.signIn(user, new ServiceCallback<User, Integer>(){

            @Override
            public void onSuccess(User user) {
                UsersManager.this.setUser(user);
                String message = UsersManager.this.resourceBundle.getString("users.sign.in.success");
                BusinessLog.logDebug(LOG_TAG, message);
                UsersManager.this.eventBus.post(new SignInSuccessEvent(message));
            }

            @Override
            public void onFailure(Integer data) {
                String message = UsersManager.this.resourceBundle.getString("users.sign.in.failure");
                BusinessLog.logError(LOG_TAG, message);
                UsersManager.this.eventBus.post(new SignInFailureEvent(message));
            }
        }));
    }

    @Override
    public void setUser(User user) {
        this.user = user;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public TreeSet<User> getAvaiableUsers() {
        return this.service.getAvaiableUsers();
    }
}

