/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.business.tools;

import com.google.common.eventbus.EventBus;
import com.systel.sync.business.common.BusinessLog;
import com.systel.sync.business.common.entities.ToolsData;
import com.systel.sync.business.tools.ToolsInterface;
import com.systel.sync.business.tools.events.GetToolsFailureEvent;
import com.systel.sync.business.tools.events.GetToolsSuccessEvent;
import com.systel.sync.business.tools.events.UpdateToolsFailureEvent;
import com.systel.sync.business.tools.events.UpdateToolsSuccessEvent;
import com.systel.sync.services.common.ServiceCallback;
import com.systel.sync.services.tools.ToolsServiceInterface;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;

public final class ToolsManager
implements ToolsInterface {
    private static final String LOG_TAG = ToolsManager.class.getSimpleName();
    private final ToolsServiceInterface service;
    private final ExecutorService executor;
    private final EventBus eventBus;
    private final ResourceBundle resourceBundle;
    private ToolsData ToolsData;

    public ToolsManager(ToolsServiceInterface service, EventBus eventBus, ExecutorService executor, ResourceBundle resourceBundle) {
        this.service = service;
        this.executor = executor;
        this.eventBus = eventBus;
        this.resourceBundle = resourceBundle;
    }

    @Override
    public void load() {
        this.service.select(new ServiceCallback<ToolsData, Integer>(){

            @Override
            public void onSuccess(ToolsData data) {
                ToolsManager.this.setData(data);
                String message = ToolsManager.this.resourceBundle.getString("preferences.load.success");
                BusinessLog.logDebug(LOG_TAG, message);
                ToolsManager.this.eventBus.post(new GetToolsSuccessEvent(message));
            }

            @Override
            public void onFailure(Integer data) {
                String message = ToolsManager.this.resourceBundle.getString("preferences.load.failure");
                BusinessLog.logError(LOG_TAG, message);
                ToolsManager.this.eventBus.post(new GetToolsFailureEvent(message));
            }
        });
    }

    @Override
    public void update(final ToolsData ToolsData2) {
        this.executor.execute(() -> this.service.update(ToolsData2, new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                ToolsManager.this.setData(ToolsData2);
                String message = ToolsManager.this.resourceBundle.getString("preferences.update.success");
                BusinessLog.logDebug(LOG_TAG, message);
                ToolsManager.this.eventBus.post(new UpdateToolsSuccessEvent(message));
            }

            @Override
            public void onFailure(Integer data) {
                String message = ToolsManager.this.resourceBundle.getString("preferences.update.failure");
                BusinessLog.logError(LOG_TAG, message);
                ToolsManager.this.eventBus.post(new UpdateToolsFailureEvent(message));
            }
        }));
    }

    @Override
    public ToolsData getData() {
        return this.ToolsData;
    }

    @Override
    public void setData(ToolsData ToolsData2) {
        this.ToolsData = ToolsData2;
    }
}

