/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.business.sync.process;

import com.systel.sync.business.sync.common.ProcessInterface;
import com.systel.sync.business.sync.common.ProgressCallerInterface;
import com.systel.sync.common.sql.SQLDateTimeUtils;
import com.systel.sync.services.common.ServiceCallback;
import com.systel.sync.services.common.entities.ServiceNodeConnection;
import com.systel.sync.services.common.entities.ServiceNodeStatus;
import com.systel.sync.services.common.entities.ServiceTable;
import com.systel.sync.services.sync.local.SyncLocalServiceInterface;
import com.systel.sync.services.sync.remote.SyncRemoteServiceInterface;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import javax.validation.constraints.NotNull;

public final class StatusVerification
implements ProcessInterface {
    private SyncLocalServiceInterface localService;
    private SyncRemoteServiceInterface remoteService;
    private ExecutorService executor;
    private ExecutorService setupExecutor;
    private ProgressCallerInterface progressCaller;
    private Long nodeId = null;
    private ArrayList<Long> nodeIds = new ArrayList();

    public StatusVerification(@NotNull SyncLocalServiceInterface localService, @NotNull SyncRemoteServiceInterface remoteService, @NotNull ExecutorService executor) {
        this.localService = localService;
        this.remoteService = remoteService;
        this.executor = executor;
    }

    @Override
    public void execute(@NotNull ProgressCallerInterface progressCaller) {
        this.execute((Long)null, progressCaller);
    }

    @Override
    public void execute(Long nodeId, @NotNull ProgressCallerInterface progressCaller) {
        this.nodeId = nodeId;
        this.progressCaller = progressCaller;
        this.nodeIds.add(nodeId);
        progressCaller.defaultProgress("verify.status.start", true);
        if (nodeId == null) {
            this.PingNode(null);
        } else {
            this.PingNode(this.nodeIds);
        }
    }

    @Override
    public void execute(ArrayList<Long> nodeIds, @NotNull ProgressCallerInterface progressCaller) {
        this.nodeIds = nodeIds;
        this.progressCaller = progressCaller;
        progressCaller.defaultProgress("verify.status.start", true);
        this.PingNode(this.nodeIds);
    }

    private void PingNode(final ArrayList<Long> nodesIds) {
        this.executor.execute(() -> this.localService.selectNodes(new ServiceCallback<TreeSet<ServiceNodeConnection>, Integer>(){

            @Override
            public void onSuccess(TreeSet<ServiceNodeConnection> nodeConnections) {
                ArrayList<String> nodeIps = new ArrayList<String>();
                if (nodeConnections.size() > 0) {
                    try {
                        if (nodesIds == null) {
                            ArrayList<Long> nodes = new ArrayList<Long>();
                            for (ServiceNodeConnection node : nodeConnections) {
                                nodes.add(node.getId());
                            }
                            StatusVerification.this.nodeIds = nodes;
                        }
                        for (ServiceNodeConnection node : nodeConnections) {
                            int i;
                            String host = node.getIpAddress();
                            InetAddress inetAddress = InetAddress.getByName(host);
                            int cont = 0;
                            for (i = 0; i < 5; ++i) {
                                boolean reachable = inetAddress.isReachable(500);
                                if (!reachable) continue;
                                ++cont;
                            }
                            if (cont > 0) {
                                nodeIps.add(host);
                                cont = 0;
                                continue;
                            }
                            for (i = 0; i < StatusVerification.this.nodeIds.size(); ++i) {
                                if (((Long)StatusVerification.this.nodeIds.get(i)).longValue() != node.getId()) continue;
                                StatusVerification.this.nodeIds.remove(i);
                            }
                            node.setStatus(4);
                            StatusVerification.this.updateNodeStatus(node, node.getStatus(), false);
                            cont = 0;
                        }
                    }
                    catch (IOException iOException) {}
                } else {
                    StatusVerification.this.progressCaller.successProgress("verify.status.select.node.connections.no.connections.success");
                    StatusVerification.this.progressCaller.success("verify.status.end.success");
                }
                if (StatusVerification.this.nodeIds.size() > 0) {
                    StatusVerification.this.updateDb(nodeIps);
                } else {
                    StatusVerification.this.progressCaller.failureProgress("verify.status.select.node.connections.no.connections.success");
                    StatusVerification.this.progressCaller.failure("verify.status.end.failure");
                }
            }

            @Override
            public void onFailure(Integer data) {
                StatusVerification.this.progressCaller.failureProgress("verify.status.select.node.connections.failure");
                StatusVerification.this.progressCaller.failure("verify.status.end.failure");
            }
        }, nodesIds));
    }

    private void updateDb(ArrayList<String> nodeIps) {
        this.executor.execute(() -> this.localService.updateDb(new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                StatusVerification.this.progressCaller.defaultProgress("db.update.success");
                StatusVerification.this.deleteOldLogs(SQLDateTimeUtils.now());
            }

            @Override
            public void onFailure(Integer data) {
                StatusVerification.this.progressCaller.failure("db.update.failure");
            }
        }, nodeIps, System.getProperty("os.name")));
    }

    private void deleteOldLogs(final String startDate) {
        this.executor.execute(() -> this.localService.deleteOldLogs(new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                StatusVerification.this.progressCaller.defaultProgress("verify.status.delete.old.logs.success");
                if (StatusVerification.this.nodeId != null && StatusVerification.this.nodeIds.size() < 2) {
                    StatusVerification.this.selectNodeConnection(startDate);
                } else {
                    StatusVerification.this.selectNodeConnections(startDate);
                }
            }

            @Override
            public void onFailure(Integer data) {
                StatusVerification.this.progressCaller.failureProgress("verify.status.delete.old.logs.failure");
                if (StatusVerification.this.nodeId != null) {
                    StatusVerification.this.selectNodeConnection(startDate);
                } else {
                    StatusVerification.this.selectNodeConnections(startDate);
                }
            }
        }));
    }

    private void selectNodeConnection(final String startDate) {
        this.executor.execute(() -> this.localService.selectNode(this.nodeId, new ServiceCallback<ServiceNodeConnection, Integer>(){

            @Override
            public void onSuccess(ServiceNodeConnection nodeConnection) {
                TreeSet<ServiceNodeConnection> nodeConnections = new TreeSet<ServiceNodeConnection>();
                nodeConnections.add(nodeConnection);
                StatusVerification.this.progressCaller.defaultProgress("verify.status.select.node.connections.success");
                StatusVerification.this.selectServiceTables(startDate, nodeConnections);
            }

            @Override
            public void onFailure(Integer data) {
                StatusVerification.this.progressCaller.failureProgress("verify.status.select.node.connections.failure");
                StatusVerification.this.progressCaller.failure("verify.status.end.failure");
            }
        }));
    }

    private void selectNodeConnections(final String startDate) {
        this.executor.execute(() -> this.localService.selectNodes(new ServiceCallback<TreeSet<ServiceNodeConnection>, Integer>(){

            @Override
            public void onSuccess(TreeSet<ServiceNodeConnection> nodeConnections) {
                if (nodeConnections.size() > 0) {
                    StatusVerification.this.progressCaller.defaultProgress("verify.status.select.node.connections.success");
                    StatusVerification.this.selectServiceTables(startDate, nodeConnections);
                } else {
                    StatusVerification.this.progressCaller.successProgress("verify.status.select.node.connections.no.connections.success");
                    StatusVerification.this.progressCaller.success("verify.status.end.success");
                }
            }

            @Override
            public void onFailure(Integer data) {
                StatusVerification.this.progressCaller.failureProgress("verify.status.select.node.connections.failure");
                StatusVerification.this.progressCaller.failure("verify.status.end.failure");
            }
        }, this.nodeIds));
    }

    private void selectServiceTables(final String startDate, final TreeSet<ServiceNodeConnection> nodeConnections) {
        this.executor.execute(() -> this.localService.selectTables("0", new ServiceCallback<TreeSet<ServiceTable>, Integer>(){

            @Override
            public void onSuccess(TreeSet<ServiceTable> localTables) {
                StatusVerification.this.progressCaller.defaultProgress("verify.status.select.service.tables.success");
                StatusVerification.this.createHashFunctionInMaster(startDate, nodeConnections, localTables);
            }

            @Override
            public void onFailure(Integer data) {
                StatusVerification.this.progressCaller.failureProgress("verify.status.select.service.tables.failure");
                StatusVerification.this.progressCaller.failure("verify.status.end.failure");
            }
        }));
    }

    private void createHashFunctionInMaster(final String startDate, final TreeSet<ServiceNodeConnection> nodeConnections, final TreeSet<ServiceTable> localTables) {
        this.executor.execute(() -> this.remoteService.createHashFunctionInMaster(new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                StatusVerification.this.progressCaller.defaultProgress("verify.status.create.master.hash.function.success");
                StatusVerification.this.selectMasterTableHashes(startDate, nodeConnections, localTables);
            }

            @Override
            public void onFailure(Integer data) {
                StatusVerification.this.progressCaller.failureProgress("verify.status.create.master.hash.function.failure");
                StatusVerification.this.progressCaller.failure("verify.status.end.failure");
            }
        }));
    }

    private void selectMasterTableHashes(String startDate, final TreeSet<ServiceNodeConnection> nodeConnections, TreeSet<ServiceTable> localTables) {
        this.executor.execute(() -> this.remoteService.selectMasterTableHashes(localTables, new ServiceCallback<TreeSet<ServiceTable>, Integer>(){

            @Override
            public void onSuccess(TreeSet<ServiceTable> masterTables) {
                StatusVerification.this.progressCaller.defaultProgress("verify.status.select.master.table.hash.success");
                StatusVerification.this.createHashFunctionInNodes(nodeConnections, masterTables);
            }

            @Override
            public void onFailure(Integer data) {
                StatusVerification.this.progressCaller.failureProgress("verify.status.select.master.table.hash.failure");
                StatusVerification.this.progressCaller.failure("verify.status.end.failure");
            }
        }));
    }

    private void createHashFunctionInNodes(final TreeSet<ServiceNodeConnection> nodeConnections, final TreeSet<ServiceTable> masterTables) {
        this.executor.execute(() -> this.remoteService.createHashFunctionInNodes(nodeConnections, new ServiceCallback<ArrayList<ServiceNodeStatus>, Integer>(){

            @Override
            public void onSuccess(ArrayList<ServiceNodeStatus> nodesStatus) {
                StatusVerification.this.progressCaller.defaultProgress("verify.status.create.hash.function.in.nodes.success");
                ArrayList temp = new ArrayList(nodeConnections);
                int initialized = 0;
                for (ServiceNodeStatus nodeStatus : nodesStatus) {
                    if (nodeStatus.getStatus() == 0 || nodeStatus.getStatus() == 4) {
                        ServiceNodeConnection nodeConnection = new ServiceNodeConnection(nodeStatus.getId());
                        ServiceNodeConnection node = (ServiceNodeConnection)temp.get(temp.indexOf(nodeConnection));
                        nodeConnections.remove(nodeConnection);
                        StatusVerification.this.updateNodeStatus(node, nodeStatus.getStatus(), false);
                        continue;
                    }
                    ++initialized;
                }
                if (initialized > 0) {
                    StatusVerification.this.compareNodesHashes(nodeConnections, masterTables);
                } else {
                    StatusVerification.this.progressCaller.failureProgress("verify.status.create.hash.function.in.nodes.failure");
                    StatusVerification.this.progressCaller.failure("verify.status.end.failure");
                }
            }

            @Override
            public void onFailure(Integer data) {
                StatusVerification.this.progressCaller.failureProgress("verify.status.create.hash.function.in.nodes.failure");
                ArrayList<ServiceNodeStatus> nodesStatus = new ArrayList<ServiceNodeStatus>();
                for (ServiceNodeConnection nodeConnection : nodeConnections) {
                    nodesStatus.add(new ServiceNodeStatus(nodeConnection.getId(), 0));
                }
                StatusVerification.this.updateNodesSyncStatus(nodeConnections, nodesStatus);
            }
        }));
    }

    private void compareNodesHashes(final TreeSet<ServiceNodeConnection> nodeConnections, TreeSet<ServiceTable> masterTables) {
        this.executor.execute(() -> this.remoteService.compareNodeHashes(nodeConnections, masterTables, new ServiceCallback<ArrayList<ServiceNodeStatus>, Integer>(){

            @Override
            public void onSuccess(ArrayList<ServiceNodeStatus> nodesStatus) {
                StatusVerification.this.progressCaller.defaultProgress("verify.status.compare.nodes.hashes.success");
                StatusVerification.this.updateNodesSyncStatus(nodeConnections, nodesStatus);
            }

            @Override
            public void onFailure(Integer data) {
                StatusVerification.this.progressCaller.failureProgress("verify.status.compare.nodes.hashes.failure");
                StatusVerification.this.progressCaller.failure("verify.status.end.failure");
            }
        }));
    }

    private void updateNodesSyncStatus(final TreeSet<ServiceNodeConnection> nodeConnections, final ArrayList<ServiceNodeStatus> nodesStatus) {
        this.executor.execute(() -> this.localService.updateVerificationNodesSyncStatus(nodesStatus, new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                StatusVerification.this.progressCaller.defaultProgress("verify.status.update.nodes.sync.status.success");
                for (ServiceNodeStatus nodeStatus : nodesStatus) {
                    for (ServiceNodeConnection nodeConnection : nodeConnections) {
                        if (nodeConnection.getId() != nodeStatus.getId()) continue;
                        StatusVerification.this.updateNodeStatus(nodeConnection, nodeStatus.getStatus(), false);
                    }
                }
            }

            @Override
            public void onFailure(Integer data) {
                StatusVerification.this.progressCaller.failureProgress("verify.status.update.nodes.sync.status.failure");
                StatusVerification.this.progressCaller.failure("verify.status.end.failure");
            }
        }));
    }

    private void updateNodeStatus(final ServiceNodeConnection nodeConnection, final int status, final boolean isEnd) {
        this.executor.execute(() -> this.localService.updateVerificationNodeSyncStatus(new ServiceNodeStatus(nodeConnection.getId(), status), new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                StatusVerification.this.progressCaller.nodeStatusUpdate(nodeConnection, status);
                if (status == 3) {
                    StatusVerification.this.progressCaller.nodeSuccessProgress("verify.status.update.nodes.status.success", nodeConnection, status);
                } else if (status == 4) {
                    StatusVerification.this.progressCaller.nodeFailureProgress("verify.status.update.nodes.status.failure", nodeConnection, status);
                }
                if (isEnd) {
                    StatusVerification.this.progressCaller.success("verify.status.end.success");
                }
            }

            @Override
            public void onFailure(Integer data) {
                StatusVerification.this.progressCaller.nodeFailureProgress("verify.status.update.nodes.status.failure", nodeConnection, status);
                if (isEnd) {
                    StatusVerification.this.progressCaller.failure("verify.status.end.failure");
                }
            }
        }));
    }
}

