/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.business.sync.process;

import com.systel.sync.business.sync.common.ProcessInterface;
import com.systel.sync.business.sync.common.ProgressCallerInterface;
import com.systel.sync.services.common.ServiceCallback;
import com.systel.sync.services.sync.local.SyncLocalServiceInterface;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import javax.validation.constraints.NotNull;

public final class StatusReset
implements ProcessInterface {
    private SyncLocalServiceInterface localService;
    private ExecutorService executor;
    private ProgressCallerInterface progressCaller;
    private Long nodeId = null;
    private ArrayList<Long> nodes = new ArrayList();

    public StatusReset(@NotNull SyncLocalServiceInterface localService, @NotNull ExecutorService executor) {
        this.localService = localService;
        this.executor = executor;
    }

    @Override
    public void execute(@NotNull ProgressCallerInterface progressCaller) {
        this.execute((Long)null, progressCaller);
    }

    @Override
    public void execute(Long nodeId, @NotNull ProgressCallerInterface progressCaller) {
        this.nodeId = nodeId;
        this.progressCaller = progressCaller;
        progressCaller.defaultProgress("reset.status.start", true);
        this.resetStatus();
    }

    @Override
    public void execute(ArrayList<Long> nodes, ProgressCallerInterface progressCaller) {
        this.nodes = nodes;
        this.progressCaller = progressCaller;
        progressCaller.defaultProgress("diff.sync.start", true);
        this.resetStatus();
    }

    private void resetStatus() {
        this.executor.execute(() -> this.localService.resetStatus(0, new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                StatusReset.this.progressCaller.success("reset.status.success");
            }

            @Override
            public void onFailure(Integer data) {
                StatusReset.this.progressCaller.failure("reset.status.failure");
            }
        }));
    }
}

