/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.business.sync.process;

import com.systel.sync.business.sync.common.ProcessInterface;
import com.systel.sync.business.sync.common.ProgressCallerInterface;
import com.systel.sync.services.common.ServiceCallback;
import com.systel.sync.services.common.entities.ServiceNodeConnection;
import com.systel.sync.services.sync.local.SyncLocalServiceInterface;
import com.systel.sync.services.sync.remote.SyncRemoteServiceInterface;
import java.util.ArrayList;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import javax.validation.constraints.NotNull;

public final class SetupUpdate
implements ProcessInterface {
    private SyncLocalServiceInterface localService;
    private SyncRemoteServiceInterface remoteService;
    private ExecutorService executor;
    private ProgressCallerInterface progressCaller;
    private Long nodeId = null;
    private ArrayList<Long> nodesIds = new ArrayList();

    public SetupUpdate(@NotNull SyncLocalServiceInterface localService, @NotNull SyncRemoteServiceInterface remoteService, @NotNull ExecutorService executor) {
        this.localService = localService;
        this.remoteService = remoteService;
        this.executor = executor;
    }

    @Override
    public void execute(@NotNull ProgressCallerInterface progressCaller) {
        this.execute((Long)null, progressCaller);
    }

    @Override
    public void execute(Long nodeId, @NotNull ProgressCallerInterface progressCaller) {
        this.nodeId = nodeId;
        this.progressCaller = progressCaller;
        progressCaller.defaultProgress("setup.update.start", true);
        this.selectNodeConnection();
    }

    @Override
    public void execute(ArrayList<Long> nodes, ProgressCallerInterface progressCaller) {
        this.nodesIds = nodes;
        this.progressCaller = progressCaller;
        progressCaller.defaultProgress("setup.update.start", true);
        this.selectNodeConnection();
    }

    private void selectNodeConnection() {
        this.executor.execute(() -> this.localService.selectNodes(new ServiceCallback<TreeSet<ServiceNodeConnection>, Integer>(){

            @Override
            public void onSuccess(TreeSet<ServiceNodeConnection> nodeConnections) {
                if (nodeConnections.size() > 0) {
                    SetupUpdate.this.progressCaller.defaultProgress("setup.update.select.node.connections.success");
                    for (ServiceNodeConnection node : nodeConnections) {
                        SetupUpdate.this.updateNodesSetup(node);
                    }
                } else {
                    SetupUpdate.this.progressCaller.successProgress("setup.update.select.node.connections.no.connections.success");
                    SetupUpdate.this.progressCaller.success("setup.update.end.success");
                }
            }

            @Override
            public void onFailure(Integer data) {
                SetupUpdate.this.progressCaller.failureProgress("setup.update.select.node.connections.failure");
                SetupUpdate.this.progressCaller.failure("setup.update.end.failure");
            }
        }, this.nodesIds));
    }

    private void updateNodesSetup(ServiceNodeConnection nodeConnection) {
        this.executor.execute(() -> this.remoteService.updateNodeSetup(nodeConnection, new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                SetupUpdate.this.progressCaller.success("diff.sync.end.success");
            }

            @Override
            public void onFailure(Integer data) {
                SetupUpdate.this.progressCaller.failure("setup.update.end.failure");
            }
        }));
    }
}

