/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.business.sync.process;

import com.systel.sync.business.sync.common.ProcessInterface;
import com.systel.sync.business.sync.common.ProgressCallerInterface;
import com.systel.sync.services.common.ServiceCallback;
import com.systel.sync.services.common.entities.ServiceNodeConnection;
import com.systel.sync.services.common.entities.ServiceNodeStatus;
import com.systel.sync.services.common.entities.ServiceTable;
import com.systel.sync.services.common.entities.ServiceTableData;
import com.systel.sync.services.common.results.BaseResult;
import com.systel.sync.services.sync.local.SyncLocalServiceInterface;
import com.systel.sync.services.sync.remote.SyncRemoteServiceInterface;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.validation.constraints.NotNull;

public final class FullSync
implements ProcessInterface {
    private SyncLocalServiceInterface localService;
    private SyncRemoteServiceInterface remoteService;
    private ExecutorService executor;
    private ExecutorService syncExecutor;
    private ProgressCallerInterface progressCaller;
    private Long nodeId = null;
    private ArrayList<Long> nodeIds = new ArrayList();

    public FullSync(@NotNull SyncLocalServiceInterface localService, @NotNull SyncRemoteServiceInterface remoteService, @NotNull ExecutorService executor) {
        this.localService = localService;
        this.remoteService = remoteService;
        this.executor = executor;
        this.syncExecutor = Executors.newFixedThreadPool(1);
    }

    @Override
    public void execute(ProgressCallerInterface progressCaller) {
        this.execute((Long)null, progressCaller);
    }

    @Override
    public void execute(Long nodeId, @NotNull ProgressCallerInterface progressCaller) {
        this.nodeId = nodeId;
        this.progressCaller = progressCaller;
        this.nodeIds.add(nodeId);
        progressCaller.defaultProgress("full.sync.start", true);
        if (nodeId == null) {
            this.PingNode(null);
        } else {
            this.PingNode(this.nodeIds);
        }
    }

    @Override
    public void execute(ArrayList<Long> nodeIds, ProgressCallerInterface progressCaller) {
        this.nodeIds = nodeIds;
        this.progressCaller = progressCaller;
        progressCaller.defaultProgress("diff.sync.start", true);
        this.PingNode(this.nodeIds);
    }

    private void PingNode(final ArrayList<Long> nodesIds) {
        this.executor.execute(() -> this.localService.selectNodes(new ServiceCallback<TreeSet<ServiceNodeConnection>, Integer>(){

            @Override
            public void onSuccess(TreeSet<ServiceNodeConnection> nodeConnections) {
                ArrayList<String> nodeIps = new ArrayList<String>();
                if (nodeConnections.size() > 0) {
                    try {
                        if (nodesIds == null) {
                            ArrayList<Long> nodes = new ArrayList<Long>();
                            for (ServiceNodeConnection node : nodeConnections) {
                                nodes.add(node.getId());
                            }
                            FullSync.this.nodeIds = nodes;
                        }
                        for (ServiceNodeConnection node : nodeConnections) {
                            int i;
                            String host = node.getIpAddress();
                            InetAddress inetAddress = InetAddress.getByName(host);
                            int cont = 0;
                            for (i = 0; i < 5; ++i) {
                                boolean reachable = inetAddress.isReachable(500);
                                if (!reachable) continue;
                                ++cont;
                            }
                            if (cont > 0) {
                                nodeIps.add(host);
                                cont = 0;
                                continue;
                            }
                            for (i = 0; i < FullSync.this.nodeIds.size(); ++i) {
                                if (((Long)FullSync.this.nodeIds.get(i)).longValue() != node.getId()) continue;
                                FullSync.this.nodeIds.remove(i);
                            }
                            node.setStatus(4);
                            FullSync.this.updateSyncedNodeSyncStatus(node, node.getStatus());
                        }
                    }
                    catch (IOException iOException) {}
                } else {
                    FullSync.this.progressCaller.successProgress("verify.status.select.node.connections.no.connections.success");
                    FullSync.this.progressCaller.success("verify.status.end.success");
                }
                if (FullSync.this.nodeIds.size() > 0) {
                    FullSync.this.updateDb(nodeIps);
                } else {
                    FullSync.this.progressCaller.successProgress("verify.status.select.node.connections.no.connections.success");
                    FullSync.this.progressCaller.success("verify.status.end.success");
                }
            }

            @Override
            public void onFailure(Integer data) {
                FullSync.this.progressCaller.failureProgress("verify.status.select.node.connections.failure");
                FullSync.this.progressCaller.failure("verify.status.end.failure");
            }
        }, nodesIds));
    }

    private void updateDb(ArrayList<String> nodeIps) {
        this.executor.execute(() -> this.localService.updateDb(new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                FullSync.this.progressCaller.defaultProgress("db.update.success");
                FullSync.this.deleteOldLogs();
            }

            @Override
            public void onFailure(Integer data) {
                FullSync.this.progressCaller.failure("db.update.success");
            }
        }, nodeIps, System.getProperty("os.name")));
    }

    private void deleteOldLogs() {
        this.executor.execute(() -> this.localService.deleteOldLogs(new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                FullSync.this.progressCaller.defaultProgress("full.sync.delete.old.logs.success");
                if (FullSync.this.nodeId != null) {
                    FullSync.this.selectNodeConnection();
                } else {
                    FullSync.this.selectNodeConnections();
                }
            }

            @Override
            public void onFailure(Integer data) {
                FullSync.this.progressCaller.failureProgress("full.sync.delete.old.logs.failure");
                if (FullSync.this.nodeId != null) {
                    FullSync.this.selectNodeConnection();
                } else {
                    FullSync.this.selectNodeConnections();
                }
            }
        }));
    }

    private void selectNodeConnection() {
        this.executor.execute(() -> this.localService.selectNode(this.nodeId, new ServiceCallback<ServiceNodeConnection, Integer>(){

            @Override
            public void onSuccess(ServiceNodeConnection nodeConnection) {
                TreeSet<ServiceNodeConnection> nodeConnections = new TreeSet<ServiceNodeConnection>();
                nodeConnections.add(nodeConnection);
                FullSync.this.progressCaller.defaultProgress("full.sync.select.node.connections.success");
                FullSync.this.selectServiceTables(nodeConnections);
            }

            @Override
            public void onFailure(Integer data) {
                FullSync.this.progressCaller.failureProgress("v.sync.select.node.connections.failure");
                FullSync.this.progressCaller.failure("full.sync.end.failure");
            }
        }));
    }

    private void selectNodeConnections() {
        this.executor.execute(() -> this.localService.selectNodes(new ServiceCallback<TreeSet<ServiceNodeConnection>, Integer>(){

            @Override
            public void onSuccess(TreeSet<ServiceNodeConnection> nodeConnections) {
                if (nodeConnections.size() > 0) {
                    FullSync.this.progressCaller.defaultProgress("full.sync.select.node.connections.success");
                    FullSync.this.selectServiceTables(nodeConnections);
                } else {
                    FullSync.this.progressCaller.successProgress("full.sync.select.node.connections.no.connections.success");
                    FullSync.this.progressCaller.success("full.sync.end.success");
                }
            }

            @Override
            public void onFailure(Integer data) {
                FullSync.this.progressCaller.failureProgress("full.sync.select.node.connections.failure");
                FullSync.this.progressCaller.failure("full.sync.end.failure");
            }
        }, this.nodeIds));
    }

    private void selectServiceTables(final TreeSet<ServiceNodeConnection> nodeConnections) {
        this.executor.execute(() -> this.localService.selectTables("2", new ServiceCallback<TreeSet<ServiceTable>, Integer>(){

            @Override
            public void onSuccess(TreeSet<ServiceTable> localTables) {
                FullSync.this.progressCaller.defaultProgress("full.sync.select.service.tables.success");
                FullSync.this.createHashFunctionInMaster(nodeConnections, localTables);
            }

            @Override
            public void onFailure(Integer data) {
                FullSync.this.progressCaller.failureProgress("full.sync.select.service.tables.failure");
                FullSync.this.progressCaller.failure("full.sync.end.failure");
            }
        }));
    }

    private void createHashFunctionInMaster(final TreeSet<ServiceNodeConnection> nodeConnections, final TreeSet<ServiceTable> localTables) {
        this.executor.execute(() -> this.remoteService.createHashFunctionInMaster(new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                FullSync.this.progressCaller.defaultProgress("full.sync.create.master.hash.function.success");
                FullSync.this.selectMasterTableHashes(nodeConnections, localTables);
            }

            @Override
            public void onFailure(Integer data) {
                FullSync.this.progressCaller.failureProgress("full.sync.create.master.hash.function.failure");
                FullSync.this.progressCaller.failure("full.sync.end.failure");
            }
        }));
    }

    private void selectMasterTableHashes(final TreeSet<ServiceNodeConnection> nodeConnections, TreeSet<ServiceTable> localTables) {
        this.executor.execute(() -> this.remoteService.selectMasterTableHashes(localTables, new ServiceCallback<TreeSet<ServiceTable>, Integer>(){

            @Override
            public void onSuccess(TreeSet<ServiceTable> masterTables) {
                FullSync.this.progressCaller.defaultProgress("full.sync.select.master.table.hash.success");
                FullSync.this.selectMasterData(nodeConnections, masterTables);
            }

            @Override
            public void onFailure(Integer data) {
                FullSync.this.progressCaller.failureProgress("full.sync.select.master.table.hash.failure");
                FullSync.this.progressCaller.failure("full.sync.end.failure");
            }
        }));
    }

    private void selectMasterData(final TreeSet<ServiceNodeConnection> nodeConnections, final TreeSet<ServiceTable> localTables) {
        this.executor.execute(() -> this.remoteService.selectMasterData(localTables, new ServiceCallback<LinkedHashMap<Integer, ServiceTableData>, Integer>(){

            @Override
            public void onSuccess(LinkedHashMap<Integer, ServiceTableData> masterTableData) {
                FullSync.this.progressCaller.defaultProgress("full.sync.select.master.data.success");
                FullSync.this.createHashFunctionInNodes(nodeConnections, localTables, masterTableData);
            }

            @Override
            public void onFailure(Integer data) {
                FullSync.this.progressCaller.failureProgress("full.sync.select.master.data.failure");
                FullSync.this.progressCaller.failure("full.sync.end.failure");
            }
        }));
    }

    private void createHashFunctionInNodes(final TreeSet<ServiceNodeConnection> nodeConnections, final TreeSet<ServiceTable> localTables, final LinkedHashMap<Integer, ServiceTableData> masterTableData) {
        this.executor.execute(() -> this.remoteService.createHashFunctionInNodes(nodeConnections, new ServiceCallback<ArrayList<ServiceNodeStatus>, Integer>(){

            @Override
            public void onSuccess(ArrayList<ServiceNodeStatus> nodesStatus) {
                FullSync.this.progressCaller.defaultProgress("diff.sync.create.hash.function.in.nodes.success");
                ArrayList temp = new ArrayList(nodeConnections);
                for (ServiceNodeStatus nodeStatus : nodesStatus) {
                    if (nodeStatus.getStatus() != 0 && nodeStatus.getStatus() != 4) continue;
                    ServiceNodeConnection nodeConnection = new ServiceNodeConnection(nodeStatus.getId());
                    ServiceNodeConnection node = (ServiceNodeConnection)temp.get(temp.indexOf(nodeConnection));
                    nodeConnections.remove(nodeConnection);
                    FullSync.this.updateNodeSyncStatus(node, nodeStatus.getStatus());
                }
                FullSync.this.syncNodes(nodeConnections, localTables, masterTableData);
            }

            @Override
            public void onFailure(Integer data) {
                FullSync.this.progressCaller.failureProgress("diff.sync.create.hash.function.in.nodes.failure");
                ArrayList<ServiceNodeStatus> nodesStatus = new ArrayList<ServiceNodeStatus>();
                for (ServiceNodeConnection nodeSyncStatus : nodeConnections) {
                    nodesStatus.add(new ServiceNodeStatus(nodeSyncStatus.getId(), 0));
                }
                FullSync.this.updateNodesSyncStatus(nodesStatus);
            }
        }));
    }

    private void syncNodes(TreeSet<ServiceNodeConnection> nodeConnections, TreeSet<ServiceTable> localTables, LinkedHashMap<Integer, ServiceTableData> masterTableData) {
        HashSet<Future<BaseResult>> set = new HashSet<Future<BaseResult>>();
        for (ServiceNodeConnection serviceNodeConnection : nodeConnections) {
            Future<BaseResult> future = this.syncExecutor.submit(() -> {
                this.truncateNodeTables(nodeConnection, localTables, masterTableData);
                return new BaseResult(0);
            });
            set.add(future);
        }
        for (Future future : set) {
            try {
                BaseResult baseResult = (BaseResult)future.get();
            }
            catch (InterruptedException | NullPointerException | ExecutionException exception) {}
        }
        this.progressCaller.success("full.sync.end.success");
    }

    private void truncateNodeTables(final ServiceNodeConnection nodeConnection, final TreeSet<ServiceTable> localTables, final LinkedHashMap<Integer, ServiceTableData> masterTableData) {
        this.remoteService.truncateTables(nodeConnection, localTables, new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                FullSync.this.progressCaller.nodeDefaultProgress("full.sync.truncate.node.tables.success", nodeConnection);
                FullSync.this.updateNodeWithTableData(nodeConnection, localTables, masterTableData);
            }

            @Override
            public void onFailure(Integer data) {
                FullSync.this.progressCaller.nodeFailureProgress("full.sync.truncate.node.tables.failure", nodeConnection);
                FullSync.this.syncFailure(nodeConnection, data);
            }
        });
    }

    private void updateNodeWithTableData(final ServiceNodeConnection nodeConnection, TreeSet<ServiceTable> localTables, LinkedHashMap<Integer, ServiceTableData> totalTableRowDataNotSynced) {
        for (Object object : localTables.toArray()) {
            ServiceTable table = (ServiceTable)object;
            if (!table.getName().equals("invoice") && !table.getName().equals("invoiceline")) continue;
            localTables.remove(table);
        }
        this.remoteService.updateNodeWithUpdatedData(nodeConnection, localTables, true, totalTableRowDataNotSynced, new ServiceCallback<Boolean, Integer>(){

            @Override
            public void onSuccess(Boolean isPartial) {
                FullSync.this.progressCaller.nodeDefaultProgress("full.sync.update.node.with.table.data.success", nodeConnection);
                FullSync.this.updateSyncedNodeSyncStatus(nodeConnection, isPartial != false ? 2 : 3);
            }

            @Override
            public void onFailure(Integer data) {
                FullSync.this.progressCaller.nodeFailureProgress("full.sync.update.node.with.table.data.failure", nodeConnection);
                FullSync.this.syncFailure(nodeConnection, data);
            }
        });
    }

    private void syncFailure(ServiceNodeConnection nodeConnection, Integer data) {
        int status = 2;
        switch (data) {
            case -3: {
                status = 4;
            }
        }
        this.updateNodeSyncStatus(nodeConnection, status);
    }

    private void updateNodesSyncStatus(ArrayList<ServiceNodeStatus> nodesStatus) {
        this.executor.execute(() -> this.localService.updateNodesSyncStatus(nodesStatus, new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                FullSync.this.progressCaller.defaultProgress("full.sync.update.nodes.sync.status.success");
            }

            @Override
            public void onFailure(Integer data) {
                FullSync.this.progressCaller.failureProgress("full.sync.update.nodes.sync.status.failure");
                FullSync.this.progressCaller.failure("full.sync.end.failure");
            }
        }));
    }

    private void updateNodeSyncStatus(final ServiceNodeConnection nodeConnection, final int status) {
        this.localService.updateSynchronizationNodeSyncStatus(new ServiceNodeStatus(nodeConnection.getId(), status), new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                FullSync.this.progressCaller.nodeStatusUpdate(nodeConnection, status);
                FullSync.this.progressCaller.nodeSuccessProgress("full.sync.update.nodes.status.success", nodeConnection, status);
            }

            @Override
            public void onFailure(Integer data) {
                FullSync.this.progressCaller.nodeStatusUpdate(nodeConnection, status);
                FullSync.this.progressCaller.nodeFailureProgress("full.sync.update.nodes.status.failure", nodeConnection, status);
            }
        });
    }

    private void updateSyncedNodeSyncStatus(final ServiceNodeConnection nodeConnection, final int status) {
        this.localService.updateSynchronizationNodeSyncStatus(new ServiceNodeStatus(nodeConnection.getId(), status), new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                FullSync.this.progressCaller.nodeStatusUpdate(nodeConnection, status);
                FullSync.this.progressCaller.nodeSuccessProgress("full.sync.update.nodes.status.success", nodeConnection, status);
            }

            @Override
            public void onFailure(Integer data) {
                FullSync.this.progressCaller.nodeStatusUpdate(nodeConnection, status);
                FullSync.this.progressCaller.nodeFailureProgress("full.sync.update.nodes.status.failure", nodeConnection, status);
            }
        });
    }
}

