/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.business.sync.process;

import com.systel.sync.business.sync.common.ProcessInterface;
import com.systel.sync.business.sync.common.ProgressCallerInterface;
import com.systel.sync.services.common.ServiceCallback;
import com.systel.sync.services.common.ServicesLog;
import com.systel.sync.services.common.entities.ServiceNodeConnection;
import com.systel.sync.services.common.entities.ServiceNodeStatus;
import com.systel.sync.services.common.entities.ServiceTable;
import com.systel.sync.services.common.entities.ServiceTableData;
import com.systel.sync.services.common.entities.ServiceTableRow;
import com.systel.sync.services.common.results.BaseResult;
import com.systel.sync.services.sync.local.SyncLocalServiceInterface;
import com.systel.sync.services.sync.remote.SyncRemoteServiceInterface;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.stage.Modality;
import javax.validation.constraints.NotNull;

public final class DiffSync
implements ProcessInterface {
    private SyncLocalServiceInterface localService;
    private SyncRemoteServiceInterface remoteService;
    private ExecutorService executor;
    private ExecutorService syncExecutor;
    private ProgressCallerInterface progressCaller;
    private Long nodeId = null;
    private ArrayList<Long> nodeIds = new ArrayList();
    private ResourceBundle resourceBundle;

    public DiffSync(@NotNull SyncLocalServiceInterface localService, @NotNull SyncRemoteServiceInterface remoteService, @NotNull ExecutorService executor, ResourceBundle resourceBundle) {
        this.localService = localService;
        this.remoteService = remoteService;
        this.executor = executor;
        this.syncExecutor = null;
        this.resourceBundle = resourceBundle;
    }

    @Override
    public void execute(@NotNull ProgressCallerInterface progressCaller) {
        this.execute((Long)null, progressCaller);
    }

    @Override
    public void execute(Long nodeId, @NotNull ProgressCallerInterface progressCaller) {
        this.progressCaller = progressCaller;
        this.nodeId = nodeId;
        this.nodeIds.add(nodeId);
        progressCaller.defaultProgress("diff.sync.start", true);
        if (nodeId == null) {
            this.PingNode(null);
        } else {
            this.PingNode(this.nodeIds);
        }
    }

    @Override
    public void execute(ArrayList<Long> nodeIds, ProgressCallerInterface progressCaller) {
        this.nodeIds = nodeIds;
        this.progressCaller = progressCaller;
        progressCaller.defaultProgress("diff.sync.start", true);
        this.PingNode(this.nodeIds);
    }

    private void PingNode(final ArrayList<Long> nodesIds) {
        this.executor.execute(() -> this.localService.selectNodes(new ServiceCallback<TreeSet<ServiceNodeConnection>, Integer>(){

            @Override
            public void onSuccess(TreeSet<ServiceNodeConnection> nodeConnections) {
                ArrayList<String> nodeIps = new ArrayList<String>();
                if (nodeConnections.size() > 0) {
                    try {
                        if (nodesIds == null) {
                            ArrayList<Long> nodes = new ArrayList<Long>();
                            for (ServiceNodeConnection node : nodeConnections) {
                                nodes.add(node.getId());
                            }
                            DiffSync.this.nodeIds = nodes;
                        }
                        for (ServiceNodeConnection node : nodeConnections) {
                            int i;
                            String host = node.getIpAddress();
                            InetAddress inetAddress = InetAddress.getByName(host);
                            int cont = 0;
                            for (i = 0; i < 5; ++i) {
                                boolean reachable = inetAddress.isReachable(500);
                                if (!reachable) continue;
                                ++cont;
                            }
                            if (cont > 0) {
                                nodeIps.add(host);
                                cont = 0;
                                continue;
                            }
                            for (i = 0; i < DiffSync.this.nodeIds.size(); ++i) {
                                if (((Long)DiffSync.this.nodeIds.get(i)).longValue() != node.getId()) continue;
                                DiffSync.this.nodeIds.remove(i);
                            }
                            node.setStatus(4);
                            DiffSync.this.updateNodeSyncStatus(node, node.getStatus(), false);
                        }
                    }
                    catch (IOException iOException) {}
                } else {
                    DiffSync.this.progressCaller.successProgress("verify.status.select.node.connections.no.connections.success");
                    DiffSync.this.progressCaller.success("verify.status.end.success");
                }
                if (DiffSync.this.nodeIds.size() > 0) {
                    DiffSync.this.updateDb(nodeIps);
                } else {
                    DiffSync.this.progressCaller.successProgress("verify.status.select.node.connections.no.connections.success");
                    DiffSync.this.progressCaller.success("verify.status.end.success");
                }
            }

            @Override
            public void onFailure(Integer data) {
                DiffSync.this.progressCaller.failureProgress("verify.status.select.node.connections.failure");
                DiffSync.this.progressCaller.failure("verify.status.end.failure");
            }
        }, nodesIds));
    }

    private void updateDb(ArrayList<String> nodeIps) {
        this.executor.execute(() -> this.localService.updateDb(new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                DiffSync.this.progressCaller.defaultProgress("db.update.success");
                DiffSync.this.deleteOldLogs();
            }

            @Override
            public void onFailure(Integer data) {
                DiffSync.this.progressCaller.failure("db.update.success");
            }
        }, nodeIps, System.getProperty("os.name")));
    }

    private void deleteOldLogs() {
        this.executor.execute(() -> this.localService.deleteOldLogs(new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                DiffSync.this.progressCaller.defaultProgress("diff.sync.delete.old.logs.success");
                DiffSync.this.beforeSync();
            }

            @Override
            public void onFailure(Integer data) {
                DiffSync.this.progressCaller.failureProgress("diff.sync.delete.old.logs.failure");
                DiffSync.this.beforeSync();
            }
        }));
    }

    private void beforeSync() {
        this.executor.execute(() -> this.localService.executeExternalCommand(new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                DiffSync.this.progressCaller.defaultProgress("diff.sync.delete.beforeSync.success");
                if (DiffSync.this.nodeId != null) {
                    DiffSync.this.selectNodeConnection();
                } else {
                    DiffSync.this.selectNodeConnections();
                }
            }

            @Override
            public void onFailure(Integer data) {
                DiffSync.this.progressCaller.failure("diff.sync.delete.beforeSync.failure");
            }
        }));
    }

    private void selectNodeConnection() {
        this.executor.execute(() -> this.localService.selectNode(this.nodeId, new ServiceCallback<ServiceNodeConnection, Integer>(){

            @Override
            public void onSuccess(ServiceNodeConnection nodeConnection) {
                TreeSet<ServiceNodeConnection> nodeConnections = new TreeSet<ServiceNodeConnection>();
                nodeConnections.add(nodeConnection);
                DiffSync.this.progressCaller.defaultProgress("diff.sync.select.node.connections.success");
                DiffSync.this.selectServiceTables(nodeConnections);
            }

            @Override
            public void onFailure(Integer data) {
                DiffSync.this.progressCaller.failureProgress("diff.sync.select.node.connections.failure");
                DiffSync.this.progressCaller.failure("diff.sync.end.failure");
            }
        }));
    }

    private void selectNodeConnections() {
        this.executor.execute(() -> this.localService.selectNodes(new ServiceCallback<TreeSet<ServiceNodeConnection>, Integer>(){

            @Override
            public void onSuccess(TreeSet<ServiceNodeConnection> nodeConnections) {
                if (nodeConnections.size() > 0) {
                    DiffSync.this.progressCaller.defaultProgress("diff.sync.select.node.connections.success");
                    DiffSync.this.selectServiceTables(nodeConnections);
                } else {
                    DiffSync.this.progressCaller.successProgress("diff.sync.select.node.connections.no.connections.success");
                    DiffSync.this.progressCaller.success("diff.sync.end.success");
                }
            }

            @Override
            public void onFailure(Integer data) {
                DiffSync.this.progressCaller.failureProgress("diff.sync.select.node.connections.failure");
                DiffSync.this.progressCaller.failure("diff.sync.end.failure");
            }
        }, this.nodeIds));
    }

    private void selectServiceTables(final TreeSet<ServiceNodeConnection> nodeConnections) {
        this.executor.execute(() -> this.localService.selectTables("0", new ServiceCallback<TreeSet<ServiceTable>, Integer>(){

            @Override
            public void onSuccess(TreeSet<ServiceTable> localTables) {
                DiffSync.this.progressCaller.defaultProgress("diff.sync.select.service.tables.success");
                DiffSync.this.createHashFunctionInMaster(nodeConnections, localTables);
            }

            @Override
            public void onFailure(Integer data) {
                DiffSync.this.progressCaller.failureProgress("diff.sync.select.service.tables.failure");
                DiffSync.this.progressCaller.failure("diff.sync.end.failure");
            }
        }));
    }

    private void createHashFunctionInMaster(final TreeSet<ServiceNodeConnection> nodeConnections, final TreeSet<ServiceTable> localTables) {
        this.executor.execute(() -> this.remoteService.createHashFunctionInMaster(new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                DiffSync.this.progressCaller.defaultProgress("diff.sync.create.master.hash.function.success");
                DiffSync.this.selectMasterTableHashes(nodeConnections, localTables);
            }

            @Override
            public void onFailure(Integer data) {
                DiffSync.this.progressCaller.failureProgress("diff.sync.create.master.hash.function.failure");
                DiffSync.this.progressCaller.failure("diff.sync.end.failure");
            }
        }));
    }

    private void selectMasterTableHashes(final TreeSet<ServiceNodeConnection> nodeConnections, TreeSet<ServiceTable> localTables) {
        this.executor.execute(() -> this.remoteService.selectMasterTableHashes(localTables, new ServiceCallback<TreeSet<ServiceTable>, Integer>(){

            @Override
            public void onSuccess(TreeSet<ServiceTable> masterTables) {
                DiffSync.this.progressCaller.defaultProgress("diff.sync.select.master.table.hash.success");
                DiffSync.this.selectSyncTableHashes(nodeConnections, masterTables);
            }

            @Override
            public void onFailure(Integer data) {
                DiffSync.this.progressCaller.failureProgress("diff.sync.select.master.table.hash.failure");
                DiffSync.this.progressCaller.failure("diff.sync.end.failure");
            }
        }));
    }

    private void selectSyncTableHashes(final TreeSet<ServiceNodeConnection> nodeConnections, TreeSet<ServiceTable> localTables) {
        this.executor.execute(() -> this.localService.selectSyncTableHashes(localTables, new ServiceCallback<TreeSet<ServiceTable>, Integer>(){

            @Override
            public void onSuccess(TreeSet<ServiceTable> masterTables) {
                DiffSync.this.progressCaller.defaultProgress("CAMBIAR: SyncTableHashes CORRECTA");
                DiffSync.this.compareHashesMasterWithSync(nodeConnections, masterTables);
            }

            @Override
            public void onFailure(Integer data) {
                DiffSync.this.progressCaller.failureProgress("CAMBIAR: SyncTableHashes ERROR");
                DiffSync.this.progressCaller.failure("diff.sync.end.failure");
            }
        }));
    }

    private void compareHashesMasterWithSync(final TreeSet<ServiceNodeConnection> nodeConnections, final TreeSet<ServiceTable> masterTables) {
        this.executor.execute(() -> this.localService.compareMasterWithSyncHashes(masterTables, new ServiceCallback<ServiceNodeStatus, Integer>(){

            @Override
            public void onSuccess(ServiceNodeStatus syncStatus) {
                DiffSync.this.progressCaller.defaultProgress("CAMBIAR: CompareSyncWithMaster CORRECTA");
                if (syncStatus.getStatus() == 3) {
                    DiffSync.this.progressCaller.successProgress("SYNC SINCRONIZADA");
                    DiffSync.this.createHashFunctionInNodes(nodeConnections, masterTables);
                } else {
                    DiffSync.this.truncateLocalTables(nodeConnections, syncStatus.getTablesToSync(), masterTables);
                }
            }

            @Override
            public void onFailure(Integer data) {
                DiffSync.this.progressCaller.failureProgress("CAMBIAR: CompareSyncWithMaster ERROR");
                DiffSync.this.progressCaller.failure("diff.sync.end.failure");
            }
        }));
    }

    private void truncateLocalTables(final TreeSet<ServiceNodeConnection> nodeConnections, final TreeSet<ServiceTable> tablesToTruncate, final TreeSet<ServiceTable> masterTables) {
        this.executor.execute(() -> this.localService.truncateTables(tablesToTruncate, new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                DiffSync.this.progressCaller.defaultProgress("diff.sync.truncate.local.tables.success");
                DiffSync.this.selectMasterData(nodeConnections, tablesToTruncate, masterTables);
            }

            @Override
            public void onFailure(Integer data) {
                DiffSync.this.progressCaller.failureProgress("diff.sync.truncate.local.tables.failure");
                DiffSync.this.progressCaller.failure("diff.sync.end.failure");
            }
        }));
    }

    private void selectMasterData(final TreeSet<ServiceNodeConnection> nodeConnections, final TreeSet<ServiceTable> tablesToSelect, final TreeSet<ServiceTable> masterTables) {
        this.executor.execute(() -> this.remoteService.selectMasterData(tablesToSelect, new ServiceCallback<LinkedHashMap<Integer, ServiceTableData>, Integer>(){

            @Override
            public void onSuccess(LinkedHashMap<Integer, ServiceTableData> masterTableData) {
                DiffSync.this.progressCaller.defaultProgress("diff.sync.select.master.data.success");
                DiffSync.this.updateLocalWithMasterData(nodeConnections, tablesToSelect, masterTables, masterTableData);
            }

            @Override
            public void onFailure(Integer data) {
                DiffSync.this.progressCaller.failureProgress("diff.sync.select.master.data.failure");
                DiffSync.this.progressCaller.failure("diff.sync.end.failure");
            }
        }));
    }

    private void updateLocalWithMasterData(final TreeSet<ServiceNodeConnection> nodeConnections, TreeSet<ServiceTable> tablesToUpdate, final TreeSet<ServiceTable> masterTables, LinkedHashMap<Integer, ServiceTableData> masterTableData) {
        this.executor.execute(() -> this.localService.updateLocalWithMasterData(tablesToUpdate, masterTableData, new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                DiffSync.this.progressCaller.defaultProgress("diff.sync.update.local.with.master.data.success");
                DiffSync.this.createHashFunctionInNodes(nodeConnections, masterTables);
            }

            @Override
            public void onFailure(Integer data) {
                DiffSync.this.progressCaller.failureProgress("diff.sync.update.local.with.master.data.failure");
                DiffSync.this.progressCaller.failure("diff.sync.end.failure");
            }
        }));
    }

    private void createHashFunctionInNodes(final TreeSet<ServiceNodeConnection> nodeConnections, final TreeSet<ServiceTable> masterTables) {
        this.executor.execute(() -> this.remoteService.createHashFunctionInNodes(nodeConnections, new ServiceCallback<ArrayList<ServiceNodeStatus>, Integer>(){

            @Override
            public void onSuccess(ArrayList<ServiceNodeStatus> nodesStatus) {
                ArrayList temp = new ArrayList(nodeConnections);
                int initialized = 0;
                for (ServiceNodeStatus nodeStatus : nodesStatus) {
                    if (nodeStatus.getStatus() == 0 || nodeStatus.getStatus() == 4 || nodeStatus.getStatus() == 3) {
                        ServiceNodeConnection nodeConnection = new ServiceNodeConnection(nodeStatus.getId());
                        ServiceNodeConnection node = (ServiceNodeConnection)temp.get(temp.indexOf(nodeConnection));
                        nodeConnections.remove(nodeConnection);
                        DiffSync.this.updateNodeSyncStatus(node, nodeStatus.getStatus(), false);
                        continue;
                    }
                    ++initialized;
                }
                if (initialized > 0) {
                    DiffSync.this.progressCaller.successProgress("diff.sync.create.hash.function.in.nodes.success");
                    DiffSync.this.compareNodesHashes(nodeConnections, masterTables);
                } else {
                    DiffSync.this.progressCaller.failureProgress("diff.sync.create.hash.function.in.nodes.failure");
                    DiffSync.this.progressCaller.failure("diff.sync.end.failure");
                }
            }

            @Override
            public void onFailure(Integer data) {
                DiffSync.this.progressCaller.failureProgress("diff.sync.create.hash.function.in.nodes.failure");
                ArrayList<ServiceNodeStatus> nodesStatus = new ArrayList<ServiceNodeStatus>();
                for (ServiceNodeConnection nodeSyncStatus : nodeConnections) {
                    nodesStatus.add(new ServiceNodeStatus(nodeSyncStatus.getId(), 0));
                }
                DiffSync.this.updateNodesSyncStatus(nodesStatus);
            }
        }));
    }

    private void compareNodesHashes(final TreeSet<ServiceNodeConnection> nodeConnections, TreeSet<ServiceTable> masterTables) {
        this.executor.execute(() -> this.remoteService.compareNodeHashes(nodeConnections, masterTables, new ServiceCallback<ArrayList<ServiceNodeStatus>, Integer>(){

            @Override
            public void onSuccess(ArrayList<ServiceNodeStatus> nodesStatus) {
                DiffSync.this.progressCaller.defaultProgress("diff.sync.compare.nodes.hashes.success");
                ArrayList temp = new ArrayList(nodeConnections);
                for (ServiceNodeStatus nodeStatus : nodesStatus) {
                    ServiceNodeConnection nodeConnection;
                    if (nodeStatus.getStatus() == 3) {
                        nodeConnection = new ServiceNodeConnection(nodeStatus.getId());
                        ServiceNodeConnection node = (ServiceNodeConnection)temp.get(temp.indexOf(nodeConnection));
                        nodeConnections.remove(nodeConnection);
                        DiffSync.this.updateNodeSyncStatus(node, nodeStatus.getStatus(), false);
                        continue;
                    }
                    nodeConnection = new ServiceNodeConnection(nodeStatus.getId());
                    nodeConnection.setTablesToSync(nodeStatus.getTablesToSync());
                }
                if (nodeConnections.size() > 0) {
                    DiffSync.this.syncNodes(nodeConnections);
                }
            }

            @Override
            public void onFailure(Integer data) {
                DiffSync.this.progressCaller.failureProgress("diff.sync.compare.nodes.hashes.failure");
                DiffSync.this.progressCaller.failure("diff.sync.end.failure");
            }
        }));
    }

    private void syncNodes(TreeSet<ServiceNodeConnection> nodeConnections) {
        HashSet<Future<BaseResult>> set = new HashSet<Future<BaseResult>>();
        this.syncExecutor = Executors.newFixedThreadPool(nodeConnections.size());
        for (ServiceNodeConnection serviceNodeConnection : nodeConnections) {
            Future<BaseResult> future = this.syncExecutor.submit(() -> {
                this.createDBLinkFunctionOnNode(nodeConnection, nodeConnection.getTablesToSync());
                return new BaseResult(0);
            });
            set.add(future);
        }
        for (Future future : set) {
            try {
                BaseResult baseResult = (BaseResult)future.get();
            }
            catch (InterruptedException | NullPointerException | ExecutionException exception) {}
        }
    }

    private void createDBLinkFunctionOnNode(final ServiceNodeConnection nodeConnection, TreeSet<ServiceTable> nodeTables) {
        this.remoteService.createDBLinkFunctions(nodeConnection, new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                DiffSync.this.progressCaller.nodeDefaultProgress("diff.sync.select.node.master.record.ids.success", nodeConnection);
                17 v0 = this;
                DiffSync.this.selectNodeMasterRecordIds(nodeConnection, v0.nodeConnection.getTablesToSync());
            }

            @Override
            public void onFailure(Integer data) {
                DiffSync.this.progressCaller.nodeFailureProgress("diff.sync.select.node.master.record.ids.failure", nodeConnection);
                DiffSync.this.syncFailure(nodeConnection, 2);
            }
        });
    }

    private void selectNodeMasterRecordIds(final ServiceNodeConnection nodeConnection, final TreeSet<ServiceTable> nodeTables) {
        this.localService.selectRecordIds(nodeTables, nodeConnection, new ServiceCallback<LinkedHashMap<Integer, ServiceTableData>, Integer>(){

            @Override
            public void onSuccess(LinkedHashMap<Integer, ServiceTableData> nodeRecordIds) {
                if (nodeRecordIds.size() > 0) {
                    DiffSync.this.progressCaller.nodeDefaultProgress("diff.sync.select.node.master.record.ids.success", nodeConnection);
                    DiffSync.this.selectTotalDataToUpdateOnNode(nodeConnection, nodeTables, nodeRecordIds);
                } else {
                    DiffSync.this.selectServiceTablesForDelete(nodeConnection);
                }
            }

            @Override
            public void onFailure(Integer data) {
                DiffSync.this.progressCaller.nodeFailureProgress("diff.sync.select.node.master.record.ids.failure", nodeConnection);
                DiffSync.this.syncFailure(nodeConnection, data);
            }
        });
    }

    private void selectTotalDataToUpdateOnNode(final ServiceNodeConnection nodeConnection, final TreeSet<ServiceTable> nodeTables, LinkedHashMap<Integer, ServiceTableData> totalTableRowIdsNotSynced) {
        this.localService.selectTotalRowsNotSynced(nodeTables, totalTableRowIdsNotSynced, new ServiceCallback<LinkedHashMap<Integer, ServiceTableData>, Integer>(){

            @Override
            public void onSuccess(LinkedHashMap<Integer, ServiceTableData> totalTableRowDataNotSynced) {
                DiffSync.this.progressCaller.nodeDefaultProgress("diff.sync.select.data.to.update.on.node.success", nodeConnection);
                DiffSync.this.updateNodeWithTableData(nodeConnection, nodeTables, totalTableRowDataNotSynced);
            }

            @Override
            public void onFailure(Integer data) {
                if (data != -4) {
                    DiffSync.this.progressCaller.nodeFailureProgress("diff.sync.select.data.to.update.on.node.failure", nodeConnection);
                } else {
                    Platform.runLater(() -> {
                        try {
                            Alert alert = new Alert(Alert.AlertType.ERROR);
                            alert.setTitle(DiffSync.this.resourceBundle.getString("diff.sync.error.max_stack"));
                            alert.setHeaderText(nodeConnection.getName() + ": " + DiffSync.this.resourceBundle.getString("diff.sync.error.max_stack.Text"));
                            alert.initModality(Modality.APPLICATION_MODAL);
                            alert.showAndWait().ifPresent(rs -> {
                                if (rs == ButtonType.OK) {
                                    alert.close();
                                }
                            });
                        }
                        catch (Exception e) {
                            ServicesLog.logError("@@@ onFailure ERROR:", e.getMessage());
                        }
                    });
                    DiffSync.this.progressCaller.nodeFailureProgress("diff.sync.select.data.to.update.on.node.failure", nodeConnection);
                }
                DiffSync.this.syncFailure(nodeConnection, data);
            }
        });
    }

    private void updateNodeWithTableData(final ServiceNodeConnection nodeConnection, TreeSet<ServiceTable> nodeTables, LinkedHashMap<Integer, ServiceTableData> nodeRecordIds) {
        this.remoteService.updateNodeWithUpdatedData(nodeConnection, nodeTables, false, nodeRecordIds, new ServiceCallback<Boolean, Integer>(){

            @Override
            public void onSuccess(Boolean isPartialUpdate) {
                DiffSync.this.progressCaller.nodeDefaultProgress("diff.sync.update.node.with.table.data.success", nodeConnection);
                DiffSync.this.selectServiceTablesForDelete(nodeConnection);
            }

            @Override
            public void onFailure(Integer data) {
                DiffSync.this.progressCaller.nodeFailureProgress("diff.sync.update.node.with.table.data.failure", nodeConnection);
                DiffSync.this.syncFailure(nodeConnection, data);
            }
        });
    }

    private void selectServiceTablesForDelete(final ServiceNodeConnection nodeConnection) {
        this.executor.execute(() -> this.localService.selectTables("3", new ServiceCallback<TreeSet<ServiceTable>, Integer>(){

            @Override
            public void onSuccess(TreeSet<ServiceTable> localTables) {
                DiffSync.this.selectMasterTableHashesForDelete(nodeConnection, localTables);
                DiffSync.this.progressCaller.defaultProgress("diff.sync.select.service.tables.success");
            }

            @Override
            public void onFailure(Integer data) {
                DiffSync.this.progressCaller.failureProgress("diff.sync.select.service.tables.failure");
                DiffSync.this.progressCaller.failure("diff.sync.end.failure");
            }
        }));
    }

    private void selectMasterTableHashesForDelete(final ServiceNodeConnection nodeConnection, TreeSet<ServiceTable> localTables) {
        this.executor.execute(() -> this.remoteService.selectMasterTableHashes(localTables, new ServiceCallback<TreeSet<ServiceTable>, Integer>(){

            @Override
            public void onSuccess(TreeSet<ServiceTable> masterTables) {
                DiffSync.this.progressCaller.defaultProgress("diff.sync.select.master.table.hash.success");
                DiffSync.this.compareNodesHashesToDelete(nodeConnection, masterTables);
            }

            @Override
            public void onFailure(Integer data) {
                DiffSync.this.progressCaller.failureProgress("diff.sync.select.master.table.hash.failure");
                DiffSync.this.progressCaller.failure("diff.sync.end.failure");
            }
        }));
    }

    private void compareNodesHashesToDelete(final ServiceNodeConnection nodeConnection, TreeSet<ServiceTable> masterTables) {
        TreeSet<ServiceNodeConnection> connections = new TreeSet<ServiceNodeConnection>();
        connections.add(nodeConnection);
        this.executor.execute(() -> this.remoteService.compareNodeHashes(connections, masterTables, new ServiceCallback<ArrayList<ServiceNodeStatus>, Integer>(){

            @Override
            public void onSuccess(ArrayList<ServiceNodeStatus> nodesStatus) {
                DiffSync.this.progressCaller.defaultProgress("diff.sync.compare.nodes.hashes.success");
                for (ServiceNodeStatus nodeStatus : nodesStatus) {
                    if (nodeStatus.getStatus() == 3) {
                        DiffSync.this.updateNodeSyncStatus(nodeConnection, nodeStatus.getStatus(), false);
                        continue;
                    }
                    nodeConnection.setTablesToSync(nodeStatus.getTablesToSync());
                    DiffSync.this.selectNodeRecordIdsToDelete(nodeConnection);
                }
            }

            @Override
            public void onFailure(Integer data) {
                DiffSync.this.progressCaller.failureProgress("diff.sync.compare.nodes.hashes.failure");
                DiffSync.this.progressCaller.failure("diff.sync.end.failure");
            }
        }));
    }

    private void selectNodeRecordIdsToDelete(final ServiceNodeConnection nodeConnection) {
        this.localService.selectRecordIds(nodeConnection.getTablesToSync(), nodeConnection, new ServiceCallback<LinkedHashMap<Integer, ServiceTableData>, Integer>(){

            @Override
            public void onSuccess(LinkedHashMap<Integer, ServiceTableData> recordIds) {
                if (recordIds.size() > 0) {
                    DiffSync.this.progressCaller.nodeDefaultProgress("diff.sync.select.node.record.ids.success", nodeConnection);
                    DiffSync.this.deleteNodeRecords(nodeConnection, recordIds);
                } else {
                    DiffSync.this.progressCaller.nodeFailureProgress("diff.sync.select.node.record.ids.failure", nodeConnection);
                    DiffSync.this.syncFailure(nodeConnection, 2);
                }
            }

            @Override
            public void onFailure(Integer data) {
                DiffSync.this.progressCaller.nodeFailureProgress("full.sync.select.node.record.ids.failure", nodeConnection);
                DiffSync.this.syncFailure(nodeConnection, data);
            }
        });
    }

    private void deleteNodeRecords(final ServiceNodeConnection nodeConnection, final LinkedHashMap<Integer, ServiceTableData> nodeRecordIds) {
        this.remoteService.deleteNodeRecords(nodeConnection, nodeConnection.getTablesToSync(), false, nodeRecordIds, new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                DiffSync.this.progressCaller.nodeDefaultProgress("diff.sync.delete.node.records.some.deletions.success", nodeConnection);
                25 v0 = this;
                DiffSync.this.selectNodeDeletedRecords(nodeConnection, v0.nodeConnection.getTablesToSync(), nodeRecordIds, false, false);
            }

            @Override
            public void onFailure(Integer data) {
                DiffSync.this.progressCaller.nodeFailureProgress("diff.sync.delete.node.records.no.deletions.success", nodeConnection);
            }
        });
    }

    private void selectNodeDeletedRecords(final ServiceNodeConnection nodeConnection, TreeSet<ServiceTable> masterTables, final LinkedHashMap<Integer, ServiceTableData> masterTableIds, final boolean isPartialDeletion, final boolean isPartialUpdate) {
        this.remoteService.selectNodeDeletedRecords(nodeConnection, masterTables, false, masterTableIds, new ServiceCallback<LinkedHashMap<Integer, ServiceTableData>, Integer>(){

            @Override
            public void onSuccess(LinkedHashMap<Integer, ServiceTableData> nodeTableDeletedIds) {
                LinkedHashMap<Integer, ServiceTableData> totalTableRowIdsNotSynced = new LinkedHashMap<Integer, ServiceTableData>();
                totalTableRowIdsNotSynced.putAll(masterTableIds);
                for (Map.Entry<Integer, ServiceTableData> entry : nodeTableDeletedIds.entrySet()) {
                    if (totalTableRowIdsNotSynced.containsKey(entry.getKey())) {
                        List<ServiceTableRow> rowNodes = entry.getValue().getRows();
                        List<ServiceTableRow> rowMaster = ((ServiceTableData)totalTableRowIdsNotSynced.get(entry.getKey())).getRows();
                        rowNodes.addAll(rowMaster);
                        totalTableRowIdsNotSynced.put(entry.getKey(), new ServiceTableData((int)entry.getKey(), ((ServiceTableData)totalTableRowIdsNotSynced.get(entry.getKey())).getColumnNames(), rowNodes));
                        continue;
                    }
                    if (entry.getValue().getRows().size() <= 0) continue;
                    totalTableRowIdsNotSynced.put(entry.getKey(), entry.getValue());
                }
                DiffSync.this.progressCaller.nodeDefaultProgress("diff.sync.select.node.deleted.records.success", nodeConnection);
                DiffSync.this.updateSyncedNodeSyncStatus(nodeConnection, !isPartialDeletion && !isPartialUpdate ? 3 : 2, false);
            }

            @Override
            public void onFailure(Integer data) {
                DiffSync.this.progressCaller.nodeFailureProgress("diff.sync.select.node.deleted.records.failure", nodeConnection);
                DiffSync.this.syncFailure(nodeConnection, data);
            }
        });
    }

    private void syncFailure(ServiceNodeConnection nodeConnection, Integer data) {
        int status = 2;
        switch (data) {
            case -3: {
                status = 4;
            }
        }
        this.updateNodeSyncStatus(nodeConnection, status, true);
    }

    private void updateNodesSyncStatus(ArrayList<ServiceNodeStatus> nodesStatus) {
        this.executor.execute(() -> this.localService.updateNodesSyncStatus(nodesStatus, new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                DiffSync.this.progressCaller.defaultProgress("diff.sync.update.nodes.sync.status.success");
            }

            @Override
            public void onFailure(Integer data) {
                DiffSync.this.progressCaller.failureProgress("diff.sync.update.nodes.sync.status.failure");
                DiffSync.this.progressCaller.failure("diff.sync.end.failure");
            }
        }));
    }

    private void updateNodeSyncStatus(final ServiceNodeConnection nodeConnection, final int status, final boolean isEnd) {
        this.localService.updateNodeSyncStatus(new ServiceNodeStatus(nodeConnection.getId(), status), new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                DiffSync.this.progressCaller.nodeStatusUpdate(nodeConnection, status);
                if (status == 3) {
                    DiffSync.this.progressCaller.nodeSuccessProgress("diff.sync.update.nodes.status.success", nodeConnection, status);
                } else {
                    DiffSync.this.progressCaller.nodeFailureProgress("diff.sync.update.nodes.status.failure", nodeConnection, status);
                    if (isEnd) {
                        DiffSync.this.progressCaller.failure("diff.sync.end.failure");
                    }
                }
            }

            @Override
            public void onFailure(Integer data) {
                DiffSync.this.progressCaller.nodeStatusUpdate(nodeConnection, status);
                DiffSync.this.progressCaller.nodeFailureProgress("diff.sync.update.nodes.status.failure", nodeConnection, status);
                if (isEnd) {
                    DiffSync.this.progressCaller.failure("diff.sync.end.failure");
                }
            }
        });
    }

    private void updateSyncedNodeSyncStatus(final ServiceNodeConnection nodeConnection, final int status, final boolean isEnd) {
        this.localService.updateSynchronizationNodeSyncStatus(new ServiceNodeStatus(nodeConnection.getId(), status), new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                DiffSync.this.progressCaller.nodeStatusUpdate(nodeConnection, status);
                DiffSync.this.progressCaller.nodeSuccessProgress("diff.sync.update.nodes.status.success", nodeConnection, status);
            }

            @Override
            public void onFailure(Integer data) {
                DiffSync.this.progressCaller.nodeStatusUpdate(nodeConnection, status);
                DiffSync.this.progressCaller.nodeFailureProgress("diff.sync.update.nodes.status.failure", nodeConnection, status);
                if (isEnd) {
                    DiffSync.this.progressCaller.failure("diff.sync.end.failure");
                }
            }
        });
    }

    private static enum PROCESS_TYPE {
        DIFF_SYNC,
        DIFF_DELETE;

    }
}

