/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.business.sync;

import com.google.common.eventbus.EventBus;
import com.systel.sync.business.common.BusinessCallback;
import com.systel.sync.business.common.BusinessLog;
import com.systel.sync.business.common.BusinessProgressData;
import com.systel.sync.business.common.NodeProgressData;
import com.systel.sync.business.common.events.ProgressEventType;
import com.systel.sync.business.nodes.events.NodeStatusUpdateEvent;
import com.systel.sync.business.sync.SyncInterface;
import com.systel.sync.business.sync.common.ProcessInterface;
import com.systel.sync.business.sync.common.ProgressCaller;
import com.systel.sync.business.sync.common.ProgressCallerInterface;
import com.systel.sync.business.sync.events.ScheduledStatusVerificationFailureEvent;
import com.systel.sync.business.sync.events.ScheduledStatusVerificationProgressEvent;
import com.systel.sync.business.sync.events.ScheduledStatusVerificationSuccessEvent;
import com.systel.sync.business.sync.events.ScheduledSyncFailureEvent;
import com.systel.sync.business.sync.events.ScheduledSyncProgressEvent;
import com.systel.sync.business.sync.events.ScheduledSyncSuccessEvent;
import com.systel.sync.business.sync.events.StatusResetFailureEvent;
import com.systel.sync.business.sync.events.StatusResetSuccessEvent;
import com.systel.sync.business.sync.events.StatusVerificationFailureEvent;
import com.systel.sync.business.sync.events.StatusVerificationProgressEvent;
import com.systel.sync.business.sync.events.StatusVerificationSuccessEvent;
import com.systel.sync.business.sync.events.SyncFailureEvent;
import com.systel.sync.business.sync.events.SyncProcessingNodesEvent;
import com.systel.sync.business.sync.events.SyncProgressEvent;
import com.systel.sync.business.sync.events.SyncSuccessEvent;
import com.systel.sync.business.sync.process.DiffSync;
import com.systel.sync.business.sync.process.FullSync;
import com.systel.sync.business.sync.process.SetupUpdate;
import com.systel.sync.business.sync.process.StatusReset;
import com.systel.sync.business.sync.process.StatusVerification;
import com.systel.sync.services.common.ServiceCallback;
import com.systel.sync.services.common.entities.ServiceNodeConnection;
import com.systel.sync.services.nodes.local.callables.SetDateTimeNodesCallable;
import com.systel.sync.services.nodes.local.results.DiscoverNodesResult;
import com.systel.sync.services.sync.local.SyncLocalServiceInterface;
import com.systel.sync.services.sync.remote.SyncRemoteServiceInterface;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class SyncManager
implements SyncInterface {
    private static final String LOG_TAG = SyncManager.class.getSimpleName();
    private ProcessInterface statusReset;
    private ProcessInterface statusVerification;
    private ProcessInterface diffSync;
    private ProcessInterface fullSync;
    private ProcessInterface setupUpdate;
    private SyncLocalServiceInterface syncLocalServiceInterface;
    private SyncRemoteServiceInterface syncRemoteServiceInterface;
    private EventBus eventBus;
    private ExecutorService executor;
    private ResourceBundle resourceBundle;
    public ArrayList<Long> nodeIds = new ArrayList();
    public int cont = 0;
    public int flag = 0;

    public SyncManager(SyncLocalServiceInterface syncLocalServiceInterface, SyncRemoteServiceInterface syncRemoteServiceInterface, EventBus eventBus, ExecutorService executor, ResourceBundle resourceBundle) {
        this.syncLocalServiceInterface = syncLocalServiceInterface;
        this.syncRemoteServiceInterface = syncRemoteServiceInterface;
        this.eventBus = eventBus;
        this.executor = executor;
        this.resourceBundle = resourceBundle;
    }

    @Override
    public void resetStatus() {
        this.getStatusReset().execute(new ProgressCaller(new BusinessCallback<String, String, BusinessProgressData>(){

            @Override
            public void onSuccess(String message) {
                try {
                    message = SyncManager.this.resourceBundle.getString(message);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                BusinessLog.logDebug(LOG_TAG, message);
                SyncManager.this.eventBus.post(new StatusResetSuccessEvent(message));
                SyncManager.this.statusReset = null;
                System.gc();
            }

            @Override
            public void onFailure(String message) {
                try {
                    message = SyncManager.this.resourceBundle.getString(message);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                BusinessLog.logError(LOG_TAG, message);
                SyncManager.this.eventBus.post(new StatusResetFailureEvent(message));
                SyncManager.this.statusReset = null;
                System.gc();
            }

            @Override
            public void onProgress(BusinessProgressData data) {
            }
        }, this.resourceBundle));
    }

    @Override
    public void verifyStatus(Long nodeId) {
        this.nodeIds.removeAll(this.nodeIds);
        this.nodeIds.add(nodeId);
        final ArrayList nodesIds = new ArrayList();
        this.eventBus.post(new SyncProcessingNodesEvent(nodeId));
        this.getStatusVerification().execute(nodeId, (ProgressCallerInterface)new ProgressCaller(new BusinessCallback<String, String, BusinessProgressData>(){

            @Override
            public void onSuccess(String message) {
                try {
                    message = SyncManager.this.resourceBundle.getString(message);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                BusinessLog.logDebug(LOG_TAG, message);
                SyncManager.this.statusVerification = null;
                System.gc();
            }

            @Override
            public void onFailure(String message) {
                try {
                    message = SyncManager.this.resourceBundle.getString(message);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                BusinessLog.logError(LOG_TAG, message);
                SyncManager.this.eventBus.post(new StatusVerificationFailureEvent(message));
                SyncManager.this.statusVerification = null;
                System.gc();
            }

            @Override
            public void onProgress(BusinessProgressData data) {
                if (data.getType().equals((Object)ProgressEventType.STATUS)) {
                    NodeProgressData nodeProgressData = (NodeProgressData)data;
                    SyncManager.this.eventBus.post(new NodeStatusUpdateEvent(nodeProgressData.getNode()));
                    if (nodeProgressData.getNode().getStatus() != 4) {
                        nodesIds.add(nodeProgressData.getNode().getId());
                    } else {
                        for (Long node : SyncManager.this.nodeIds) {
                            if (node.longValue() != nodeProgressData.getNode().getId()) continue;
                            SyncManager.this.nodeIds.remove(node);
                        }
                    }
                    if (nodesIds.size() == SyncManager.this.nodeIds.size()) {
                        SyncManager.this.flag = 1;
                        SyncManager.this.setupUpdate(nodesIds);
                    }
                } else {
                    String message = data.getMessage();
                    try {
                        message = SyncManager.this.resourceBundle.getString(data.getMessage());
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                    if (data.getType().equals((Object)ProgressEventType.FAILURE)) {
                        BusinessLog.logError(LOG_TAG, message);
                    } else {
                        BusinessLog.logDebug(LOG_TAG, message);
                    }
                    SyncManager.this.eventBus.post(new StatusVerificationProgressEvent(message, data.getType(), data.isHighlighted()));
                }
            }
        }, this.resourceBundle));
    }

    @Override
    public void verifyStatus(ArrayList<Long> nodeId) {
        this.nodeIds = nodeId;
        final ArrayList nodesIds = new ArrayList();
        this.eventBus.post(new SyncProcessingNodesEvent(nodeId));
        this.getStatusVerification().execute(nodeId, (ProgressCallerInterface)new ProgressCaller(new BusinessCallback<String, String, BusinessProgressData>(){

            @Override
            public void onSuccess(String message) {
                try {
                    message = SyncManager.this.resourceBundle.getString(message);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                BusinessLog.logDebug(LOG_TAG, message);
                SyncManager.this.statusVerification = null;
                System.gc();
            }

            @Override
            public void onFailure(String message) {
                try {
                    message = SyncManager.this.resourceBundle.getString(message);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                BusinessLog.logError(LOG_TAG, message);
                SyncManager.this.eventBus.post(new StatusVerificationFailureEvent(message));
                SyncManager.this.statusVerification = null;
                System.gc();
            }

            @Override
            public void onProgress(BusinessProgressData data) {
                if (data.getType().equals((Object)ProgressEventType.STATUS)) {
                    NodeProgressData nodeProgressData = (NodeProgressData)data;
                    SyncManager.this.eventBus.post(new NodeStatusUpdateEvent(nodeProgressData.getNode()));
                    if (nodeProgressData.getNode().getStatus() != 4) {
                        nodesIds.add(nodeProgressData.getNode().getId());
                    } else {
                        for (Long node : SyncManager.this.nodeIds) {
                            if (node.longValue() != nodeProgressData.getNode().getId()) continue;
                            SyncManager.this.nodeIds.remove(node);
                        }
                    }
                    if (nodesIds.size() == SyncManager.this.nodeIds.size()) {
                        SyncManager.this.flag = 1;
                        SyncManager.this.setupUpdate(nodesIds);
                    }
                } else {
                    String message = data.getMessage();
                    try {
                        message = SyncManager.this.resourceBundle.getString(data.getMessage());
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                    if (data.getType().equals((Object)ProgressEventType.FAILURE)) {
                        BusinessLog.logError(LOG_TAG, message);
                    } else {
                        BusinessLog.logDebug(LOG_TAG, message);
                    }
                    SyncManager.this.eventBus.post(new StatusVerificationProgressEvent(message, data.getType(), data.isHighlighted()));
                }
            }
        }, this.resourceBundle));
    }

    @Override
    public void scheduledVerifyStatus() {
        this.eventBus.post(new SyncProcessingNodesEvent((Long)null));
        final ArrayList nodesIds = new ArrayList();
        this.getStatusVerification().execute(new ProgressCaller(new BusinessCallback<String, String, BusinessProgressData>(){

            @Override
            public void onSuccess(String message) {
                try {
                    message = SyncManager.this.resourceBundle.getString(message);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                BusinessLog.logDebug(LOG_TAG, message);
                SyncManager.this.eventBus.post(new ScheduledStatusVerificationSuccessEvent(message));
                SyncManager.this.statusVerification = null;
                System.gc();
            }

            @Override
            public void onFailure(String message) {
                try {
                    message = SyncManager.this.resourceBundle.getString(message);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                BusinessLog.logError(LOG_TAG, message);
                SyncManager.this.eventBus.post(new ScheduledStatusVerificationFailureEvent(message));
                SyncManager.this.statusVerification = null;
                System.gc();
            }

            @Override
            public void onProgress(BusinessProgressData data) {
                if (data.getType().equals((Object)ProgressEventType.STATUS)) {
                    NodeProgressData nodeProgressData = (NodeProgressData)data;
                    SyncManager.this.eventBus.post(new NodeStatusUpdateEvent(nodeProgressData.getNode()));
                    if (nodeProgressData.getNode().getStatus() != 4) {
                        nodesIds.add(nodeProgressData.getNode().getId());
                    } else {
                        for (Long node : SyncManager.this.nodeIds) {
                            if (node.longValue() != nodeProgressData.getNode().getId()) continue;
                            SyncManager.this.nodeIds.remove(node);
                        }
                    }
                    if (nodesIds.size() == SyncManager.this.nodeIds.size()) {
                        SyncManager.this.flag = 2;
                        SyncManager.this.setupUpdate(nodesIds);
                    }
                } else {
                    String message = data.getMessage();
                    try {
                        message = SyncManager.this.resourceBundle.getString(data.getMessage());
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                    if (data.getType().equals((Object)ProgressEventType.FAILURE)) {
                        BusinessLog.logError(LOG_TAG, message);
                    } else {
                        BusinessLog.logDebug(LOG_TAG, message);
                    }
                    SyncManager.this.eventBus.post(new ScheduledStatusVerificationProgressEvent(message, data.getType(), data.isHighlighted()));
                }
            }
        }, this.resourceBundle));
    }

    @Override
    public void diffSync(Long nodeId) {
        this.nodeIds.removeAll(this.nodeIds);
        this.nodeIds.add(nodeId);
        final ArrayList nodesIds = new ArrayList();
        this.eventBus.post(new SyncProcessingNodesEvent(nodeId));
        this.getDiffSync().execute(nodeId, (ProgressCallerInterface)new ProgressCaller(new BusinessCallback<String, String, BusinessProgressData>(){

            @Override
            public void onSuccess(String message) {
                try {
                    message = SyncManager.this.resourceBundle.getString(message);
                    Future<DiscoverNodesResult> future = SyncManager.this.executor.submit(new SetDateTimeNodesCallable());
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                BusinessLog.logDebug(LOG_TAG, message);
                SyncManager.this.eventBus.post(new SyncSuccessEvent(message));
                SyncManager.this.diffSync = null;
                System.gc();
            }

            @Override
            public void onFailure(String message) {
                try {
                    message = SyncManager.this.resourceBundle.getString(message);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                BusinessLog.logError(LOG_TAG, message);
                SyncManager.this.eventBus.post(new SyncFailureEvent(message));
                SyncManager.this.diffSync = null;
                System.gc();
            }

            @Override
            public void onProgress(BusinessProgressData data) {
                if (data.getType().equals((Object)ProgressEventType.STATUS)) {
                    NodeProgressData nodeProgressData = (NodeProgressData)data;
                    SyncManager.this.eventBus.post(new NodeStatusUpdateEvent(nodeProgressData.getNode()));
                    if (nodeProgressData.getNode().getStatus() != 4) {
                        nodesIds.add(nodeProgressData.getNode().getId());
                    } else {
                        for (Long node : SyncManager.this.nodeIds) {
                            if (node.longValue() != nodeProgressData.getNode().getId()) continue;
                            SyncManager.this.nodeIds.remove(node);
                        }
                    }
                    if (nodesIds.size() == SyncManager.this.nodeIds.size()) {
                        SyncManager.this.flag = 3;
                        SyncManager.this.setupUpdate(nodesIds);
                    }
                } else {
                    String message = data.getMessage();
                    try {
                        message = SyncManager.this.resourceBundle.getString(data.getMessage());
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                    if (data.getType().equals((Object)ProgressEventType.FAILURE)) {
                        BusinessLog.logError(LOG_TAG, message);
                    } else {
                        BusinessLog.logDebug(LOG_TAG, message);
                    }
                    SyncManager.this.eventBus.post(new SyncProgressEvent(message, data.getType(), data.isHighlighted()));
                }
            }
        }, this.resourceBundle));
    }

    @Override
    public void diffSync(ArrayList<Long> nodeId) {
        this.nodeIds = nodeId;
        final ArrayList nodesIds = new ArrayList();
        this.eventBus.post(new SyncProcessingNodesEvent(nodeId));
        this.getDiffSync().execute(nodeId, (ProgressCallerInterface)new ProgressCaller(new BusinessCallback<String, String, BusinessProgressData>(){

            @Override
            public void onSuccess(String message) {
                try {
                    message = SyncManager.this.resourceBundle.getString(message);
                    Future<DiscoverNodesResult> future = SyncManager.this.executor.submit(new SetDateTimeNodesCallable());
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                SyncManager.this.diffSync = null;
                System.gc();
            }

            @Override
            public void onFailure(String message) {
                try {
                    message = SyncManager.this.resourceBundle.getString(message);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                BusinessLog.logError(LOG_TAG, message);
                SyncManager.this.eventBus.post(new SyncFailureEvent(message));
                SyncManager.this.diffSync = null;
                System.gc();
            }

            @Override
            public void onProgress(BusinessProgressData data) {
                if (data.getType().equals((Object)ProgressEventType.STATUS)) {
                    NodeProgressData nodeProgressData = (NodeProgressData)data;
                    SyncManager.this.eventBus.post(new NodeStatusUpdateEvent(nodeProgressData.getNode()));
                    if (nodeProgressData.getNode().getStatus() != 4) {
                        nodesIds.add(nodeProgressData.getNode().getId());
                    } else {
                        for (Long node : SyncManager.this.nodeIds) {
                            if (node.longValue() != nodeProgressData.getNode().getId()) continue;
                            SyncManager.this.nodeIds.remove(node);
                        }
                    }
                    if (nodesIds.size() == SyncManager.this.nodeIds.size()) {
                        SyncManager.this.flag = 3;
                        SyncManager.this.setupUpdate(nodesIds);
                    }
                } else {
                    String message = data.getMessage();
                    try {
                        message = SyncManager.this.resourceBundle.getString(data.getMessage());
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                    if (data.getType().equals((Object)ProgressEventType.FAILURE)) {
                        BusinessLog.logError(LOG_TAG, message);
                    } else {
                        BusinessLog.logDebug(LOG_TAG, message);
                    }
                    SyncManager.this.eventBus.post(new SyncProgressEvent(message, data.getType(), data.isHighlighted()));
                }
            }
        }, this.resourceBundle));
    }

    @Override
    public void scheduledDiffSync() {
        this.eventBus.post(new SyncProcessingNodesEvent((Long)null));
        final ArrayList nodesIds = new ArrayList();
        this.getDiffSync().execute(new ProgressCaller(new BusinessCallback<String, String, BusinessProgressData>(){

            @Override
            public void onSuccess(String message) {
                try {
                    message = SyncManager.this.resourceBundle.getString(message);
                    Future<DiscoverNodesResult> future = SyncManager.this.executor.submit(new SetDateTimeNodesCallable());
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                BusinessLog.logDebug(LOG_TAG, message);
                SyncManager.this.eventBus.post(new ScheduledSyncSuccessEvent(message));
                SyncManager.this.diffSync = null;
                System.gc();
            }

            @Override
            public void onFailure(String message) {
                try {
                    message = SyncManager.this.resourceBundle.getString(message);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                BusinessLog.logError(LOG_TAG, message);
                SyncManager.this.eventBus.post(new ScheduledSyncFailureEvent(message));
                SyncManager.this.diffSync = null;
                System.gc();
            }

            @Override
            public void onProgress(BusinessProgressData data) {
                if (data.getType().equals((Object)ProgressEventType.STATUS)) {
                    NodeProgressData nodeProgressData = (NodeProgressData)data;
                    SyncManager.this.eventBus.post(new NodeStatusUpdateEvent(nodeProgressData.getNode()));
                    if (nodeProgressData.getNode().getStatus() != 4) {
                        nodesIds.add(nodeProgressData.getNode().getId());
                    } else {
                        for (Long node : SyncManager.this.nodeIds) {
                            if (node.longValue() != nodeProgressData.getNode().getId()) continue;
                            SyncManager.this.nodeIds.remove(node);
                        }
                    }
                    if (nodesIds.size() == SyncManager.this.nodeIds.size()) {
                        SyncManager.this.flag = 5;
                        SyncManager.this.setupUpdate(nodesIds);
                    }
                } else {
                    String message = data.getMessage();
                    try {
                        message = SyncManager.this.resourceBundle.getString(data.getMessage());
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                    if (data.getType().equals((Object)ProgressEventType.FAILURE)) {
                        BusinessLog.logError(LOG_TAG, message);
                    } else {
                        BusinessLog.logDebug(LOG_TAG, message);
                    }
                    SyncManager.this.eventBus.post(new ScheduledSyncProgressEvent(message, data.getType(), data.isHighlighted()));
                }
            }
        }, this.resourceBundle));
    }

    @Override
    public void fullSync(Long nodeId) {
        this.nodeIds.removeAll(this.nodeIds);
        this.nodeIds.add(nodeId);
        final ArrayList nodesIds = new ArrayList();
        this.eventBus.post(new SyncProcessingNodesEvent(nodeId));
        this.getFullSync().execute(nodeId, (ProgressCallerInterface)new ProgressCaller(new BusinessCallback<String, String, BusinessProgressData>(){

            @Override
            public void onSuccess(String message) {
                try {
                    message = SyncManager.this.resourceBundle.getString(message);
                    Future<DiscoverNodesResult> future = SyncManager.this.executor.submit(new SetDateTimeNodesCallable());
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                BusinessLog.logDebug(LOG_TAG, message);
                SyncManager.this.eventBus.post(new SyncSuccessEvent(message));
                SyncManager.this.fullSync = null;
                System.gc();
            }

            @Override
            public void onFailure(String message) {
                try {
                    message = SyncManager.this.resourceBundle.getString(message);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                BusinessLog.logError(LOG_TAG, message);
                SyncManager.this.eventBus.post(new SyncFailureEvent(message));
                SyncManager.this.fullSync = null;
                System.gc();
            }

            @Override
            public void onProgress(BusinessProgressData data) {
                if (data.getType().equals((Object)ProgressEventType.STATUS)) {
                    NodeProgressData nodeProgressData = (NodeProgressData)data;
                    SyncManager.this.eventBus.post(new NodeStatusUpdateEvent(nodeProgressData.getNode()));
                    if (nodeProgressData.getNode().getStatus() != 4) {
                        nodesIds.add(nodeProgressData.getNode().getId());
                    } else {
                        for (Long node : SyncManager.this.nodeIds) {
                            if (node.longValue() == nodeProgressData.getNode().getId()) {
                                SyncManager.this.nodeIds.remove(node);
                            }
                            if (nodesIds.size() >= 1) continue;
                            break;
                        }
                    }
                    if (nodesIds.size() == SyncManager.this.nodeIds.size() && SyncManager.this.nodeIds.size() > 0) {
                        SyncManager.this.flag = 4;
                        SyncManager.this.setupUpdate(nodesIds);
                    }
                } else {
                    String message = data.getMessage();
                    try {
                        message = SyncManager.this.resourceBundle.getString(data.getMessage());
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                    if (data.getType().equals((Object)ProgressEventType.FAILURE)) {
                        BusinessLog.logError(LOG_TAG, message);
                    } else {
                        BusinessLog.logDebug(LOG_TAG, message);
                    }
                    SyncManager.this.eventBus.post(new SyncProgressEvent(message, data.getType(), data.isHighlighted()));
                }
            }
        }, this.resourceBundle));
    }

    @Override
    public void fullSync(ArrayList<Long> nodeId) {
        this.nodeIds = nodeId;
        final ArrayList nodesIds = new ArrayList();
        this.eventBus.post(new SyncProcessingNodesEvent(nodeId));
        this.getFullSync().execute(nodeId, (ProgressCallerInterface)new ProgressCaller(new BusinessCallback<String, String, BusinessProgressData>(){

            @Override
            public void onSuccess(String message) {
                try {
                    message = SyncManager.this.resourceBundle.getString(message);
                    Future<DiscoverNodesResult> future = SyncManager.this.executor.submit(new SetDateTimeNodesCallable());
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                BusinessLog.logDebug(LOG_TAG, message);
                SyncManager.this.eventBus.post(new SyncSuccessEvent(message));
                SyncManager.this.fullSync = null;
                System.gc();
            }

            @Override
            public void onFailure(String message) {
                try {
                    message = SyncManager.this.resourceBundle.getString(message);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                BusinessLog.logError(LOG_TAG, message);
                SyncManager.this.eventBus.post(new SyncFailureEvent(message));
                SyncManager.this.fullSync = null;
                System.gc();
            }

            @Override
            public void onProgress(BusinessProgressData data) {
                if (data.getType().equals((Object)ProgressEventType.STATUS)) {
                    NodeProgressData nodeProgressData = (NodeProgressData)data;
                    SyncManager.this.eventBus.post(new NodeStatusUpdateEvent(nodeProgressData.getNode()));
                    if (nodeProgressData.getNode().getStatus() != 4) {
                        nodesIds.add(nodeProgressData.getNode().getId());
                    } else {
                        for (Long node : SyncManager.this.nodeIds) {
                            if (node.longValue() != nodeProgressData.getNode().getId()) continue;
                            SyncManager.this.nodeIds.remove(node);
                        }
                    }
                    if (nodesIds.size() == SyncManager.this.nodeIds.size()) {
                        SyncManager.this.flag = 4;
                        SyncManager.this.setupUpdate(nodesIds);
                    }
                } else {
                    String message = data.getMessage();
                    try {
                        message = SyncManager.this.resourceBundle.getString(data.getMessage());
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                    if (data.getType().equals((Object)ProgressEventType.FAILURE)) {
                        BusinessLog.logError(LOG_TAG, message);
                    } else {
                        BusinessLog.logDebug(LOG_TAG, message);
                    }
                    SyncManager.this.eventBus.post(new SyncProgressEvent(message, data.getType(), data.isHighlighted()));
                }
            }
        }, this.resourceBundle));
    }

    @Override
    public void setupUpdate(ArrayList<Long> nodeId) {
        this.getSetupUpdate().execute(nodeId, (ProgressCallerInterface)new ProgressCaller(new BusinessCallback<String, String, BusinessProgressData>(){

            @Override
            public void onSuccess(String message) {
                try {
                    message = SyncManager.this.resourceBundle.getString(message);
                    if (message.equalsIgnoreCase(SyncManager.this.resourceBundle.getString("diff.sync.end.success"))) {
                        ++SyncManager.this.cont;
                    }
                    if (SyncManager.this.cont == SyncManager.this.nodeIds.size()) {
                        if (SyncManager.this.flag == 1) {
                            BusinessLog.logDebug(LOG_TAG, "verify.status.end.success");
                            SyncManager.this.eventBus.post(new StatusVerificationSuccessEvent(SyncManager.this.resourceBundle.getString("verify.status.end.success")));
                        } else if (SyncManager.this.flag == 3) {
                            BusinessLog.logDebug(LOG_TAG, "diff.sync.end.success");
                            SyncManager.this.eventBus.post(new SyncSuccessEvent(SyncManager.this.resourceBundle.getString("diff.sync.end.success")));
                        } else if (SyncManager.this.flag == 2) {
                            BusinessLog.logDebug(LOG_TAG, "verify.status.end.success");
                            SyncManager.this.eventBus.post(new ScheduledStatusVerificationSuccessEvent(SyncManager.this.resourceBundle.getString("verify.status.end.success")));
                        } else if (SyncManager.this.flag == 4) {
                            BusinessLog.logDebug(LOG_TAG, "full.sync.end.success");
                            SyncManager.this.eventBus.post(new SyncSuccessEvent(SyncManager.this.resourceBundle.getString("full.sync.end.success")));
                        } else if (SyncManager.this.flag == 5) {
                            BusinessLog.logDebug(LOG_TAG, "diff.sync.end.success");
                            SyncManager.this.eventBus.post(new ScheduledSyncSuccessEvent(SyncManager.this.resourceBundle.getString("diff.sync.end.success")));
                        }
                        SyncManager.this.flag = 0;
                        SyncManager.this.cont = 0;
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                SyncManager.this.setupUpdate = null;
                System.gc();
            }

            @Override
            public void onFailure(String message) {
                try {
                    message = SyncManager.this.resourceBundle.getString(message);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                BusinessLog.logError(LOG_TAG, message);
                SyncManager.this.setupUpdate = null;
                System.gc();
            }

            @Override
            public void onProgress(BusinessProgressData data) {
                String message = data.getMessage();
                try {
                    message = SyncManager.this.resourceBundle.getString(data.getMessage());
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                if (data.getType().equals((Object)ProgressEventType.FAILURE)) {
                    BusinessLog.logError(LOG_TAG, message);
                } else {
                    BusinessLog.logDebug(LOG_TAG, message);
                }
            }
        }, this.resourceBundle));
    }

    private ProcessInterface getStatusReset() {
        try {
            this.statusReset.equals(this.statusReset);
        }
        catch (NullPointerException ex) {
            this.statusReset = new StatusReset(this.syncLocalServiceInterface, this.executor);
        }
        return this.statusReset;
    }

    private ProcessInterface getStatusVerification() {
        try {
            this.statusVerification.equals(this.statusVerification);
        }
        catch (NullPointerException ex) {
            this.statusVerification = new StatusVerification(this.syncLocalServiceInterface, this.syncRemoteServiceInterface, this.executor);
        }
        return this.statusVerification;
    }

    private ProcessInterface getFullSync() {
        try {
            this.fullSync.equals(this.fullSync);
        }
        catch (NullPointerException ex) {
            this.fullSync = new FullSync(this.syncLocalServiceInterface, this.syncRemoteServiceInterface, this.executor);
        }
        return this.fullSync;
    }

    private ProcessInterface getDiffSync() {
        try {
            this.diffSync.equals(this.diffSync);
        }
        catch (NullPointerException ex) {
            this.diffSync = new DiffSync(this.syncLocalServiceInterface, this.syncRemoteServiceInterface, this.executor, this.resourceBundle);
        }
        return this.diffSync;
    }

    private ProcessInterface getSetupUpdate() {
        try {
            this.setupUpdate.equals(this.setupUpdate);
        }
        catch (NullPointerException ex) {
            this.setupUpdate = new SetupUpdate(this.syncLocalServiceInterface, this.syncRemoteServiceInterface, this.executor);
        }
        return this.setupUpdate;
    }

    @Override
    public void nodeNull() {
        this.nodeIds.removeAll(this.nodeIds);
        this.syncLocalServiceInterface.selectNodes(new ServiceCallback<TreeSet<ServiceNodeConnection>, Integer>(){

            @Override
            public void onSuccess(TreeSet<ServiceNodeConnection> nodeConnections) {
                for (ServiceNodeConnection node : nodeConnections) {
                    SyncManager.this.nodeIds.add(node.getId());
                }
            }

            @Override
            public void onFailure(Integer data) {
                SyncManager.this.nodeIds = null;
            }
        }, null);
    }
}

