/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.business.scheduler;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.systel.sync.business.common.BusinessLog;
import com.systel.sync.business.common.entities.Schedule;
import com.systel.sync.business.scheduler.SchedulerInterface;
import com.systel.sync.business.scheduler.events.LoadSchedulesFailureEvent;
import com.systel.sync.business.scheduler.events.LoadSchedulesSuccessEvent;
import com.systel.sync.business.scheduler.events.UpdateSchedulesFailureEvent;
import com.systel.sync.business.scheduler.events.UpdateSchedulesSuccessEvent;
import com.systel.sync.business.sync.SyncInterface;
import com.systel.sync.business.sync.events.ScheduledStatusVerificationSuccessEvent;
import com.systel.sync.business.sync.events.ScheduledSyncSuccessEvent;
import com.systel.sync.services.common.ServiceCallback;
import com.systel.sync.services.common.entities.ServiceSchedule;
import com.systel.sync.services.scheduler.SchedulerServiceInterface;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class SchedulerManager
implements SchedulerInterface {
    private static final String LOG_TAG = SchedulerManager.class.getSimpleName();
    private final SchedulerServiceInterface schedulerServiceInterface;
    private final SyncInterface sync;
    private EventBus eventBus;
    private ExecutorService executor;
    private ArrayList<Schedule> schedules;
    private ArrayList<Schedule> timeSchedules;
    private ScheduledExecutorService schedulerExecutor;
    private ResourceBundle resource;

    public SchedulerManager(SchedulerServiceInterface schedulerServiceManager, SyncInterface sync, EventBus eventBus, ExecutorService executor, ResourceBundle resource) {
        this.sync = sync;
        this.schedulerServiceInterface = schedulerServiceManager;
        this.schedules = new ArrayList();
        this.timeSchedules = new ArrayList();
        this.executor = executor;
        this.schedulerExecutor = Executors.newScheduledThreadPool(1);
        this.eventBus = eventBus;
        this.eventBus.register(this);
        this.resource = resource;
        this.schedulerExecutor.scheduleWithFixedDelay(() -> {
            try {
                this.determineScheduleToRun();
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException ex) {
                BusinessLog.logError(LOG_TAG, ex.getMessage());
            }
        }, 1L, 1L, TimeUnit.MINUTES);
    }

    @Override
    public void load() {
        this.executor.execute(() -> this.schedulerServiceInterface.selectSchedules(new ServiceCallback<ArrayList<ServiceSchedule>, Integer>(){

            @Override
            public void onSuccess(ArrayList<ServiceSchedule> serviceSchedules) {
                SchedulerManager.this.updateSchedules(serviceSchedules);
                String message = SchedulerManager.this.resource.getString("scheduler.load.schedules.success");
                BusinessLog.logDebug(LOG_TAG, message);
                SchedulerManager.this.eventBus.post(new LoadSchedulesSuccessEvent(message));
            }

            @Override
            public void onFailure(Integer data) {
                String message = SchedulerManager.this.resource.getString("scheduler.load.schedules.failure");
                BusinessLog.logError(LOG_TAG, message);
                SchedulerManager.this.eventBus.post(new LoadSchedulesFailureEvent(message));
            }
        }));
    }

    @Override
    public void save(ArrayList<Schedule> schedules) {
        final ArrayList<ServiceSchedule> serviceSchedules = new ArrayList<ServiceSchedule>();
        for (Schedule schedule : schedules) {
            serviceSchedules.add(new ServiceSchedule(schedule));
        }
        this.executor.execute(() -> this.schedulerServiceInterface.updateSchedules(serviceSchedules, new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                SchedulerManager.this.updateSchedules(serviceSchedules);
                String message = "scheduler.update.schedules.success";
                BusinessLog.logDebug(LOG_TAG, message);
                SchedulerManager.this.eventBus.post(new UpdateSchedulesSuccessEvent(message));
            }

            @Override
            public void onFailure(Integer data) {
                String message = "scheduler.update.schedules.failure";
                BusinessLog.logError(LOG_TAG, message);
                SchedulerManager.this.eventBus.post(new UpdateSchedulesFailureEvent(message));
            }
        }));
    }

    @Override
    public ArrayList<Schedule> getSchedules() {
        return this.schedules;
    }

    @Override
    public ArrayList<Schedule> getTimeSchedules() {
        return this.timeSchedules;
    }

    @Subscribe
    public void onCheckSuccessSchedulerEvent(ScheduledStatusVerificationSuccessEvent event) {
        this.executor.execute(() -> {
            final long currentTime = System.currentTimeMillis();
            this.schedulerServiceInterface.updateFinishedRun(0, currentTime, new ServiceCallback<Integer, Integer>(){

                @Override
                public void onSuccess(Integer data) {
                    SchedulerManager.this.updateScheduleLastRun(0, currentTime);
                }

                @Override
                public void onFailure(Integer data) {
                    SchedulerManager.this.updateScheduleLastRun(0, currentTime);
                }
            });
        });
    }

    @Subscribe
    public void onSyncSuccessSchedulerEvent(ScheduledSyncSuccessEvent event) {
        this.executor.execute(() -> {
            final long currentTime = System.currentTimeMillis();
            this.schedulerServiceInterface.updateFinishedRun(1, currentTime, new ServiceCallback<Integer, Integer>(){

                @Override
                public void onSuccess(Integer data) {
                    SchedulerManager.this.updateScheduleLastRun(1, currentTime);
                }

                @Override
                public void onFailure(Integer data) {
                    SchedulerManager.this.updateScheduleLastRun(1, currentTime);
                }
            });
        });
    }

    private void updateSchedules(ArrayList<ServiceSchedule> serviceSchedules) {
        this.schedules.clear();
        this.timeSchedules.clear();
        for (ServiceSchedule serviceSchedule : serviceSchedules) {
            Schedule schedule = new Schedule();
            schedule.setId(serviceSchedule.getId());
            schedule.setType(serviceSchedule.getType());
            schedule.setEnabled(serviceSchedule.getEnabled() == 1);
            schedule.setTime(serviceSchedule.getTime());
            schedule.setInterval(serviceSchedule.getInterval());
            schedule.setLastRunStarted(serviceSchedule.getLastRunStarted());
            schedule.setLastRunFinished(serviceSchedule.getLastRunFinished());
            schedule.setTimeUnit(serviceSchedule.getTimeUnit());
            switch (schedule.getType()) {
                case 0: {
                    this.schedules.add(schedule);
                    break;
                }
                case 1: {
                    this.timeSchedules.add(schedule);
                }
            }
        }
    }

    private void updateScheduleLastRun(int schedulerType, long currentTime) {
        for (Schedule schedule : this.schedules) {
            if (schedule.getType() != schedulerType) continue;
            schedule.setLastRunFinished(currentTime);
            break;
        }
    }

    private void determineScheduleToRun() {
        for (Schedule schedule : this.schedules) {
            if (!schedule.isEnabled() || !this.scheduleIntervalCheck(schedule)) continue;
            this.sync.nodeNull();
            this.sync.scheduledVerifyStatus();
        }
        for (Schedule schedule : this.timeSchedules) {
            if (!schedule.isEnabled() || !this.scheduleTimeCheck(schedule)) continue;
            this.sync.nodeNull();
            this.sync.scheduledDiffSync();
        }
    }

    private boolean scheduleIntervalCheck(Schedule schedule) {
        return System.currentTimeMillis() > schedule.getLastRunFinished() + this.intervalToMillis(schedule.getInterval(), schedule.getTimeUnit());
    }

    private boolean scheduleTimeCheck(Schedule schedule) {
        SimpleDateFormat simpleDateTime = new SimpleDateFormat("HH:mm");
        return simpleDateTime.format(new Date()).equals(simpleDateTime.format(Time.valueOf(schedule.getTime())));
    }

    private long intervalToMillis(int interval, int timeUnit) {
        if (timeUnit == TimeUnit.MINUTES.ordinal()) {
            return TimeUnit.MINUTES.toMillis(interval);
        }
        if (timeUnit == TimeUnit.HOURS.ordinal()) {
            return TimeUnit.HOURS.toMillis(interval);
        }
        return TimeUnit.SECONDS.toMillis(interval);
    }
}

