/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.business.salesmerge.process;

import com.systel.sync.business.salesmerge.common.ProcessInterface;
import com.systel.sync.business.salesmerge.common.ProgressCallerInterface;
import com.systel.sync.common.sql.SQLDateTimeUtils;
import com.systel.sync.services.common.ServiceCallback;
import com.systel.sync.services.common.entities.ServiceNodeConnection;
import com.systel.sync.services.common.entities.ServiceNodeTableData;
import com.systel.sync.services.common.entities.ServiceProductData;
import com.systel.sync.services.common.entities.ServiceTable;
import com.systel.sync.services.common.entities.ServiceTableData;
import com.systel.sync.services.salesmerge.local.SalesMergeLocalServiceInterface;
import com.systel.sync.services.salesmerge.remote.SalesMergeRemoteServiceInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import javax.validation.constraints.NotNull;

public final class Merge
implements ProcessInterface {
    private static final String LOG_TAG = Merge.class.getSimpleName();
    private final SalesMergeLocalServiceInterface localService;
    private final SalesMergeRemoteServiceInterface remoteService;
    private final ExecutorService executor;
    private ProgressCallerInterface progressCaller;
    private Long nodeId = null;
    private ArrayList<Long> nodeIds = new ArrayList();

    public Merge(@NotNull SalesMergeLocalServiceInterface localService, @NotNull SalesMergeRemoteServiceInterface remoteService, @NotNull ExecutorService executor) {
        this.localService = localService;
        this.remoteService = remoteService;
        this.executor = executor;
    }

    @Override
    public void execute(@NotNull ProgressCallerInterface progressCaller) {
        this.execute(null, progressCaller);
    }

    @Override
    public void execute(ArrayList<Long> nodeId, @NotNull ProgressCallerInterface progressCaller) {
        this.nodeIds = nodeId;
        this.progressCaller = progressCaller;
        progressCaller.defaultProgress("sales.merge.start", true);
        if (nodeId != null || nodeId.size() >= 1) {
            this.selectNodesConnection();
        } else {
            this.selectNodeConnection();
        }
    }

    private void selectNodeConnection() {
        this.executor.execute(() -> this.localService.selectNodeConnection(new ServiceCallback<ArrayList<ServiceNodeConnection>, Integer>(){

            @Override
            public void onSuccess(ArrayList<ServiceNodeConnection> nodeConnections) {
                if (Merge.this.nodeId != null) {
                    for (Object object : nodeConnections.toArray()) {
                        ServiceNodeConnection nodeConnection = (ServiceNodeConnection)object;
                        if (nodeConnection.getId() == Merge.this.nodeId.longValue()) continue;
                        nodeConnections.remove(nodeConnection);
                    }
                }
                if (nodeConnections.size() > 0) {
                    Merge.this.progressCaller.defaultProgress("sales.merge.nodes.selection.success");
                    Merge.this.selectTables(nodeConnections);
                } else {
                    Merge.this.progressCaller.successProgress("sales.merge.nodes.selection.no.connections.success");
                    Merge.this.progressCaller.success("sales.merge.end.success");
                }
            }

            @Override
            public void onFailure(Integer data) {
                Merge.this.progressCaller.failureProgress("sales.merge.nodes.selection.failure");
                Merge.this.progressCaller.failure("sales.merge.end.failure");
            }
        }));
    }

    private void selectNodesConnection() {
        this.executor.execute(() -> this.localService.selectNodesConnection(new ServiceCallback<ArrayList<ServiceNodeConnection>, Integer>(){

            @Override
            public void onSuccess(ArrayList<ServiceNodeConnection> nodeConnections) {
                if (nodeConnections.size() > 0) {
                    Merge.this.progressCaller.defaultProgress("sales.merge.nodes.selection.success");
                    Merge.this.selectTables(nodeConnections);
                } else {
                    Merge.this.progressCaller.successProgress("sales.merge.nodes.selection.no.connections.success");
                    Merge.this.progressCaller.success("sales.merge.end.success");
                }
            }

            @Override
            public void onFailure(Integer data) {
                Merge.this.progressCaller.failureProgress("sales.merge.nodes.selection.failure");
                Merge.this.progressCaller.failure("sales.merge.end.failure");
            }
        }, this.nodeIds));
    }

    private void selectTables(final ArrayList<ServiceNodeConnection> serviceNodeConnections) {
        this.executor.execute(() -> this.localService.selectTables(new ServiceCallback<ArrayList<ServiceTable>, Integer>(){

            @Override
            public void onSuccess(ArrayList<ServiceTable> serviceTables) {
                if (serviceTables.size() > 0) {
                    Merge.this.progressCaller.defaultProgress("sales.merge.tables.selection.success");
                    Merge.this.selectNodeTables(serviceTables, serviceNodeConnections);
                } else {
                    Merge.this.progressCaller.failureProgress("sales.merge.tables.selection.failure");
                    Merge.this.progressCaller.failure("sales.merge.end.failure");
                }
            }

            @Override
            public void onFailure(Integer data) {
                Merge.this.progressCaller.failureProgress("sales.merge.tables.selection.failure");
                Merge.this.progressCaller.failure("sales.merge.end.failure");
            }
        }));
    }

    private void selectNodeTables(final ArrayList<ServiceTable> serviceTables, final ArrayList<ServiceNodeConnection> serviceNodeConnections) {
        final String endDate = SQLDateTimeUtils.now();
        this.executor.execute(() -> this.remoteService.selectNodeTables(serviceNodeConnections, serviceTables, endDate, new ServiceCallback<ArrayList<ServiceNodeTableData>, Integer>(){

            @Override
            public void onSuccess(ArrayList<ServiceNodeTableData> serviceNodeTablesData) {
                ArrayList<ServiceTableData> serviceTablesData = new ArrayList<ServiceTableData>();
                ArrayList<Long> nodeIds = new ArrayList<Long>();
                for (ServiceNodeTableData serviceNodeTableData : serviceNodeTablesData) {
                    try {
                        if (serviceNodeTableData.getServiceTablesData().size() > 0) {
                            for (ServiceTableData serviceTableData : serviceNodeTableData.getServiceTablesData()) {
                                serviceTablesData.add(serviceTableData);
                            }
                            nodeIds.add(serviceNodeTableData.getServiceNodeConnection().getId());
                            Merge.this.progressCaller.nodeSuccessProgress("sales.merge.remote.node.table.selection.sales.success", serviceNodeTableData.getServiceNodeConnection());
                            continue;
                        }
                        Merge.this.progressCaller.nodeDefaultProgress("sales.merge.remote.node.table.selection.no.sales.success", serviceNodeTableData.getServiceNodeConnection());
                    }
                    catch (NullPointerException ex) {
                        Merge.this.progressCaller.nodeFailureProgress("sales.merge.remote.node.table.selection.connection.failure", serviceNodeTableData.getServiceNodeConnection());
                    }
                }
                if (serviceTablesData.size() > 0) {
                    Merge.this.progressCaller.defaultProgress("sales.merge.remote.tables.selection.success");
                    Collections.sort(serviceTablesData);
                    Merge.this.insertLocalTable(serviceTables, serviceTablesData, nodeIds, endDate, serviceNodeConnections);
                } else {
                    Merge.this.progressCaller.successProgress("sales.merge.remote.tables.selection.no.sales.failure");
                    Merge.this.progressCaller.success("sales.merge.end.success");
                }
            }

            @Override
            public void onFailure(Integer data) {
                Merge.this.progressCaller.failureProgress("sales.merge.remote.tables.selection.failure");
                Merge.this.progressCaller.failure("sales.merge.end.failure");
            }
        }));
    }

    private void deleteValues(final ArrayList<ServiceTable> serviceTables, final ArrayList<ServiceTableData> serviceTableData, final ArrayList<Long> nodeIds, final String endDate, final ArrayList<ServiceNodeConnection> node) {
        this.executor.execute(() -> this.localService.deleteSales(serviceTables, new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                Merge.this.progressCaller.defaultProgress("sales.merge.local.sales.deletion.success");
                Merge.this.insertLocalTable(serviceTables, serviceTableData, nodeIds, endDate, node);
            }

            @Override
            public void onFailure(Integer data) {
                Merge.this.progressCaller.failureProgress("sales.merge.local.sales.deletion.failure");
                Merge.this.progressCaller.failure("sales.merge.end.failure");
            }
        }));
    }

    private void insertLocalTable(final ArrayList<ServiceTable> serviceTables, ArrayList<ServiceTableData> serviceTableData, final ArrayList<Long> nodeIds, final String endDate, final ArrayList<ServiceNodeConnection> node) {
        this.executor.execute(() -> this.localService.insertSales(serviceTableData, new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                Merge.this.progressCaller.defaultProgress("sales.merge.local.sales.insertion.success");
                Merge.this.selectMasterProducts(serviceTables, nodeIds, endDate, node);
            }

            @Override
            public void onFailure(Integer data) {
                Merge.this.progressCaller.failureProgress("sales.merge.local.sales.insertion.failure");
                Merge.this.progressCaller.failure("sales.merge.end.failure");
            }
        }));
    }

    private void selectMasterProducts(final ArrayList<ServiceTable> serviceTables, final ArrayList<Long> nodeIds, final String endDate, final ArrayList<ServiceNodeConnection> node) {
        this.executor.execute(() -> this.remoteService.selectMasterProducts(new ServiceCallback<ArrayList<ServiceProductData>, Integer>(){

            @Override
            public void onSuccess(ArrayList<ServiceProductData> data) {
                if (data.size() > 0) {
                    Merge.this.progressCaller.defaultProgress("sales.merge.remote.master.products.selection.success");
                    Merge.this.updateLocalSales(serviceTables, data, nodeIds, endDate, node);
                } else {
                    Merge.this.progressCaller.failureProgress("sales.merge.remote.master.products.selection.failure");
                    Merge.this.progressCaller.failure("sales.merge.end.failure");
                }
            }

            @Override
            public void onFailure(Integer data) {
                Merge.this.progressCaller.failureProgress("sales.merge.remote.master.products.selection.failure");
                Merge.this.progressCaller.failure("sales.merge.end.failure");
            }
        }));
    }

    private void updateLocalSales(final ArrayList<ServiceTable> serviceTables, ArrayList<ServiceProductData> serviceProductData, final ArrayList<Long> nodeIds, final String endDate, final ArrayList<ServiceNodeConnection> node) {
        this.executor.execute(() -> this.localService.updateSales(serviceProductData, new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                Merge.this.progressCaller.defaultProgress("sales.merge.local.sales.update.success");
                Merge.this.closingSales(serviceTables, nodeIds, endDate, node);
            }

            @Override
            public void onFailure(Integer data) {
                Merge.this.progressCaller.failureProgress("sales.merge.local.sales.update.failure");
                Merge.this.progressCaller.failure("sales.merge.end.failure");
            }
        }));
    }

    private void closingSales(final ArrayList<ServiceTable> serviceTables, final ArrayList<Long> nodeIds, final String endDate, final ArrayList<ServiceNodeConnection> node) {
        this.executor.execute(() -> this.remoteService.closingSales(new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                Merge.this.progressCaller.defaultProgress("sales.merge.remote.closing.sales.succes");
                Merge.this.truncateNodeTables(node, serviceTables, nodeIds, endDate);
            }

            @Override
            public void onFailure(Integer data) {
                Merge.this.progressCaller.failureProgress("sales.merge.remote.closing.sales.failure");
                Merge.this.progressCaller.failure("sales.merge.end.failure");
            }
        }, node));
    }

    private void truncateNodeTables(final ArrayList<ServiceNodeConnection> nodeConnections, final ArrayList<ServiceTable> serviceTables, final ArrayList<Long> nodeIds, final String endDate) {
        TreeSet<ServiceTable> localTables = new TreeSet<ServiceTable>(serviceTables);
        final int[] cont2 = new int[]{0};
        this.remoteService.truncateTables(nodeConnections, localTables, new ServiceCallback<ServiceNodeConnection, ServiceNodeConnection>(){

            @Override
            public void onSuccess(ServiceNodeConnection data) {
                Merge.this.progressCaller.nodeDefaultProgress("full.sync.truncate.node.tables.success", data);
                cont2[0] = cont2[0] + 1;
                if (cont2[0] >= nodeConnections.size()) {
                    Merge.this.selectLocalTables(serviceTables, nodeIds, endDate);
                }
            }

            @Override
            public void onFailure(ServiceNodeConnection data) {
                Merge.this.progressCaller.nodeFailureProgress("full.sync.truncate.node.tables.failure", data);
            }
        });
    }

    private void selectLocalTables(ArrayList<ServiceTable> serviceTables, final ArrayList<Long> nodeIds, final String endDate) {
        this.executor.execute(() -> this.localService.selectSales(serviceTables, new ServiceCallback<ArrayList<ServiceTableData>, Integer>(){

            @Override
            public void onSuccess(ArrayList<ServiceTableData> data) {
                if (data.size() > 0) {
                    Merge.this.progressCaller.defaultProgress("sales.merge.local.sales.selection.success");
                    Collections.sort(data);
                    Merge.this.insertMasterTable(data, nodeIds, endDate);
                } else {
                    Merge.this.progressCaller.failureProgress("sales.merge.local.sales.selection.failure");
                    Merge.this.progressCaller.failure("sales.merge.end.failure");
                }
            }

            @Override
            public void onFailure(Integer data) {
                Merge.this.progressCaller.failureProgress("sales.merge.local.sales.selection.failure");
                Merge.this.progressCaller.failure("sales.merge.end.failure");
            }
        }));
    }

    private void insertMasterTable(ArrayList<ServiceTableData> serviceTableData, final ArrayList<Long> nodeIds, final String endDate) {
        this.executor.execute(() -> this.remoteService.insertMasterSales(serviceTableData, new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                Merge.this.progressCaller.defaultProgress("sales.merge.remote.master.sales.insertion.success");
                Merge.this.updateLocalNodes(nodeIds, endDate);
            }

            @Override
            public void onFailure(Integer data) {
                Merge.this.progressCaller.failureProgress("sales.merge.remote.master.sales.insertion.failure");
                Merge.this.progressCaller.failure("sales.merge.end.failure");
            }
        }));
    }

    private void updateLocalNodes(ArrayList<Long> nodeIds, String endDate) {
        this.executor.execute(() -> this.localService.updateNodes(nodeIds, endDate, new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                Merge.this.progressCaller.defaultProgress("sales.merge.local.nodes.update.success");
                Merge.this.progressCaller.success("sales.merge.end.success");
            }

            @Override
            public void onFailure(Integer data) {
                Merge.this.progressCaller.failureProgress("sales.merge.local.nodes.update.failure");
                Merge.this.progressCaller.failure("sales.merge.end.failure");
            }
        }));
    }
}

