/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.business.salesmerge;

import com.google.common.eventbus.EventBus;
import com.systel.sync.business.common.BusinessCallback;
import com.systel.sync.business.common.BusinessLog;
import com.systel.sync.business.common.BusinessProgressData;
import com.systel.sync.business.common.events.ProgressEventType;
import com.systel.sync.business.salesmerge.SalesMergeInterface;
import com.systel.sync.business.salesmerge.common.ProcessInterface;
import com.systel.sync.business.salesmerge.common.ProgressCaller;
import com.systel.sync.business.salesmerge.events.SalesMergeFailureEvent;
import com.systel.sync.business.salesmerge.events.SalesMergeProgressEvent;
import com.systel.sync.business.salesmerge.events.SalesMergeSuccessEvent;
import com.systel.sync.business.salesmerge.process.Merge;
import com.systel.sync.business.sync.SyncInterface;
import com.systel.sync.services.salesmerge.local.SalesMergeLocalServiceInterface;
import com.systel.sync.services.salesmerge.remote.SalesMergeRemoteServiceInterface;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;

public final class SalesMergeManager
implements SalesMergeInterface {
    private static final String LOG_TAG = SalesMergeManager.class.getSimpleName();
    private ProcessInterface merge;
    private final SalesMergeLocalServiceInterface localService;
    private final SalesMergeRemoteServiceInterface remoteService;
    private final SyncInterface syncManager;
    private final ExecutorService executor;
    private final EventBus eventBus;
    private final ResourceBundle resourceBundle;

    public SalesMergeManager(SalesMergeLocalServiceInterface localService, SalesMergeRemoteServiceInterface remoteService, SyncInterface syncManager, EventBus eventBus, ExecutorService executor, ResourceBundle resourceBundle) {
        this.localService = localService;
        this.remoteService = remoteService;
        this.syncManager = syncManager;
        this.executor = executor;
        this.eventBus = eventBus;
        this.resourceBundle = resourceBundle;
    }

    @Override
    public void merge(final boolean fullSync, final ArrayList<Long> nodeId) {
        this.getMerge().execute(nodeId, new ProgressCaller(new BusinessCallback<String, String, BusinessProgressData>(){

            @Override
            public void onSuccess(String message) {
                try {
                    message = SalesMergeManager.this.resourceBundle.getString(message);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                BusinessLog.logDebug(LOG_TAG, message);
                if (fullSync) {
                    BusinessLog.logDebug(LOG_TAG, message);
                    SalesMergeManager.this.eventBus.post(new SalesMergeProgressEvent(message, ProgressEventType.SUCCESS, true));
                    SalesMergeManager.this.syncManager.fullSync((Long)nodeId.get(0));
                }
                SalesMergeManager.this.eventBus.post(new SalesMergeSuccessEvent(message));
                SalesMergeManager.this.merge = null;
                System.gc();
            }

            @Override
            public void onFailure(String message) {
                try {
                    message = SalesMergeManager.this.resourceBundle.getString(message);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                BusinessLog.logError(LOG_TAG, message);
                SalesMergeManager.this.eventBus.post(new SalesMergeFailureEvent(message));
                SalesMergeManager.this.merge = null;
                System.gc();
            }

            @Override
            public void onProgress(BusinessProgressData data) {
                String message = data.getMessage();
                try {
                    message = SalesMergeManager.this.resourceBundle.getString(data.getMessage());
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                if (data.getType().equals((Object)ProgressEventType.FAILURE)) {
                    BusinessLog.logError(LOG_TAG, message);
                } else {
                    BusinessLog.logDebug(LOG_TAG, message);
                }
                SalesMergeManager.this.eventBus.post(new SalesMergeProgressEvent(message, data.getType(), data.isHighlighted()));
            }
        }, this.resourceBundle));
    }

    private ProcessInterface getMerge() {
        try {
            this.merge.equals(this.merge);
        }
        catch (NullPointerException ex) {
            this.merge = new Merge(this.localService, this.remoteService, this.executor);
        }
        return this.merge;
    }
}

