/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.business.preferences;

import com.google.common.eventbus.EventBus;
import com.systel.sync.business.common.BusinessLog;
import com.systel.sync.business.common.entities.PreferencesData;
import com.systel.sync.business.preferences.PreferencesInterface;
import com.systel.sync.business.preferences.events.GetPreferencesFailureEvent;
import com.systel.sync.business.preferences.events.GetPreferencesSuccessEvent;
import com.systel.sync.business.preferences.events.UpdatePreferencesFailureEvent;
import com.systel.sync.business.preferences.events.UpdatePreferencesSuccessEvent;
import com.systel.sync.services.common.ServiceCallback;
import com.systel.sync.services.preferences.PreferencesServiceInterface;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;

public final class PreferencesManager
implements PreferencesInterface {
    private static final String LOG_TAG = PreferencesManager.class.getSimpleName();
    private final PreferencesServiceInterface service;
    private final ExecutorService executor;
    private final EventBus eventBus;
    private final ResourceBundle resourceBundle;
    private PreferencesData preferencesData;

    public PreferencesManager(PreferencesServiceInterface service, EventBus eventBus, ExecutorService executor, ResourceBundle resourceBundle) {
        this.service = service;
        this.executor = executor;
        this.eventBus = eventBus;
        this.resourceBundle = resourceBundle;
    }

    @Override
    public void load() {
        this.service.select(new ServiceCallback<PreferencesData, Integer>(){

            @Override
            public void onSuccess(PreferencesData data) {
                PreferencesManager.this.setData(data);
                String message = PreferencesManager.this.resourceBundle.getString("preferences.load.success");
                BusinessLog.logDebug(LOG_TAG, message);
                PreferencesManager.this.eventBus.post(new GetPreferencesSuccessEvent(message));
            }

            @Override
            public void onFailure(Integer data) {
                String message = PreferencesManager.this.resourceBundle.getString("preferences.load.failure");
                BusinessLog.logError(LOG_TAG, message);
                PreferencesManager.this.eventBus.post(new GetPreferencesFailureEvent(message));
            }
        });
    }

    @Override
    public void update(final PreferencesData preferencesData) {
        this.executor.execute(() -> this.service.update(preferencesData, new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                PreferencesManager.this.setData(preferencesData);
                String message = PreferencesManager.this.resourceBundle.getString("preferences.update.success");
                BusinessLog.logDebug(LOG_TAG, message);
                PreferencesManager.this.eventBus.post(new UpdatePreferencesSuccessEvent(message));
            }

            @Override
            public void onFailure(Integer data) {
                String message = PreferencesManager.this.resourceBundle.getString("preferences.update.failure");
                BusinessLog.logError(LOG_TAG, message);
                PreferencesManager.this.eventBus.post(new UpdatePreferencesFailureEvent(message));
            }
        }));
    }

    @Override
    public PreferencesData getData() {
        return this.preferencesData;
    }

    @Override
    public void setData(PreferencesData preferencesData) {
        this.preferencesData = preferencesData;
    }
}

