/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.business.nodes.models;

import com.google.common.eventbus.EventBus;
import com.systel.sync.business.common.BusinessLog;
import com.systel.sync.business.common.entities.NodeModel;
import com.systel.sync.business.nodes.models.NodeModelsInterface;
import com.systel.sync.business.nodes.models.events.GetNodeModelsFailureEvent;
import com.systel.sync.business.nodes.models.events.GetNodeModelsSuccessEvent;
import com.systel.sync.services.common.ServiceCallback;
import com.systel.sync.services.nodes.models.NodeModelsServiceInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;

public final class NodeModelsManager
implements NodeModelsInterface {
    private static final String LOG_TAG = NodeModelsManager.class.getSimpleName();
    private final NodeModelsServiceInterface service;
    private final ExecutorService executor;
    private final EventBus eventBus;
    private final ResourceBundle resourceBundle;
    private ArrayList<NodeModel> models;

    public NodeModelsManager(NodeModelsServiceInterface service, EventBus eventBus, ExecutorService executor, ResourceBundle resourceBundle) {
        this.service = service;
        this.executor = executor;
        this.eventBus = eventBus;
        this.resourceBundle = resourceBundle;
    }

    @Override
    public void loadModels() {
        this.executor.execute(() -> this.service.selectModels(new ServiceCallback<ArrayList<NodeModel>, Integer>(){

            @Override
            public void onSuccess(ArrayList<NodeModel> models) {
                for (NodeModel nodeModel : models) {
                    nodeModel.setName(NodeModelsManager.this.resourceBundle.getString(nodeModel.getName()));
                }
                NodeModelsManager.this.setModels(models);
                String message = NodeModelsManager.this.resourceBundle.getString("node.models.load.success");
                BusinessLog.logDebug(LOG_TAG, message);
                NodeModelsManager.this.eventBus.post(new GetNodeModelsSuccessEvent(message));
            }

            @Override
            public void onFailure(Integer data) {
                String message = NodeModelsManager.this.resourceBundle.getString("node.models.load.failure");
                BusinessLog.logError(LOG_TAG, message);
                NodeModelsManager.this.eventBus.post(new GetNodeModelsFailureEvent(message));
            }
        }));
    }

    @Override
    public void setModels(ArrayList<NodeModel> models) {
        this.models = models;
    }

    @Override
    public ArrayList<NodeModel> getModels() {
        ArrayList<NodeModel> newList = new ArrayList<NodeModel>(this.models);
        Collections.sort(newList);
        return newList;
    }
}

