/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.business.nodes;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.systel.sync.business.common.BusinessLog;
import com.systel.sync.business.common.entities.Node;
import com.systel.sync.business.common.events.ProgressEventType;
import com.systel.sync.business.nodes.NodesInterface;
import com.systel.sync.business.nodes.events.CreateNodeFailureEvent;
import com.systel.sync.business.nodes.events.CreateNodeSuccessEvent;
import com.systel.sync.business.nodes.events.DiscoverNodesFailureEvent;
import com.systel.sync.business.nodes.events.DiscoverNodesProgressEvent;
import com.systel.sync.business.nodes.events.DiscoverNodesSuccessEvent;
import com.systel.sync.business.nodes.events.DuplicateNodeFailureEvent;
import com.systel.sync.business.nodes.events.LoadNodesFailureEvent;
import com.systel.sync.business.nodes.events.LoadNodesSuccessEvent;
import com.systel.sync.business.nodes.events.NodeStatusUpdateEvent;
import com.systel.sync.business.nodes.events.RemoveNodeFailureEvent;
import com.systel.sync.business.nodes.events.RemoveNodeSuccessEvent;
import com.systel.sync.business.nodes.events.UpdateNodeFailureEvent;
import com.systel.sync.business.nodes.events.UpdateNodeSuccessEvent;
import com.systel.sync.business.nodes.events.UploadNodesFailureEvent;
import com.systel.sync.business.nodes.events.UploadNodesSuccessEvent;
import com.systel.sync.business.salesmerge.events.SalesMergeFailureEvent;
import com.systel.sync.business.salesmerge.events.SalesMergeSuccessEvent;
import com.systel.sync.business.sync.events.ScheduledStatusVerificationFailureEvent;
import com.systel.sync.business.sync.events.ScheduledStatusVerificationSuccessEvent;
import com.systel.sync.business.sync.events.ScheduledSyncFailureEvent;
import com.systel.sync.business.sync.events.ScheduledSyncSuccessEvent;
import com.systel.sync.business.sync.events.StatusResetFailureEvent;
import com.systel.sync.business.sync.events.StatusResetSuccessEvent;
import com.systel.sync.business.sync.events.StatusVerificationFailureEvent;
import com.systel.sync.business.sync.events.StatusVerificationSuccessEvent;
import com.systel.sync.business.sync.events.SyncFailureEvent;
import com.systel.sync.business.sync.events.SyncProcessingNodesEvent;
import com.systel.sync.business.sync.events.SyncSuccessEvent;
import com.systel.sync.business.users.UsersInterface;
import com.systel.sync.common.translation.TranslationHelper;
import com.systel.sync.services.common.ServiceCallback;
import com.systel.sync.services.common.ServiceCallbackWithProgress;
import com.systel.sync.services.common.entities.ServiceNode;
import com.systel.sync.services.common.entities.ServiceNodeConnection;
import com.systel.sync.services.nodes.local.NodesLocalServiceInterface;
import com.systel.sync.services.nodes.local.results.DiscoverNodeResult;
import com.systel.sync.services.nodes.remote.NodesRemoteServiceInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.stage.Modality;

public final class NodesManager
implements NodesInterface {
    private static final String LOG_TAG = NodesManager.class.getSimpleName();
    private final NodesLocalServiceInterface localService;
    private final NodesRemoteServiceInterface remoteService;
    private final ExecutorService executor;
    private final EventBus eventBus;
    private final ResourceBundle resourceBundle;
    private ArrayList<Node> nodes;
    private final UsersInterface userManager;

    public NodesManager(NodesLocalServiceInterface localService, NodesRemoteServiceInterface remoteService, EventBus eventBus, ExecutorService executor, ResourceBundle resourceBundle, UsersInterface userManager) {
        this.localService = localService;
        this.remoteService = remoteService;
        this.executor = executor;
        this.resourceBundle = resourceBundle;
        this.eventBus = eventBus;
        this.eventBus.register(this);
        this.userManager = userManager;
    }

    @Override
    public void discoverNodes() {
        String message = this.resourceBundle.getString("nodes.discovery.start");
        BusinessLog.logDebug(LOG_TAG, message);
        this.eventBus.post(new DiscoverNodesProgressEvent(message, ProgressEventType.DEFAULT, true));
        this.executor.execute(() -> this.localService.discoverNodes(new ServiceCallbackWithProgress<Integer, Integer, DiscoverNodeResult>(){

            @Override
            public void onSuccess(Integer data) {
                String message = NodesManager.this.resourceBundle.getString("nodes.discovery.success");
                BusinessLog.logDebug(LOG_TAG, message);
                NodesManager.this.eventBus.post(new DiscoverNodesSuccessEvent(message));
                NodesManager.this.loadNodes();
            }

            @Override
            public void onFailure(Integer data) {
                String message = NodesManager.this.resourceBundle.getString("nodes.discovery.failure");
                BusinessLog.logError(LOG_TAG, message);
                NodesManager.this.eventBus.post(new DiscoverNodesFailureEvent(message));
            }

            @Override
            public void onProgress(DiscoverNodeResult data) {
                String message = NodesManager.this.resourceBundle.getString("nodes.discovery.success");
                ProgressEventType type = ProgressEventType.SUCCESS;
                switch (data.getResultCode()) {
                    case -3: {
                        message = NodesManager.this.resourceBundle.getString("nodes.discovery.failure");
                        type = ProgressEventType.FAILURE;
                        break;
                    }
                    case 3000: {
                        message = NodesManager.this.resourceBundle.getString("nodes.discovery.node.creation.success");
                        type = ProgressEventType.SUCCESS;
                        break;
                    }
                    case 3001: {
                        message = NodesManager.this.resourceBundle.getString("nodes.discovery.node.update.failure");
                        type = ProgressEventType.FAILURE;
                        break;
                    }
                    case 3002: {
                        message = NodesManager.this.resourceBundle.getString("nodes.discovery.node.update.success");
                        type = ProgressEventType.SUCCESS;
                        break;
                    }
                    case 3003: {
                        message = NodesManager.this.resourceBundle.getString("nodes.discovery.host.connection.failure");
                        type = ProgressEventType.FAILURE;
                        break;
                    }
                    case 3004: {
                        message = NodesManager.this.resourceBundle.getString("nodes.discovery.node.repeat.failure");
                        type = ProgressEventType.FAILURE;
                        break;
                    }
                    case 3005: {
                        message = NodesManager.this.resourceBundle.getString("nodes.discovery.remove.success");
                        type = ProgressEventType.FAILURE;
                    }
                }
                if (data.getNode() != null) {
                    if (data.getNode().getIpAddress() != null) {
                        message = message.replace("#ipAddress#", data.getNode().getIpAddress());
                    }
                    if (data.getNode().getNumber() != null) {
                        message = message.replace("#number#", data.getNode().getNumber());
                    }
                }
                if (type.equals((Object)ProgressEventType.FAILURE) && data.getResultCode() != 3003) {
                    BusinessLog.logError(LOG_TAG, message);
                } else if (type.equals((Object)ProgressEventType.SUCCESS)) {
                    BusinessLog.logDebug(LOG_TAG, message);
                }
                NodesManager.this.eventBus.post(new DiscoverNodesProgressEvent(message, type, false));
            }
        }, this.nodes));
    }

    @Override
    public void loadNodes() {
        this.executor.execute(() -> this.localService.selectNodes(new ServiceCallback<ArrayList<Node>, Integer>(){

            @Override
            public void onSuccess(ArrayList<Node> nodes) {
                NodesManager.this.setNodes(nodes);
                NodesManager.this.uploadNodes();
                String message = NodesManager.this.resourceBundle.getString("nodes.load.success");
                BusinessLog.logDebug(LOG_TAG, message);
                NodesManager.this.eventBus.post(new LoadNodesSuccessEvent(message, false));
            }

            @Override
            public void onFailure(Integer data) {
                String message = NodesManager.this.resourceBundle.getString("nodes.load.failure");
                BusinessLog.logError(LOG_TAG, message);
                NodesManager.this.eventBus.post(new LoadNodesFailureEvent(message));
            }
        }));
    }

    @Override
    public void uploadNodes() {
        this.executor.execute(() -> {
            if (this.nodes != null && this.nodes.size() > 0) {
                ArrayList<ServiceNode> serviceNodes = new ArrayList<ServiceNode>();
                for (Node node : this.nodes) {
                    ServiceNode serviceNode = new ServiceNode();
                    serviceNode.setNumber(node.getNumber());
                    serviceNode.setName(node.getName());
                    serviceNode.setStatusName(TranslationHelper.translate(this.resourceBundle, node.getStatus()));
                    serviceNode.setIpAddress(node.getIpAddress());
                    serviceNode.setUser(this.userManager.getUser().getUsername());
                    serviceNodes.add(serviceNode);
                }
                this.remoteService.uploadNodes(serviceNodes, new ServiceCallback<Integer, Integer>(){

                    @Override
                    public void onSuccess(Integer data) {
                        String message = NodesManager.this.resourceBundle.getString("nodes.upload.success");
                        BusinessLog.logDebug(LOG_TAG, message);
                        NodesManager.this.eventBus.post(new UploadNodesSuccessEvent(message));
                    }

                    @Override
                    public void onFailure(Integer data) {
                        String message = NodesManager.this.resourceBundle.getString("nodes.upload.failure");
                        BusinessLog.logError(LOG_TAG, message);
                        NodesManager.this.eventBus.post(new UploadNodesFailureEvent(message));
                    }
                });
            } else {
                String message = this.resourceBundle.getString("nodes.upload.success");
                BusinessLog.logDebug(LOG_TAG, message);
                this.eventBus.post(new UploadNodesSuccessEvent(message));
            }
        });
    }

    @Override
    public void setNodes(ArrayList<Node> nodes) {
        this.nodes = nodes;
    }

    @Override
    public ArrayList<Node> getNodes() {
        ArrayList<Node> newList = new ArrayList<Node>(this.nodes);
        Collections.sort(newList);
        return newList;
    }

    @Override
    public void setNode(Node node) {
        if (node.getId() <= 0L) {
            this.createNode(node);
        } else {
            this.changeNode(node);
        }
    }

    @Override
    public void selectUpdateNode(final Node node) {
        this.remoteService.selectUpdateNodes(node, new ServiceCallback<ServiceNodeConnection, Integer>(){

            @Override
            public void onSuccess(ServiceNodeConnection nodeConnection) {
                NodesManager.this.updateNode(node, nodeConnection);
                String message = NodesManager.this.resourceBundle.getString("verify.status.select.node.connections.success");
                BusinessLog.logDebug(LOG_TAG, message);
                NodesManager.this.eventBus.post(new LoadNodesSuccessEvent(message, false));
            }

            @Override
            public void onFailure(Integer data) {
                String message = NodesManager.this.resourceBundle.getString("verify.status.select.node.connections.failure");
                BusinessLog.logError(LOG_TAG, message);
                NodesManager.this.eventBus.post(new UploadNodesFailureEvent(message));
            }
        });
    }

    @Override
    public void updateNode(final Node node, ServiceNodeConnection nodeConnection) {
        this.remoteService.updateNodes(node, nodeConnection, new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                String message = NodesManager.this.resourceBundle.getString("nodes.update_id_number.success");
                BusinessLog.logDebug(LOG_TAG, message);
                NodesManager.this.eventBus.post(new UploadNodesSuccessEvent(message));
                NodesManager.this.updateVariables(node);
            }

            @Override
            public void onFailure(Integer data) {
                String message = NodesManager.this.resourceBundle.getString("nodes.update_id_number.failure");
                BusinessLog.logDebug(LOG_TAG, message);
                NodesManager.this.eventBus.post(new UploadNodesSuccessEvent(message));
            }
        });
    }

    @Override
    public void updateVariables(Node node) {
        this.remoteService.updateVariables(node.getIpAddress(), new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                String message = NodesManager.this.resourceBundle.getString("nodes.update_id_number.success");
                BusinessLog.logDebug(LOG_TAG, message);
            }

            @Override
            public void onFailure(Integer data) {
                String message = NodesManager.this.resourceBundle.getString("nodes.update_id_number.failure");
                BusinessLog.logDebug(LOG_TAG, message);
            }
        });
    }

    @Override
    public void createNode(Node nodeValues) {
        this.executor.execute(() -> {
            final Node node = new Node.Cloner(nodeValues).clone();
            node.setStatus(0);
            this.localService.selectNodes(new ServiceCallback<ArrayList<Node>, Integer>(){

                @Override
                public void onSuccess(ArrayList<Node> nodes) {
                    boolean node_ok = false;
                    if (nodes.size() == 0) {
                        node_ok = true;
                    }
                    for (Node node2 : nodes) {
                        if (node2.getIpAddress().equalsIgnoreCase(node.getIpAddress())) {
                            NodesManager.this.Alert(node2.getIpAddress());
                            node_ok = false;
                            break;
                        }
                        node_ok = true;
                        if (node2.getNumber().equalsIgnoreCase(node.getNumber())) {
                            NodesManager.this.Alert(node2.getNumber());
                            node_ok = false;
                            break;
                        }
                        node_ok = true;
                    }
                    if (node_ok) {
                        NodesManager.this.localService.insertNodeRow(node, new ServiceCallback<Integer, Integer>(){

                            @Override
                            public void onSuccess(Integer data) {
                                NodesManager.this.loadNodes();
                                String message = NodesManager.this.resourceBundle.getString("nodes.create.success");
                                BusinessLog.logDebug(LOG_TAG, message);
                                NodesManager.this.eventBus.post(new CreateNodeSuccessEvent(message));
                            }

                            @Override
                            public void onFailure(Integer data) {
                                if (data == -4) {
                                    String message = NodesManager.this.resourceBundle.getString("nodes.duplicate.failure");
                                    BusinessLog.logError(LOG_TAG, message);
                                    NodesManager.this.eventBus.post(new DuplicateNodeFailureEvent(message));
                                } else {
                                    String message = NodesManager.this.resourceBundle.getString("nodes.create.failure");
                                    BusinessLog.logError(LOG_TAG, message);
                                    NodesManager.this.eventBus.post(new CreateNodeFailureEvent(message));
                                }
                            }
                        });
                    }
                    String message = NodesManager.this.resourceBundle.getString("nodes.create.failure");
                    BusinessLog.logError(LOG_TAG, message);
                    NodesManager.this.eventBus.post(new CreateNodeFailureEvent(message));
                }

                @Override
                public void onFailure(Integer data) {
                    String message = NodesManager.this.resourceBundle.getString("nodes.load.failure");
                    BusinessLog.logError(LOG_TAG, message);
                    NodesManager.this.eventBus.post(new LoadNodesFailureEvent(message));
                }
            });
        });
    }

    @Override
    public void changeNode(Node nodeValues) {
        this.executor.execute(() -> {
            Node node = new Node.Cloner(nodeValues).clone();
            this.localService.updateNodeRow(node, new ServiceCallback<Integer, Integer>(){

                @Override
                public void onSuccess(Integer affectedRows) {
                    NodesManager.this.loadNodes();
                    String message = NodesManager.this.resourceBundle.getString("nodes.update.success");
                    BusinessLog.logDebug(LOG_TAG, message);
                    NodesManager.this.eventBus.post(new UpdateNodeSuccessEvent(message));
                }

                @Override
                public void onFailure(Integer data) {
                    if (data == -4) {
                        String message = NodesManager.this.resourceBundle.getString("nodes.duplicate.failure");
                        BusinessLog.logError(LOG_TAG, message);
                        NodesManager.this.eventBus.post(new DuplicateNodeFailureEvent(message));
                    } else {
                        String message = NodesManager.this.resourceBundle.getString("nodes.update.failure");
                        BusinessLog.logError(LOG_TAG, message);
                        NodesManager.this.eventBus.post(new UpdateNodeFailureEvent(message));
                    }
                }
            });
        });
    }

    @Override
    public void removeNode(long nodeId) {
        this.executor.execute(() -> this.localService.deleteNodeRow(nodeId, new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                NodesManager.this.loadNodes();
                String message = NodesManager.this.resourceBundle.getString("nodes.remove.success");
                BusinessLog.logDebug(LOG_TAG, message);
                NodesManager.this.eventBus.post(new RemoveNodeSuccessEvent(message));
            }

            @Override
            public void onFailure(Integer data) {
                String message = NodesManager.this.resourceBundle.getString("nodes.remove.failure");
                BusinessLog.logError(LOG_TAG, message);
                NodesManager.this.eventBus.post(new RemoveNodeFailureEvent(message));
            }
        }));
    }

    @Override
    public void removeNodes(ArrayList<Long> nodeId) {
        this.executor.execute(() -> this.localService.deleteNodes(nodeId, new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                String message = NodesManager.this.resourceBundle.getString("nodes.remove.success");
                BusinessLog.logDebug(LOG_TAG, message);
                NodesManager.this.eventBus.post(new RemoveNodeSuccessEvent(message));
            }

            @Override
            public void onFailure(Integer data) {
                String message = NodesManager.this.resourceBundle.getString("nodes.remove.failure");
                BusinessLog.logError(LOG_TAG, message);
                NodesManager.this.eventBus.post(new RemoveNodeFailureEvent(message));
            }
        }));
    }

    @Subscribe
    public void onStatusResetSuccessEvent(StatusResetSuccessEvent event) {
        this.loadNodes();
    }

    @Subscribe
    public void onStatusResetFailureEvent(StatusResetFailureEvent event) {
        this.loadNodes();
    }

    @Subscribe
    public void onStatusVerificationSuccessEvent(StatusVerificationSuccessEvent event) {
        this.loadNodes();
    }

    @Subscribe
    public void onStatusVerificationFailureEvent(StatusVerificationFailureEvent event) {
        this.loadNodes();
    }

    @Subscribe
    public void onSyncSuccessEvent(SyncSuccessEvent event) {
        this.loadNodes();
    }

    @Subscribe
    public void onSyncFailureEvent(SyncFailureEvent event) {
        this.loadNodes();
    }

    @Subscribe
    public void onNodeStatusUpdateEvent(NodeStatusUpdateEvent event) {
        if (this.nodes != null && this.nodes.size() > 0) {
            this.nodes.get(this.nodes.indexOf(event.getNode())).setStatus(event.getNode().getStatus());
            String message = this.resourceBundle.getString("nodes.load.success");
            BusinessLog.logDebug(LOG_TAG, message);
            this.eventBus.post(new LoadNodesSuccessEvent(message, true));
        }
    }

    @Subscribe
    public void onSyncProcessingNodesEvent(SyncProcessingNodesEvent event) {
        if (event.getNodeId() != null || event.getNodeIds() != null && this.nodes != null && this.nodes.size() > 0) {
            for (Node node : this.nodes) {
                if (event.getNodeId() != null) {
                    if (event.getNodeId() != null && (event.getNodeId() == null || node.getId() != event.getNodeId().longValue())) continue;
                    node.setStatus(5);
                    continue;
                }
                for (int i = 0; i < event.getNodeIds().size(); ++i) {
                    if (event.getNodeIds() != null && (event.getNodeIds() == null || node.getId() != event.getNodeIds().get(i).longValue())) continue;
                    node.setStatus(5);
                }
            }
            String message = this.resourceBundle.getString("nodes.load.success");
            BusinessLog.logDebug(LOG_TAG, message);
            this.eventBus.post(new LoadNodesSuccessEvent(message, true));
        } else {
            for (Node node : this.nodes) {
                node.setStatus(5);
            }
            String message = this.resourceBundle.getString("nodes.load.success");
            BusinessLog.logDebug(LOG_TAG, message);
            this.eventBus.post(new LoadNodesSuccessEvent(message, true));
        }
    }

    public void Alert(String param) {
        if (param.contains(".")) {
            Platform.runLater(() -> {
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle(this.resourceBundle.getString("nodes.discovery.id.repeat"));
                alert.setHeaderText(this.resourceBundle.getString("nodes.ip.repeat.alert"));
                alert.initModality(Modality.APPLICATION_MODAL);
                alert.showAndWait();
            });
        } else {
            Platform.runLater(() -> {
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle(this.resourceBundle.getString("nodes.discovery.id.repeat"));
                alert.setHeaderText(this.resourceBundle.getString("nodes.number.repeat.alert"));
                alert.initModality(Modality.APPLICATION_MODAL);
                alert.show();
            });
        }
    }

    @Subscribe
    public void onScheduledStatusVerificationSuccessEvent(ScheduledStatusVerificationSuccessEvent event) {
        this.loadNodes();
    }

    @Subscribe
    public void onScheduledStatusVerificationFailureEvent(ScheduledStatusVerificationFailureEvent event) {
        this.loadNodes();
    }

    @Subscribe
    public void onScheduledSyncSuccessEvent(ScheduledSyncSuccessEvent event) {
        this.loadNodes();
    }

    @Subscribe
    public void onScheduledSyncFailureEvent(ScheduledSyncFailureEvent event) {
        this.loadNodes();
    }

    @Subscribe
    public void onSalesMergeSuccessEvent(SalesMergeSuccessEvent event) {
        this.loadNodes();
    }

    @Subscribe
    public void onSalesMergeFailureEvent(SalesMergeFailureEvent event) {
        this.loadNodes();
    }
}

