/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.business.log;

import com.google.common.eventbus.EventBus;
import com.systel.sync.business.common.BusinessLog;
import com.systel.sync.business.log.LogInterface;
import com.systel.sync.business.log.events.ClearLogFailureEvent;
import com.systel.sync.business.log.events.ClearLogSuccessEvent;
import com.systel.sync.business.log.events.ExportLogFailureEvent;
import com.systel.sync.business.log.events.ExportLogSuccessEvent;
import com.systel.sync.business.log.events.GetLogLevelsFailureEvent;
import com.systel.sync.business.log.events.GetLogLevelsSuccessEvent;
import com.systel.sync.log.LogLevel;
import com.systel.sync.services.common.ServiceCallback;
import com.systel.sync.services.log.LogServiceInterface;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;

public class LogManager
implements LogInterface {
    private static final String LOG_TAG = LogManager.class.getSimpleName();
    private final LogServiceInterface service;
    private final ExecutorService executor;
    private final EventBus eventBus;
    private final ResourceBundle resourceBundle;

    public LogManager(LogServiceInterface service, EventBus eventBus, ExecutorService executor, ResourceBundle resourceBundle) {
        this.service = service;
        this.eventBus = eventBus;
        this.executor = executor;
        this.resourceBundle = resourceBundle;
    }

    @Override
    public void getLogLevels() {
        this.executor.execute(() -> this.service.getLogLevels(new ServiceCallback<List<LogLevel>, Integer>(){

            @Override
            public void onSuccess(List<LogLevel> logLevels) {
                String message = LogManager.this.resourceBundle.getString("log.levels.load.success");
                BusinessLog.logDebug(LOG_TAG, message);
                LogManager.this.eventBus.post(new GetLogLevelsSuccessEvent(message, logLevels));
            }

            @Override
            public void onFailure(Integer data) {
                String message = LogManager.this.resourceBundle.getString("log.levels.load.failure");
                BusinessLog.logError(LOG_TAG, message);
                LogManager.this.eventBus.post(new GetLogLevelsFailureEvent(message));
            }
        }));
    }

    @Override
    public void clear() {
        this.executor.execute(() -> this.service.clear(new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                String message = LogManager.this.resourceBundle.getString("log.clear.success");
                BusinessLog.logDebug(LOG_TAG, message);
                LogManager.this.eventBus.post(new ClearLogSuccessEvent(message));
            }

            @Override
            public void onFailure(Integer data) {
                String message = LogManager.this.resourceBundle.getString("log.clear.failure");
                BusinessLog.logError(LOG_TAG, message);
                LogManager.this.eventBus.post(new ClearLogFailureEvent(message));
            }
        }));
    }

    @Override
    public void export(String filePath) {
        this.executor.execute(() -> this.service.export(filePath, new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                String message = LogManager.this.resourceBundle.getString("log.export.success");
                BusinessLog.logDebug(LOG_TAG, message);
                LogManager.this.eventBus.post(new ExportLogSuccessEvent(message));
            }

            @Override
            public void onFailure(Integer data) {
                String message = LogManager.this.resourceBundle.getString("log.export.failure");
                BusinessLog.logError(LOG_TAG, message);
                LogManager.this.eventBus.post(new ExportLogFailureEvent(message));
            }
        }));
    }
}

