/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.business.language;

import com.google.common.eventbus.EventBus;
import com.systel.sync.business.common.BusinessLog;
import com.systel.sync.business.language.LanguageInterface;
import com.systel.sync.business.language.events.GetLanguagesFailureEvent;
import com.systel.sync.business.language.events.GetLanguagesSuccessEvent;
import com.systel.sync.common.Language;
import com.systel.sync.services.common.ServiceCallback;
import com.systel.sync.services.language.LanguageServiceInterface;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;

public class LanguageManager
implements LanguageInterface {
    private static final String LOG_TAG = LanguageManager.class.getSimpleName();
    private final LanguageServiceInterface service;
    private final ExecutorService executor;
    private final EventBus eventBus;
    private final ResourceBundle resourceBundle;

    public LanguageManager(LanguageServiceInterface service, EventBus eventBus, ExecutorService executor, ResourceBundle resourceBundle) {
        this.service = service;
        this.eventBus = eventBus;
        this.executor = executor;
        this.resourceBundle = resourceBundle;
    }

    @Override
    public void getLanguages() {
        this.executor.execute(() -> this.service.getLanguages(new ServiceCallback<List<Language>, Integer>(){

            @Override
            public void onSuccess(List<Language> languages) {
                for (Language language : languages) {
                    language.setName(LanguageManager.this.resourceBundle.getString(language.getName()));
                }
                String message = LanguageManager.this.resourceBundle.getString("languages.load.success");
                BusinessLog.logDebug(LOG_TAG, message);
                LanguageManager.this.eventBus.post(new GetLanguagesSuccessEvent(message, languages));
            }

            @Override
            public void onFailure(Integer data) {
                String message = LanguageManager.this.resourceBundle.getString("languages.load.failure");
                BusinessLog.logError(LOG_TAG, message);
                LanguageManager.this.eventBus.post(new GetLanguagesFailureEvent(message));
            }
        }));
    }
}

