/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.business.install;

import com.google.common.eventbus.EventBus;
import com.systel.sync.business.common.entities.InstallData;
import com.systel.sync.business.install.InstallInterface;
import com.systel.sync.business.install.events.InstallFailureEvent;
import com.systel.sync.business.install.events.InstallSuccessEvent;
import com.systel.sync.business.install.events.InstallationTestFailureEvent;
import com.systel.sync.business.install.events.InstallationTestMasterFailureEvent;
import com.systel.sync.business.install.events.InstallationTestSuccessEvent;
import com.systel.sync.business.install.events.UpdateDbFailureEvent;
import com.systel.sync.business.install.events.UpdateDbSuccesEvent;
import com.systel.sync.services.common.ServiceCallback;
import com.systel.sync.services.install.InstallServiceInterface;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;

public class InstallManager
implements InstallInterface {
    private final InstallServiceInterface service;
    private final ExecutorService executor;
    private final EventBus eventBus;
    private final ResourceBundle resourceBundle;

    public InstallManager(InstallServiceInterface service, EventBus eventBus, ExecutorService executor, ResourceBundle resourceBundle) {
        this.service = service;
        this.eventBus = eventBus;
        this.executor = executor;
        this.resourceBundle = resourceBundle;
    }

    @Override
    public void testInstall() {
        this.executor.execute(() -> this.service.testInstall(new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                InstallManager.this.eventBus.post(new InstallationTestSuccessEvent());
            }

            @Override
            public void onFailure(Integer data) {
                String message = "install.test.error.unknown";
                switch (data) {
                    case -1000: {
                        message = "install.test.error.local.connection.failed";
                        break;
                    }
                    case -1001: {
                        message = "install.test.error.master.connection.failed";
                        InstallManager.this.eventBus.post(new InstallationTestMasterFailureEvent(InstallManager.this.resourceBundle.getString(message)));
                        return;
                    }
                }
                InstallManager.this.eventBus.post(new InstallationTestFailureEvent(InstallManager.this.resourceBundle.getString(message)));
            }
        }));
    }

    @Override
    public void install(InstallData installData) {
        this.executor.execute(() -> this.service.install(installData, new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                InstallManager.this.eventBus.post(new InstallSuccessEvent());
            }

            @Override
            public void onFailure(Integer data) {
                String message = "install.error.unknown";
                switch (data) {
                    case -1000: {
                        message = "install.error.local.connection.failed";
                        break;
                    }
                    case -1001: {
                        message = "install.error.master.connection.failed";
                        break;
                    }
                    case -1002: {
                        message = "install.error.install.connection.failed";
                        break;
                    }
                    case -1003: {
                        message = "install.error.database.creation.failed";
                        break;
                    }
                    case -1004: {
                        message = "install.error.tables.creation.failed";
                    }
                }
                InstallManager.this.eventBus.post(new InstallFailureEvent(InstallManager.this.resourceBundle.getString(message)));
            }
        }));
    }

    @Override
    public void updateDb(ArrayList<String> nodeIps) {
        this.executor.execute(() -> this.service.updateDb(new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                InstallManager.this.eventBus.post(new UpdateDbSuccesEvent());
            }

            @Override
            public void onFailure(Integer data) {
                InstallManager.this.eventBus.post(new UpdateDbFailureEvent(InstallManager.this.resourceBundle.getString("db.update.failure")));
            }
        }, nodeIps, System.getProperty("os.name")));
    }

    @Override
    public void setMasterIp(String masterIpAddress) {
        this.executor.execute(() -> this.service.setMasterIp(masterIpAddress, new ServiceCallback<Integer, Integer>(){

            @Override
            public void onSuccess(Integer data) {
                InstallManager.this.eventBus.post(new InstallSuccessEvent());
            }

            @Override
            public void onFailure(Integer data) {
                String message = "install.error.unknown";
                switch (data) {
                    case -1001: {
                        message = "install.error.master.connection.failed";
                    }
                }
                InstallManager.this.eventBus.post(new InstallFailureEvent(InstallManager.this.resourceBundle.getString(message)));
            }
        }));
    }
}

