/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.business.common.entities;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class Node
implements Comparable {
    protected long id;
    protected String ipAddress;
    protected String number;
    protected String name;
    protected String description;
    protected int status;
    protected String lastSync;
    protected String lastCheck;
    protected String lastSalesMerge;
    protected int modelId;
    protected String modelName;
    protected String modelImage;
    protected String lot;
    protected String maceth;
    protected String macwifi;

    protected Node() {
    }

    protected Node(Node node) {
        try {
            this.setId(node.getId());
            this.setIpAddress(node.getIpAddress());
            this.setNumber(node.getNumber());
            this.setName(node.getName());
            this.setDescription(node.getDescription());
            this.setStatus(node.getStatus());
            this.setLastCheck(node.getLastCheck());
            this.setLastSync(node.getLastSync());
            this.setLastSalesMerge(node.getLastSalesMerge());
            this.setModelId(node.getModelId());
            this.setModelName(node.getModelName());
            this.setModelImage(node.getModelImage());
            this.setVersion(node.getVersion());
            this.setMACEth(node.getMACEth());
            this.setMACWiFi(node.getMACWiFi());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String nodeName) {
        this.name = nodeName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getLastSync() {
        return this.lastSync;
    }

    public void setLastSync(String lastSync) {
        this.lastSync = lastSync;
    }

    public String getLastCheck() {
        return this.lastCheck;
    }

    public void setLastCheck(String lastCheck) {
        this.lastCheck = lastCheck;
    }

    public String getLastSalesMerge() {
        return this.lastSalesMerge;
    }

    public void setLastSalesMerge(String lastSalesMerge) {
        this.lastSalesMerge = lastSalesMerge;
    }

    public int getModelId() {
        return this.modelId;
    }

    public void setModelId(int modelId) {
        this.modelId = modelId;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getModelImage() {
        return this.modelImage;
    }

    public void setModelImage(String modelImage) {
        this.modelImage = modelImage;
    }

    public String getVersion() {
        return this.lot;
    }

    public void setVersion(String lot) {
        this.lot = lot;
    }

    public String getMACEth() {
        return this.maceth;
    }

    public void setMACEth(String MACEth) {
        this.maceth = MACEth;
    }

    public String getMACWiFi() {
        return this.macwifi;
    }

    public void setMACWiFi(String MACWiFi) {
        this.macwifi = MACWiFi;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object o) {
        try {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return this.id == node.id || this.ipAddress.equals(node.ipAddress);
        }
        catch (ClassCastException | NullPointerException ex) {
            return false;
        }
    }

    public int hashCode() {
        return Objects.hash(this.id, this.ipAddress);
    }

    public int compareTo(@NotNull Object o) {
        if (o == null) {
            Node.$$$reportNull$$$0(0);
        }
        try {
            Node node = (Node)o;
            return (int)(this.getId() - node.getId());
        }
        catch (ClassCastException | NullPointerException ex) {
            return 0;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/systel/sync/business/common/entities/Node", "compareTo"));
    }

    public static class Cloner
    implements NodeCloner {
        private Node node;

        public Cloner(Node node) {
            this.node = new Node(node);
        }

        @Override
        public Node clone() {
            return this.node;
        }
    }

    public static class Builder {
        private Node node = new Node();

        public Builder setId(String id) throws NullPointerException, NumberFormatException {
            try {
                this.node.setId(Long.parseLong(id));
            }
            catch (NullPointerException | NumberFormatException runtimeException) {
                // empty catch block
            }
            return this;
        }

        public Builder setId(long id) {
            this.node.setId(id);
            return this;
        }

        public Builder setIpAddress(String ipAddress) {
            this.node.setIpAddress(ipAddress);
            return this;
        }

        public Builder setNumber(String number) {
            this.node.setNumber(number);
            return this;
        }

        public Builder setName(String name) {
            this.node.setName(name);
            return this;
        }

        public Builder setVersion(String lot) {
            this.node.setVersion(lot);
            return this;
        }

        public Builder setMACEth(String MACEth) {
            this.node.setMACEth(MACEth);
            return this;
        }

        public Builder setMACWiFi(String MACWiFi) {
            this.node.setMACWiFi(MACWiFi);
            return this;
        }

        public Builder setDescription(String description) {
            this.node.setDescription(description);
            return this;
        }

        public Builder setModelId(String model) {
            try {
                this.node.setModelId(Integer.valueOf(model));
            }
            catch (NullPointerException | NumberFormatException runtimeException) {
                // empty catch block
            }
            return this;
        }

        public Builder setModelId(int model) {
            this.node.setModelId(model);
            return this;
        }

        public Builder setModelName(String modelName) {
            this.node.setModelName(this.node.toString());
            return this;
        }

        public Builder setModelImage(String modelImage) {
            this.node.setModelImage(modelImage);
            return this;
        }

        public Builder setLastSync(String lastSync) {
            this.node.setLastSync(lastSync);
            return this;
        }

        public Builder setLastCheck(String lastCheck) {
            this.node.setLastCheck(lastCheck);
            return this;
        }

        public Builder setLastSalesMerge(String lastSalesMerge) {
            this.node.setLastSalesMerge(lastSalesMerge);
            return this;
        }

        public Builder setStatus(int status) {
            this.node.setStatus(status);
            return this;
        }

        public Node build() {
            return this.node;
        }
    }

    private static interface NodeCloner {
        public Node clone();
    }
}

