/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync.business;

import com.google.common.eventbus.EventBus;
import com.systel.sync.business.install.InstallInterface;
import com.systel.sync.business.install.InstallManager;
import com.systel.sync.business.language.LanguageInterface;
import com.systel.sync.business.language.LanguageManager;
import com.systel.sync.business.log.LogInterface;
import com.systel.sync.business.log.LogManager;
import com.systel.sync.business.nodes.NodesInterface;
import com.systel.sync.business.nodes.NodesManager;
import com.systel.sync.business.nodes.models.NodeModelsInterface;
import com.systel.sync.business.nodes.models.NodeModelsManager;
import com.systel.sync.business.preferences.PreferencesInterface;
import com.systel.sync.business.preferences.PreferencesManager;
import com.systel.sync.business.salesmerge.SalesMergeInterface;
import com.systel.sync.business.salesmerge.SalesMergeManager;
import com.systel.sync.business.scheduler.SchedulerInterface;
import com.systel.sync.business.scheduler.SchedulerManager;
import com.systel.sync.business.sync.SyncInterface;
import com.systel.sync.business.sync.SyncManager;
import com.systel.sync.business.tools.ToolsInterface;
import com.systel.sync.business.tools.ToolsManager;
import com.systel.sync.business.users.UsersInterface;
import com.systel.sync.business.users.UsersManager;
import com.systel.sync.services.ServicesFacade;
import com.systel.sync.services.common.ConfigurationService;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class BusinessFacade {
    private final EventBus eventBus;
    private final InstallInterface installManager;
    private final LanguageInterface languageManager;
    private final UsersInterface usersManager;
    private final NodesInterface nodesManager;
    private final NodeModelsInterface nodeModelsManager;
    private final SalesMergeInterface salesMergeManager;
    private final SyncInterface syncManager;
    private final SchedulerInterface schedulerManager;
    private final LogInterface logManager;
    private final PreferencesInterface preferencesManager;
    private final ToolsInterface toolsManager;
    private final ExecutorService executor = Executors.newFixedThreadPool(1);

    public BusinessFacade(ConfigurationService configurationService, ServicesFacade serviceManagerFacade, ResourceBundle resourceBundle) {
        this.eventBus = new EventBus();
        this.installManager = new InstallManager(serviceManagerFacade.getInstallService(), this.eventBus, this.executor, resourceBundle);
        this.languageManager = new LanguageManager(serviceManagerFacade.getLanguageService(), this.eventBus, this.executor, resourceBundle);
        this.usersManager = new UsersManager(serviceManagerFacade.getUsersService(), this.eventBus, this.executor, resourceBundle);
        this.nodesManager = new NodesManager(serviceManagerFacade.getNodesLocalService(), serviceManagerFacade.getNodesRemoteService(), this.eventBus, this.executor, resourceBundle, this.usersManager);
        this.nodeModelsManager = new NodeModelsManager(serviceManagerFacade.getNodeModelsService(), this.eventBus, this.executor, resourceBundle);
        this.syncManager = new SyncManager(serviceManagerFacade.getSyncLocalService(), serviceManagerFacade.getSyncRemoteService(), this.eventBus, this.executor, resourceBundle);
        this.salesMergeManager = new SalesMergeManager(serviceManagerFacade.getSalesMergeLocalService(), serviceManagerFacade.getSalesMergeRemoteService(), this.syncManager, this.eventBus, this.executor, resourceBundle);
        this.schedulerManager = new SchedulerManager(serviceManagerFacade.getSchedulerService(), this.syncManager, this.eventBus, this.executor, resourceBundle);
        this.logManager = new LogManager(serviceManagerFacade.getLogService(), this.eventBus, this.executor, resourceBundle);
        this.preferencesManager = new PreferencesManager(serviceManagerFacade.getPreferencesService(), this.eventBus, this.executor, resourceBundle);
        this.toolsManager = new ToolsManager(serviceManagerFacade.getToolsService(), this.eventBus, this.executor, resourceBundle);
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public InstallInterface getInstallManager() {
        return this.installManager;
    }

    public LanguageInterface getLanguageManager() {
        return this.languageManager;
    }

    public UsersInterface getUsersManager() {
        return this.usersManager;
    }

    public NodesInterface getNodesManager() {
        return this.nodesManager;
    }

    public NodeModelsInterface getNodeModelsManager() {
        return this.nodeModelsManager;
    }

    public SalesMergeInterface getSalesMergeManager() {
        return this.salesMergeManager;
    }

    public SyncInterface getSyncManager() {
        return this.syncManager;
    }

    public SchedulerInterface getSchedulerManager() {
        return this.schedulerManager;
    }

    public LogInterface getLogManager() {
        return this.logManager;
    }

    public PreferencesInterface getPreferencesManager() {
        return this.preferencesManager;
    }

    public ToolsInterface getToolsManager() {
        return this.toolsManager;
    }
}

