/*
 * Decompiled with CFR 0.152.
 */
package com.systel.sync;

import com.google.common.eventbus.EventBus;
import com.systel.sync.business.BusinessFacade;
import com.systel.sync.business.install.InstallInterface;
import com.systel.sync.business.language.LanguageInterface;
import com.systel.sync.business.log.LogInterface;
import com.systel.sync.business.nodes.NodesInterface;
import com.systel.sync.business.nodes.models.NodeModelsInterface;
import com.systel.sync.business.preferences.PreferencesInterface;
import com.systel.sync.business.salesmerge.SalesMergeInterface;
import com.systel.sync.business.scheduler.SchedulerInterface;
import com.systel.sync.business.sync.SyncInterface;
import com.systel.sync.business.tools.ToolsInterface;
import com.systel.sync.business.users.UsersInterface;
import com.systel.sync.common.UTF8Control;
import com.systel.sync.common.sql.SQLQueries;
import com.systel.sync.services.ServicesFacade;
import com.systel.sync.services.common.ConfigurationService;
import com.systel.sync.services.common.ConnectionService;
import java.util.Locale;
import java.util.ResourceBundle;

public class Context {
    private ResourceBundle resourceBundle;
    private BusinessFacade businessFacade;
    private ServicesFacade servicesFacade;

    public Context(ConfigurationService configurationService, ConnectionService connectionService) {
        this.resourceBundle = ResourceBundle.getBundle("strings/Lib", new Locale(configurationService.getLanguage(), configurationService.getCountry()), new UTF8Control());
        SQLQueries.getInstance().load("/queries/");
        this.servicesFacade = new ServicesFacade(configurationService, connectionService, this.resourceBundle);
        this.businessFacade = new BusinessFacade(configurationService, this.servicesFacade, this.resourceBundle);
    }

    public EventBus getEventBus() {
        return this.businessFacade.getEventBus();
    }

    public InstallInterface getInstallInterface() {
        return this.businessFacade.getInstallManager();
    }

    public UsersInterface getUsersInterface() {
        return this.businessFacade.getUsersManager();
    }

    public NodesInterface getNodesInterface() {
        return this.businessFacade.getNodesManager();
    }

    public NodeModelsInterface getNodeModelsInterface() {
        return this.businessFacade.getNodeModelsManager();
    }

    public PreferencesInterface getPreferencesInterface() {
        return this.businessFacade.getPreferencesManager();
    }

    public ToolsInterface getToolsInterface() {
        return this.businessFacade.getToolsManager();
    }

    public SalesMergeInterface getSalesMergeInterface() {
        return this.businessFacade.getSalesMergeManager();
    }

    public SyncInterface getSyncInterface() {
        return this.businessFacade.getSyncManager();
    }

    public SchedulerInterface getSchedulerInterface() {
        return this.businessFacade.getSchedulerManager();
    }

    public LanguageInterface getLanguageInterface() {
        return this.businessFacade.getLanguageManager();
    }

    public LogInterface getLogInterface() {
        return this.businessFacade.getLogManager();
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void quit() {
    }
}

