/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.source.doctree.AttributeTree;
import com.sun.source.doctree.DocTree;
import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.DCTree;
import com.sun.tools.javac.tree.DocTreeMaker;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.StringUtils;
import java.text.BreakIterator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DocCommentParser {
    final ParserFactory fac;
    final DiagnosticSource diagSource;
    final Tokens.Comment comment;
    final DocTreeMaker m;
    final Names names;
    BreakIterator sentenceBreaker;
    protected char[] buf;
    protected int bp;
    protected int buflen;
    protected char ch;
    int textStart = -1;
    int lastNonWhite = -1;
    boolean newline = true;
    Map<Name, TagParser> tagParsers;
    Set<String> htmlBlockTags = new HashSet<String>(Arrays.asList("h1", "h2", "h3", "h4", "h5", "h6", "p", "pre"));

    DocCommentParser(ParserFactory fac, DiagnosticSource diagSource, Tokens.Comment comment) {
        this.fac = fac;
        this.diagSource = diagSource;
        this.comment = comment;
        this.names = fac.names;
        this.m = fac.docTreeMaker;
        Locale locale = fac.locale == null ? Locale.getDefault() : fac.locale;
        Options options = fac.options;
        boolean useBreakIterator = options.isSet("breakIterator");
        if (useBreakIterator || !locale.getLanguage().equals(Locale.ENGLISH.getLanguage())) {
            this.sentenceBreaker = BreakIterator.getSentenceInstance(locale);
        }
        this.initTagParsers();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    DCTree.DCDocComment parse() {
        void var2_8;
        DCTree first;
        void var2_3;
        String c = this.comment.getText();
        this.buf = new char[c.length() + 1];
        c.getChars(0, c.length(), this.buf, 0);
        this.buf[this.buf.length - 1] = 26;
        this.buflen = this.buf.length - 1;
        this.bp = -1;
        this.nextChar();
        List<DCTree> list = this.blockContent();
        List<DCTree> tags = this.blockTags();
        ListBuffer<DCTree> fs = new ListBuffer<DCTree>();
        block4: while (var2_3.nonEmpty()) {
            DCTree t = (DCTree)var2_3.head;
            switch (t.getKind()) {
                case TEXT: {
                    int i0;
                    String s2 = ((DCTree.DCText)t).getBody();
                    int i = this.getSentenceBreak(s2);
                    if (i > 0) {
                        int i1;
                        int i02;
                        for (i02 = i; i02 > 0 && this.isWhitespace(s2.charAt(i02 - 1)); --i02) {
                        }
                        fs.add(this.m.at(t.pos).Text(s2.substring(0, i02)));
                        for (i1 = i; i1 < s2.length() && this.isWhitespace(s2.charAt(i1)); ++i1) {
                        }
                        List<DCTree.DCText> list2 = var2_3.tail;
                        if (i1 >= s2.length()) break block4;
                        List<DCTree.DCText> list3 = list2.prepend(this.m.at(t.pos + i1).Text(s2.substring(i1)));
                        break block4;
                    }
                    if (!var2_3.tail.nonEmpty() || !this.isSentenceBreak((DCTree)var2_3.tail.head)) break;
                    for (i0 = s2.length() - 1; i0 > 0 && this.isWhitespace(s2.charAt(i0)); --i0) {
                    }
                    fs.add(this.m.at(t.pos).Text(s2.substring(0, i0 + 1)));
                    List list4 = var2_3.tail;
                    break block4;
                }
                case START_ELEMENT: 
                case END_ELEMENT: {
                    if (this.isSentenceBreak(t)) break block4;
                }
            }
            fs.add(t);
            List list5 = var2_3.tail;
        }
        int pos = (first = (DCTree)this.getFirst(new List[]{fs.toList(), var2_8, tags})) == null ? -1 : first.pos;
        return this.m.at(pos).DocComment(this.comment, fs.toList(), (List<DCTree>)var2_8, tags);
    }

    void nextChar() {
        this.ch = this.buf[this.bp < this.buflen ? (this.bp = this.bp + 1) : this.buflen];
        switch (this.ch) {
            case '\n': 
            case '\f': 
            case '\r': {
                this.newline = true;
            }
        }
    }

    protected List<DCTree> blockContent() {
        ListBuffer<DCTree> trees = new ListBuffer<DCTree>();
        this.textStart = -1;
        block9: while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                }
                case '\t': 
                case ' ': {
                    this.nextChar();
                    continue block9;
                }
                case '&': {
                    this.entity(trees);
                    continue block9;
                }
                case '<': {
                    this.newline = false;
                    this.addPendingText(trees, this.bp - 1);
                    trees.add(this.html());
                    if (this.textStart != -1) continue block9;
                    this.textStart = this.bp;
                    this.lastNonWhite = -1;
                    continue block9;
                }
                case '>': {
                    this.newline = false;
                    this.addPendingText(trees, this.bp - 1);
                    trees.add(this.m.at(this.bp).Erroneous(this.newString(this.bp, this.bp + 1), this.diagSource, "dc.bad.gt", new Object[0]));
                    this.nextChar();
                    if (this.textStart != -1) continue block9;
                    this.textStart = this.bp;
                    this.lastNonWhite = -1;
                    continue block9;
                }
                case '{': {
                    this.inlineTag(trees);
                    continue block9;
                }
                case '@': {
                    if (this.newline) {
                        this.addPendingText(trees, this.lastNonWhite);
                        break block9;
                    }
                }
                default: {
                    this.newline = false;
                    if (this.textStart == -1) {
                        this.textStart = this.bp;
                    }
                    this.lastNonWhite = this.bp;
                    this.nextChar();
                    continue block9;
                }
            }
        }
        if (this.lastNonWhite != -1) {
            this.addPendingText(trees, this.lastNonWhite);
        }
        return trees.toList();
    }

    protected List<DCTree> blockTags() {
        ListBuffer<DCTree> tags = new ListBuffer<DCTree>();
        while (this.ch == '@') {
            tags.add(this.blockTag());
        }
        return tags.toList();
    }

    protected DCTree blockTag() {
        int p = this.bp;
        try {
            this.nextChar();
            if (this.isIdentifierStart(this.ch)) {
                Name name = this.readTagName();
                TagParser tp = this.tagParsers.get(name);
                if (tp == null) {
                    List<DCTree> content = this.blockContent();
                    return this.m.at(p).UnknownBlockTag(name, content);
                }
                switch (tp.getKind()) {
                    case BLOCK: {
                        return tp.parse(p);
                    }
                    case INLINE: {
                        return this.erroneous("dc.bad.inline.tag", p);
                    }
                }
            }
            this.blockContent();
            return this.erroneous("dc.no.tag.name", p);
        }
        catch (ParseException e) {
            this.blockContent();
            return this.erroneous(e.getMessage(), p);
        }
    }

    protected void inlineTag(ListBuffer<DCTree> list) {
        this.newline = false;
        this.nextChar();
        if (this.ch == '@') {
            this.addPendingText(list, this.bp - 2);
            list.add(this.inlineTag());
            this.textStart = this.bp;
            this.lastNonWhite = -1;
        } else {
            if (this.textStart == -1) {
                this.textStart = this.bp - 1;
            }
            this.lastNonWhite = this.bp;
        }
    }

    protected DCTree inlineTag() {
        int p = this.bp - 1;
        try {
            this.nextChar();
            if (this.isIdentifierStart(this.ch)) {
                Name name = this.readTagName();
                this.skipWhitespace();
                TagParser tp = this.tagParsers.get(name);
                if (tp == null) {
                    DCTree text = this.inlineText();
                    if (text != null) {
                        this.nextChar();
                        return this.m.at(p).UnknownInlineTag(name, List.of(text)).setEndPos(this.bp);
                    }
                } else if (tp.getKind() == TagParser.Kind.INLINE) {
                    DCTree.DCEndPosTree tree = (DCTree.DCEndPosTree)tp.parse(p);
                    if (tree != null) {
                        return tree.setEndPos(this.bp);
                    }
                } else {
                    this.inlineText();
                    this.nextChar();
                }
            }
            return this.erroneous("dc.no.tag.name", p);
        }
        catch (ParseException e) {
            return this.erroneous(e.getMessage(), p);
        }
    }

    protected DCTree inlineText() throws ParseException {
        this.skipWhitespace();
        int pos = this.bp;
        int depth = 1;
        block7: while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                    break;
                }
                case '\t': 
                case ' ': {
                    break;
                }
                case '{': {
                    this.newline = false;
                    this.lastNonWhite = this.bp;
                    ++depth;
                    break;
                }
                case '}': {
                    if (--depth == 0) {
                        return this.m.at(pos).Text(this.newString(pos, this.bp));
                    }
                    this.newline = false;
                    this.lastNonWhite = this.bp;
                    break;
                }
                case '@': {
                    if (this.newline) break block7;
                    this.newline = false;
                    this.lastNonWhite = this.bp;
                    break;
                }
                default: {
                    this.newline = false;
                    this.lastNonWhite = this.bp;
                }
            }
            this.nextChar();
        }
        throw new ParseException("dc.unterminated.inline.tag");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DCTree.DCReference reference(boolean allowMember) throws ParseException {
        List<JCTree> paramTypes;
        Name member;
        JCTree qualExpr;
        int pos = this.bp;
        int depth = 0;
        block11: while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                }
                case '\t': 
                case ' ': {
                    if (depth != 0) break;
                    break block11;
                }
                case '(': 
                case '<': {
                    this.newline = false;
                    ++depth;
                    break;
                }
                case ')': 
                case '>': {
                    this.newline = false;
                    --depth;
                    break;
                }
                case '}': {
                    if (this.bp == pos) {
                        return null;
                    }
                    this.newline = false;
                    break block11;
                }
                case '@': {
                    if (this.newline) break block11;
                }
                default: {
                    this.newline = false;
                }
            }
            this.nextChar();
        }
        if (depth != 0) {
            throw new ParseException("dc.unterminated.signature");
        }
        String sig = this.newString(pos, this.bp);
        Log.DeferredDiagnosticHandler deferredDiagnosticHandler = new Log.DeferredDiagnosticHandler(this.fac.log);
        try {
            int hash = sig.indexOf("#");
            int lparen = sig.indexOf("(", hash + 1);
            if (hash == -1) {
                if (lparen == -1) {
                    qualExpr = this.parseType(sig);
                    member = null;
                } else {
                    qualExpr = null;
                    member = this.parseMember(sig.substring(0, lparen));
                }
            } else {
                qualExpr = hash == 0 ? null : this.parseType(sig.substring(0, hash));
                member = lparen == -1 ? this.parseMember(sig.substring(hash + 1)) : this.parseMember(sig.substring(hash + 1, lparen));
            }
            if (lparen < 0) {
                paramTypes = null;
            } else {
                int rparen = sig.indexOf(")", lparen);
                if (rparen != sig.length() - 1) {
                    throw new ParseException("dc.ref.bad.parens");
                }
                paramTypes = this.parseParams(sig.substring(lparen + 1, rparen));
            }
            if (!deferredDiagnosticHandler.getDiagnostics().isEmpty()) {
                throw new ParseException("dc.ref.syntax.error");
            }
        }
        finally {
            this.fac.log.popDiagnosticHandler(deferredDiagnosticHandler);
        }
        return (DCTree.DCReference)this.m.at(pos).Reference(sig, qualExpr, member, paramTypes).setEndPos(this.bp);
    }

    JCTree parseType(String s2) throws ParseException {
        JavacParser p = this.fac.newParser(s2, false, false, false);
        JCTree.JCExpression tree = p.parseType();
        if (p.token().kind != Tokens.TokenKind.EOF) {
            throw new ParseException("dc.ref.unexpected.input");
        }
        return tree;
    }

    Name parseMember(String s2) throws ParseException {
        JavacParser p = this.fac.newParser(s2, false, false, false);
        Name name = p.ident();
        if (p.token().kind != Tokens.TokenKind.EOF) {
            throw new ParseException("dc.ref.unexpected.input");
        }
        return name;
    }

    List<JCTree> parseParams(String s2) throws ParseException {
        if (s2.trim().isEmpty()) {
            return List.nil();
        }
        JavacParser p = this.fac.newParser(s2.replace("...", "[]"), false, false, false);
        ListBuffer<JCTree.JCExpression> paramTypes = new ListBuffer<JCTree.JCExpression>();
        paramTypes.add(p.parseType());
        if (p.token().kind == Tokens.TokenKind.IDENTIFIER) {
            p.nextToken();
        }
        while (p.token().kind == Tokens.TokenKind.COMMA) {
            p.nextToken();
            paramTypes.add(p.parseType());
            if (p.token().kind != Tokens.TokenKind.IDENTIFIER) continue;
            p.nextToken();
        }
        if (p.token().kind != Tokens.TokenKind.EOF) {
            throw new ParseException("dc.ref.unexpected.input");
        }
        return paramTypes.toList();
    }

    protected DCTree.DCIdentifier identifier() throws ParseException {
        this.skipWhitespace();
        int pos = this.bp;
        if (this.isJavaIdentifierStart(this.ch)) {
            Name name = this.readJavaIdentifier();
            return this.m.at(pos).Identifier(name);
        }
        throw new ParseException("dc.identifier.expected");
    }

    /*
     * Enabled aggressive block sorting
     */
    protected DCTree.DCText quotedString() {
        int pos = this.bp;
        this.nextChar();
        while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                    break;
                }
                case '\t': 
                case ' ': {
                    break;
                }
                case '\"': {
                    this.nextChar();
                    return this.m.at(pos).Text(this.newString(pos, this.bp));
                }
                case '@': {
                    if (!this.newline) break;
                    return null;
                }
            }
            this.nextChar();
        }
        return null;
    }

    protected List<DCTree> inlineContent() {
        ListBuffer<DCTree> trees = new ListBuffer<DCTree>();
        this.skipWhitespace();
        int pos = this.bp;
        int depth = 1;
        this.textStart = -1;
        block9: while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                }
                case '\t': 
                case ' ': {
                    this.nextChar();
                    continue block9;
                }
                case '&': {
                    this.entity(trees);
                    continue block9;
                }
                case '<': {
                    this.newline = false;
                    this.addPendingText(trees, this.bp - 1);
                    trees.add(this.html());
                    continue block9;
                }
                case '{': {
                    this.newline = false;
                    ++depth;
                    this.nextChar();
                    continue block9;
                }
                case '}': {
                    this.newline = false;
                    if (--depth == 0) {
                        this.addPendingText(trees, this.bp - 1);
                        this.nextChar();
                        return trees.toList();
                    }
                    this.nextChar();
                    continue block9;
                }
                case '@': {
                    if (this.newline) break block9;
                }
                default: {
                    if (this.textStart == -1) {
                        this.textStart = this.bp;
                    }
                    this.nextChar();
                    continue block9;
                }
            }
        }
        return List.of(this.erroneous("dc.unterminated.inline.tag", pos));
    }

    protected void entity(ListBuffer<DCTree> list) {
        this.newline = false;
        this.addPendingText(list, this.bp - 1);
        list.add(this.entity());
        if (this.textStart == -1) {
            this.textStart = this.bp;
            this.lastNonWhite = -1;
        }
    }

    protected DCTree entity() {
        int p = this.bp;
        this.nextChar();
        Name name = null;
        boolean checkSemi = false;
        if (this.ch == '#') {
            int namep = this.bp;
            this.nextChar();
            if (this.isDecimalDigit(this.ch)) {
                this.nextChar();
                while (this.isDecimalDigit(this.ch)) {
                    this.nextChar();
                }
                name = this.names.fromChars(this.buf, namep, this.bp - namep);
            } else if (this.ch == 'x' || this.ch == 'X') {
                this.nextChar();
                if (this.isHexDigit(this.ch)) {
                    this.nextChar();
                    while (this.isHexDigit(this.ch)) {
                        this.nextChar();
                    }
                    name = this.names.fromChars(this.buf, namep, this.bp - namep);
                }
            }
        } else if (this.isIdentifierStart(this.ch)) {
            name = this.readIdentifier();
        }
        if (name == null) {
            return this.erroneous("dc.bad.entity", p);
        }
        if (this.ch != ';') {
            return this.erroneous("dc.missing.semicolon", p);
        }
        this.nextChar();
        return this.m.at(p).Entity(name);
    }

    protected DCTree html() {
        int p = this.bp;
        this.nextChar();
        if (this.isIdentifierStart(this.ch)) {
            Name name = this.readIdentifier();
            List<DCTree> attrs = this.htmlAttrs();
            if (attrs != null) {
                boolean selfClosing = false;
                if (this.ch == '/') {
                    this.nextChar();
                    selfClosing = true;
                }
                if (this.ch == '>') {
                    this.nextChar();
                    return this.m.at(p).StartElement(name, attrs, selfClosing).setEndPos(this.bp);
                }
            }
        } else if (this.ch == '/') {
            this.nextChar();
            if (this.isIdentifierStart(this.ch)) {
                Name name = this.readIdentifier();
                this.skipWhitespace();
                if (this.ch == '>') {
                    this.nextChar();
                    return this.m.at(p).EndElement(name);
                }
            }
        } else if (this.ch == '!') {
            this.nextChar();
            if (this.ch == '-') {
                this.nextChar();
                if (this.ch == '-') {
                    this.nextChar();
                    while (this.bp < this.buflen) {
                        int dash = 0;
                        while (this.ch == '-') {
                            ++dash;
                            this.nextChar();
                        }
                        if (dash >= 2 && this.ch == '>') {
                            this.nextChar();
                            return this.m.at(p).Comment(this.newString(p, this.bp));
                        }
                        this.nextChar();
                    }
                }
            }
        }
        this.bp = p + 1;
        this.ch = this.buf[this.bp];
        return this.erroneous("dc.malformed.html", p);
    }

    protected List<DCTree> htmlAttrs() {
        ListBuffer<DCTree> attrs = new ListBuffer<DCTree>();
        this.skipWhitespace();
        block0: while (this.isIdentifierStart(this.ch)) {
            int namePos = this.bp;
            Name name = this.readIdentifier();
            this.skipWhitespace();
            List<DCTree> value = null;
            AttributeTree.ValueKind vkind = AttributeTree.ValueKind.EMPTY;
            if (this.ch == '=') {
                ListBuffer<DCTree> v = new ListBuffer<DCTree>();
                this.nextChar();
                this.skipWhitespace();
                if (this.ch == '\'' || this.ch == '\"') {
                    vkind = this.ch == '\'' ? AttributeTree.ValueKind.SINGLE : AttributeTree.ValueKind.DOUBLE;
                    char quote = this.ch;
                    this.nextChar();
                    this.textStart = this.bp;
                    while (this.bp < this.buflen && this.ch != quote) {
                        if (this.newline && this.ch == '@') {
                            attrs.add(this.erroneous("dc.unterminated.string", namePos));
                            break block0;
                        }
                        this.attrValueChar(v);
                    }
                    this.addPendingText(v, this.bp - 1);
                    this.nextChar();
                } else {
                    vkind = AttributeTree.ValueKind.UNQUOTED;
                    this.textStart = this.bp;
                    while (this.bp < this.buflen && !this.isUnquotedAttrValueTerminator(this.ch)) {
                        this.attrValueChar(v);
                    }
                    this.addPendingText(v, this.bp - 1);
                }
                this.skipWhitespace();
                value = v.toList();
            }
            DCTree.DCAttribute attr = this.m.at(namePos).Attribute(name, vkind, value);
            attrs.add(attr);
        }
        return attrs.toList();
    }

    protected void attrValueChar(ListBuffer<DCTree> list) {
        switch (this.ch) {
            case '&': {
                this.entity(list);
                break;
            }
            case '{': {
                this.inlineTag(list);
                break;
            }
            default: {
                this.nextChar();
            }
        }
    }

    protected void addPendingText(ListBuffer<DCTree> list, int textEnd) {
        if (this.textStart != -1) {
            if (this.textStart <= textEnd) {
                list.add(this.m.at(this.textStart).Text(this.newString(this.textStart, textEnd + 1)));
            }
            this.textStart = -1;
        }
    }

    protected DCTree.DCErroneous erroneous(String code, int pos) {
        int i;
        block4: for (i = this.bp - 1; i > pos; --i) {
            switch (this.buf[i]) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                    continue block4;
                }
                case '\t': 
                case ' ': {
                    continue block4;
                }
            }
        }
        this.textStart = -1;
        return this.m.at(pos).Erroneous(this.newString(pos, i + 1), this.diagSource, code, new Object[0]);
    }

    <T> T getFirst(List<T> ... lists) {
        for (List<T> list : lists) {
            if (!list.nonEmpty()) continue;
            return (T)list.head;
        }
        return null;
    }

    protected boolean isIdentifierStart(char ch) {
        return Character.isUnicodeIdentifierStart(ch);
    }

    protected Name readIdentifier() {
        int start = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && Character.isUnicodeIdentifierPart(this.ch)) {
            this.nextChar();
        }
        return this.names.fromChars(this.buf, start, this.bp - start);
    }

    protected Name readTagName() {
        int start = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && (Character.isUnicodeIdentifierPart(this.ch) || this.ch == '.')) {
            this.nextChar();
        }
        return this.names.fromChars(this.buf, start, this.bp - start);
    }

    protected boolean isJavaIdentifierStart(char ch) {
        return Character.isJavaIdentifierStart(ch);
    }

    protected Name readJavaIdentifier() {
        int start = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && Character.isJavaIdentifierPart(this.ch)) {
            this.nextChar();
        }
        return this.names.fromChars(this.buf, start, this.bp - start);
    }

    protected boolean isDecimalDigit(char ch) {
        return '0' <= ch && ch <= '9';
    }

    protected boolean isHexDigit(char ch) {
        return '0' <= ch && ch <= '9' || 'a' <= ch && ch <= 'f' || 'A' <= ch && ch <= 'F';
    }

    protected boolean isUnquotedAttrValueTerminator(char ch) {
        switch (ch) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': 
            case '\"': 
            case '\'': 
            case '<': 
            case '=': 
            case '>': 
            case '`': {
                return true;
            }
        }
        return false;
    }

    protected boolean isWhitespace(char ch) {
        return Character.isWhitespace(ch);
    }

    protected void skipWhitespace() {
        while (this.isWhitespace(this.ch)) {
            this.nextChar();
        }
    }

    protected int getSentenceBreak(String s2) {
        if (this.sentenceBreaker != null) {
            this.sentenceBreaker.setText(s2);
            int i = this.sentenceBreaker.next();
            return i == s2.length() ? -1 : i;
        }
        boolean period = false;
        block4: for (int i = 0; i < s2.length(); ++i) {
            switch (s2.charAt(i)) {
                case '.': {
                    period = true;
                    continue block4;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (!period) continue block4;
                    return i;
                }
                default: {
                    period = false;
                }
            }
        }
        return -1;
    }

    protected boolean isSentenceBreak(Name n) {
        return this.htmlBlockTags.contains(StringUtils.toLowerCase(n.toString()));
    }

    protected boolean isSentenceBreak(DCTree t) {
        switch (t.getKind()) {
            case START_ELEMENT: {
                return this.isSentenceBreak(((DCTree.DCStartElement)t).getName());
            }
            case END_ELEMENT: {
                return this.isSentenceBreak(((DCTree.DCEndElement)t).getName());
            }
        }
        return false;
    }

    String newString(int start, int end) {
        return new String(this.buf, start, end - start);
    }

    private void initTagParsers() {
        TagParser[] parsers = new TagParser[]{new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.AUTHOR){

            @Override
            public DCTree parse(int pos) {
                List<DCTree> name = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).Author(name);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.CODE){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DCTree text = DocCommentParser.this.inlineText();
                DocCommentParser.this.nextChar();
                return DocCommentParser.this.m.at(pos).Code((DCTree.DCText)text);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.DEPRECATED){

            @Override
            public DCTree parse(int pos) {
                List<DCTree> reason = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).Deprecated(reason);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.DOC_ROOT){

            @Override
            public DCTree parse(int pos) throws ParseException {
                if (DocCommentParser.this.ch == '}') {
                    DocCommentParser.this.nextChar();
                    return DocCommentParser.this.m.at(pos).DocRoot();
                }
                DocCommentParser.this.inlineText();
                DocCommentParser.this.nextChar();
                throw new ParseException("dc.unexpected.content");
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.EXCEPTION){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                DCTree.DCReference ref = DocCommentParser.this.reference(false);
                List<DCTree> description = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).Exception(ref, description);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.INHERIT_DOC){

            @Override
            public DCTree parse(int pos) throws ParseException {
                if (DocCommentParser.this.ch == '}') {
                    DocCommentParser.this.nextChar();
                    return DocCommentParser.this.m.at(pos).InheritDoc();
                }
                DocCommentParser.this.inlineText();
                DocCommentParser.this.nextChar();
                throw new ParseException("dc.unexpected.content");
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.LINK){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DCTree.DCReference ref = DocCommentParser.this.reference(true);
                List<DCTree> label = DocCommentParser.this.inlineContent();
                return DocCommentParser.this.m.at(pos).Link(ref, label);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.LINK_PLAIN){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DCTree.DCReference ref = DocCommentParser.this.reference(true);
                List<DCTree> label = DocCommentParser.this.inlineContent();
                return DocCommentParser.this.m.at(pos).LinkPlain(ref, label);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.LITERAL){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DCTree text = DocCommentParser.this.inlineText();
                DocCommentParser.this.nextChar();
                return DocCommentParser.this.m.at(pos).Literal((DCTree.DCText)text);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.PARAM){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                boolean typaram = false;
                if (DocCommentParser.this.ch == '<') {
                    typaram = true;
                    DocCommentParser.this.nextChar();
                }
                DCTree.DCIdentifier id = DocCommentParser.this.identifier();
                if (typaram) {
                    if (DocCommentParser.this.ch != '>') {
                        throw new ParseException("dc.gt.expected");
                    }
                    DocCommentParser.this.nextChar();
                }
                DocCommentParser.this.skipWhitespace();
                List<DCTree> desc = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).Param(typaram, id, desc);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.RETURN){

            @Override
            public DCTree parse(int pos) {
                List<DCTree> description = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).Return(description);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SEE){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                switch (DocCommentParser.this.ch) {
                    case '\"': {
                        DCTree.DCText string = DocCommentParser.this.quotedString();
                        if (string == null) break;
                        DocCommentParser.this.skipWhitespace();
                        if (DocCommentParser.this.ch != '@' && (DocCommentParser.this.ch != '\u001a' || DocCommentParser.this.bp != DocCommentParser.this.buf.length - 1)) break;
                        return DocCommentParser.this.m.at(pos).See(List.of(string));
                    }
                    case '<': {
                        List<DCTree> html = DocCommentParser.this.blockContent();
                        if (html == null) break;
                        return DocCommentParser.this.m.at(pos).See(html);
                    }
                    case '@': {
                        if (!DocCommentParser.this.newline) break;
                        throw new ParseException("dc.no.content");
                    }
                    case '\u001a': {
                        if (DocCommentParser.this.bp != DocCommentParser.this.buf.length - 1) break;
                        throw new ParseException("dc.no.content");
                    }
                    default: {
                        if (!DocCommentParser.this.isJavaIdentifierStart(DocCommentParser.this.ch) && DocCommentParser.this.ch != '#') break;
                        DCTree.DCReference ref = DocCommentParser.this.reference(true);
                        List<DCTree> description = DocCommentParser.this.blockContent();
                        return DocCommentParser.this.m.at(pos).See(description.prepend(ref));
                    }
                }
                throw new ParseException("dc.unexpected.content");
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SERIAL_DATA){

            @Override
            public DCTree parse(int pos) {
                List<DCTree> description = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).SerialData(description);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SERIAL_FIELD){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                DCTree.DCIdentifier name = DocCommentParser.this.identifier();
                DocCommentParser.this.skipWhitespace();
                DCTree.DCReference type = DocCommentParser.this.reference(false);
                List<DCTree> description = null;
                if (DocCommentParser.this.isWhitespace(DocCommentParser.this.ch)) {
                    DocCommentParser.this.skipWhitespace();
                    description = DocCommentParser.this.blockContent();
                }
                return DocCommentParser.this.m.at(pos).SerialField(name, type, description);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SERIAL){

            @Override
            public DCTree parse(int pos) {
                List<DCTree> description = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).Serial(description);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SINCE){

            @Override
            public DCTree parse(int pos) {
                List<DCTree> description = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).Since(description);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.THROWS){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                DCTree.DCReference ref = DocCommentParser.this.reference(false);
                List<DCTree> description = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).Throws(ref, description);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.VALUE){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DCTree.DCReference ref = DocCommentParser.this.reference(true);
                DocCommentParser.this.skipWhitespace();
                if (DocCommentParser.this.ch == '}') {
                    DocCommentParser.this.nextChar();
                    return DocCommentParser.this.m.at(pos).Value(ref);
                }
                DocCommentParser.this.nextChar();
                throw new ParseException("dc.unexpected.content");
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.VERSION){

            @Override
            public DCTree parse(int pos) {
                List<DCTree> description = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).Version(description);
            }
        }};
        this.tagParsers = new HashMap<Name, TagParser>();
        for (TagParser p : parsers) {
            this.tagParsers.put(this.names.fromString(p.getTreeKind().tagName), p);
        }
    }

    static abstract class TagParser {
        Kind kind;
        DocTree.Kind treeKind;

        TagParser(Kind k, DocTree.Kind tk) {
            this.kind = k;
            this.treeKind = tk;
        }

        Kind getKind() {
            return this.kind;
        }

        DocTree.Kind getTreeKind() {
            return this.treeKind;
        }

        abstract DCTree parse(int var1) throws ParseException;

        static enum Kind {
            INLINE,
            BLOCK;

        }
    }

    static class ParseException
    extends Exception {
        private static final long serialVersionUID = 0L;

        ParseException(String key) {
            super(key);
        }
    }
}

