/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criteria;
import annotator.find.Insertion;
import java.util.List;
import type.ArrayType;
import type.BoundedType;
import type.DeclaredType;
import type.Type;

public abstract class TypedInsertion
extends Insertion {
    protected Type type;
    protected boolean annotationsOnly;
    protected List<Insertion> innerTypeInsertions;

    public TypedInsertion(Type type, Criteria criteria, List<Insertion> innerTypeInsertions) {
        this(type, criteria, false, innerTypeInsertions);
    }

    public TypedInsertion(Type type, Criteria criteria, boolean b, List<Insertion> innerTypeInsertions) {
        super(criteria, b);
        this.type = type;
        this.innerTypeInsertions = innerTypeInsertions;
        this.annotationsOnly = false;
    }

    public void setAnnotationsOnly(boolean annotationsOnly) {
        this.annotationsOnly = annotationsOnly;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public List<Insertion> getInnerTypeInsertions() {
        return this.innerTypeInsertions;
    }

    public DeclaredType getBaseType() {
        return TypedInsertion.getBaseType(this.type);
    }

    public static DeclaredType getBaseType(Type type) {
        switch (type.getKind()) {
            case DECLARED: {
                return (DeclaredType)type;
            }
            case BOUNDED: {
                return TypedInsertion.getBaseType(((BoundedType)type).getName());
            }
            case ARRAY: {
                return TypedInsertion.getBaseType(((ArrayType)type).getComponentType());
            }
        }
        return null;
    }
}

