/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.Main;
import annotator.find.Criteria;
import annotator.find.Criterion;
import annotator.scanner.CommonScanner;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;

public class ReturnTypeCriterion
implements Criterion {
    private final String methodName;
    private final Criterion inClassCriterion;
    private final Criterion sigMethodCriterion;

    public ReturnTypeCriterion(String className, String methodName) {
        this.methodName = methodName;
        this.inClassCriterion = Criteria.inClass(className, false);
        this.sigMethodCriterion = methodName.isEmpty() ? null : Criteria.isSigMethod(methodName);
    }

    @Override
    public boolean isSatisfiedBy(TreePath path, Tree leaf) {
        assert (path == null || path.getLeaf() == leaf);
        return this.isSatisfiedBy(path);
    }

    @Override
    public boolean isSatisfiedBy(TreePath path) {
        if (path == null) {
            return false;
        }
        Criteria.dbug.debug("ReturnTypeCriterion.isSatisfiedBy(%s); this=%n", Main.pathToString(path), this.toString());
        block0: do {
            if (path.getLeaf().getKind() != Tree.Kind.METHOD) continue;
            if (this.sigMethodCriterion != null && !this.sigMethodCriterion.isSatisfiedBy(path)) break;
            for (path = path.getParentPath(); path != null && path.getLeaf() != null; path = path.getParentPath()) {
                if (!CommonScanner.hasClassKind(path.getLeaf())) continue;
                if (!this.inClassCriterion.isSatisfiedBy(path)) break block0;
                Criteria.dbug.debug("ReturnTypeCriterion.isSatisfiedBy => true%n", new Object[0]);
                return true;
            }
            break;
        } while ((path = path.getParentPath()) != null && path.getLeaf() != null);
        Criteria.dbug.debug("ReturnTypeCriterion.isSatisfiedBy => false%n", new Object[0]);
        return false;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.RETURN_TYPE;
    }

    public String toString() {
        return "ReturnTypeCriterion for method: " + this.methodName;
    }
}

