/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criteria;
import annotator.find.Insertion;
import annotator.find.ReceiverInsertion;
import annotator.find.TypedInsertion;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import type.Type;

public class ConstructorInsertion
extends TypedInsertion {
    private ReceiverInsertion receiverInsertion = null;
    private Set<Insertion> declarationInsertions = new LinkedHashSet<Insertion>();

    public ConstructorInsertion(Type type, Criteria criteria, List<Insertion> innerTypeInsertions) {
        super(type, criteria, true, innerTypeInsertions);
    }

    @Override
    protected String getText(boolean comments, boolean abbreviate) {
        StringBuilder b = new StringBuilder();
        if (this.annotationsOnly) {
            return "";
        }
        boolean commentAnnotation = comments && this.getBaseType().getName().isEmpty();
        String typeString = this.typeToString(this.type, commentAnnotation, true);
        int ix = typeString.lastIndexOf(36);
        typeString = typeString.substring(ix + 1);
        for (Insertion i : this.declarationInsertions) {
            b.append(i.getText(commentAnnotation, abbreviate)).append("\n");
            if (!abbreviate) continue;
            this.packageNames.addAll(i.getPackageNames());
        }
        b.append("public ").append(typeString).append("(");
        if (this.receiverInsertion != null && !this.receiverInsertion.getInserted()) {
            b.append(this.receiverInsertion.getText(comments, abbreviate));
        }
        b.append(") { super(); }");
        return b.toString();
    }

    protected ReceiverInsertion getReceiverInsertion() {
        return this.receiverInsertion;
    }

    public void addReceiverInsertion(ReceiverInsertion recv) {
        if (this.receiverInsertion == null) {
            this.receiverInsertion = recv;
        } else {
            this.receiverInsertion.getInnerTypeInsertions().addAll(recv.getInnerTypeInsertions());
        }
    }

    public void addDeclarationInsertion(Insertion ins) {
        this.declarationInsertions.add(ins);
        ins.setInserted(true);
    }

    @Override
    protected boolean addLeadingSpace(boolean gotSeparateLine, int pos, char precedingChar) {
        return false;
    }

    @Override
    protected boolean addTrailingSpace(boolean gotSeparateLine) {
        return false;
    }

    @Override
    public Insertion.Kind getKind() {
        return Insertion.Kind.CONSTRUCTOR;
    }
}

