/*
 * Decompiled with CFR 0.152.
 */
package annotations.io.classfile;

import annotations.Annotation;
import annotations.el.AClass;
import annotations.el.AElement;
import annotations.el.AField;
import annotations.el.AMethod;
import annotations.el.AScene;
import annotations.el.ATypeElement;
import annotations.el.BoundLocation;
import annotations.el.InnerTypeLocation;
import annotations.el.LocalLocation;
import annotations.el.RelativeLocation;
import annotations.el.TypeIndexLocation;
import annotations.field.AnnotationFieldType;
import annotations.field.ArrayAFT;
import annotations.field.ClassTokenAFT;
import annotations.field.EnumAFT;
import annotations.io.classfile.MethodCodeOffsetAdapter;
import annotations.io.classfile.SafeTypeAnnotationVisitor;
import com.sun.tools.javac.code.TargetType;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypeAnnotationVisitor;
import org.objectweb.asm.commons.EmptyVisitor;

public class ClassAnnotationSceneWriter
extends ClassAdapter {
    private static final boolean strict = false;
    private final AScene scene;
    private AClass aClass;
    private final List<String> existingClassAnnotations;
    private boolean hasVisitedClassAnnotationsInScene;
    private final boolean overwrite;
    private final Map<String, Set<Integer>> dynamicConstructors;
    private final Map<String, Set<Integer>> lambdaExpressions;
    private ClassReader cr = null;

    public ClassAnnotationSceneWriter(ClassReader cr, AScene scene, boolean overwrite) {
        super(new ClassWriter(cr, false));
        this.scene = scene;
        this.hasVisitedClassAnnotationsInScene = false;
        this.aClass = null;
        this.existingClassAnnotations = new ArrayList<String>();
        this.overwrite = overwrite;
        this.dynamicConstructors = new HashMap<String, Set<Integer>>();
        this.lambdaExpressions = new HashMap<String, Set<Integer>>();
        this.cr = cr;
    }

    public byte[] toByteArray() {
        return ((ClassWriter)this.cv).toByteArray();
    }

    @Override
    public void visit(int version2, int access, String name, String signature, String superName, String[] interfaces) {
        this.cr.accept(new MethodCodeIndexer(), false);
        super.visit(version2, access, name, signature, superName, interfaces);
        name = name.replace('/', '.');
        this.aClass = this.scene.classes.vivify(name);
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.ensureVisitSceneClassAnnotations();
        super.visitInnerClass(name, outerName, innerName, access);
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        this.ensureVisitSceneClassAnnotations();
        return new FieldAnnotationSceneWriter(name, super.visitField(access, name, desc, signature, value));
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        this.ensureVisitSceneClassAnnotations();
        return new MethodAdapter(new MethodAnnotationSceneWriter(name, desc, super.visitMethod(access, name, desc, signature, exceptions)));
    }

    @Override
    public void visitEnd() {
        this.ensureVisitSceneClassAnnotations();
        super.visitEnd();
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.existingClassAnnotations.add(desc);
        if (this.aClass.lookup(ClassAnnotationSceneWriter.classDescToName(desc)) != null && this.overwrite) {
            return new EmptyVisitor();
        }
        return super.visitAnnotation(desc, visible);
    }

    @Override
    public TypeAnnotationVisitor visitTypeAnnotation(String desc, boolean visible, boolean inCode) {
        this.existingClassAnnotations.add(desc);
        if (this.aClass.lookup(ClassAnnotationSceneWriter.classDescToName(desc)) != null && this.overwrite) {
            return new EmptyVisitor();
        }
        return new SafeTypeAnnotationVisitor(super.visitTypeAnnotation(desc, visible, inCode));
    }

    private void ensureVisitSceneClassAnnotations() {
        if (!this.hasVisitedClassAnnotationsInScene) {
            this.hasVisitedClassAnnotationsInScene = true;
            for (Annotation annotation : this.aClass.tlAnnotationsHere) {
                if (!this.overwrite && this.existingClassAnnotations.contains(ClassAnnotationSceneWriter.name(annotation))) continue;
                AnnotationVisitor av = this.visitAnnotation(annotation);
                this.visitFields(av, annotation);
                av.visitEnd();
            }
            for (Map.Entry entry : this.aClass.bounds.entrySet()) {
                BoundLocation bloc = (BoundLocation)entry.getKey();
                ATypeElement bound = (ATypeElement)entry.getValue();
                for (Annotation annotation : bound.tlAnnotationsHere) {
                    TypeAnnotationVisitor xav = this.visitTypeAnnotation(annotation);
                    if (bloc.boundIndex == -1) {
                        this.visitTargetType(xav, TargetType.CLASS_TYPE_PARAMETER);
                        this.visitBound(xav, bloc);
                    } else {
                        this.visitTargetType(xav, TargetType.CLASS_TYPE_PARAMETER_BOUND);
                        this.visitBound(xav, bloc);
                    }
                    this.visitLocations(xav, InnerTypeLocation.EMPTY_INNER_TYPE_LOCATION);
                    this.visitFields(xav, annotation);
                    xav.visitEnd();
                }
                for (Map.Entry entry2 : bound.innerTypes.entrySet()) {
                    InnerTypeLocation itloc = (InnerTypeLocation)entry2.getKey();
                    ATypeElement innerType = (ATypeElement)entry2.getValue();
                    for (Annotation tla : innerType.tlAnnotationsHere) {
                        TypeAnnotationVisitor xav = this.visitTypeAnnotation(tla);
                        this.visitTargetType(xav, TargetType.CLASS_TYPE_PARAMETER_BOUND);
                        this.visitBound(xav, bloc);
                        this.visitLocations(xav, itloc);
                        this.visitFields(xav, tla);
                        xav.visitEnd();
                    }
                }
            }
            for (Map.Entry entry : this.aClass.extendsImplements.entrySet()) {
                TypeIndexLocation idx = (TypeIndexLocation)entry.getKey();
                ATypeElement aTypeElement = (ATypeElement)entry.getValue();
            }
        }
    }

    private static boolean isRuntimeRetention(Annotation tla) {
        if (tla.def.retention() == null) {
            return false;
        }
        return tla.def.retention().equals((Object)RetentionPolicy.RUNTIME);
    }

    private static String name(Annotation tla) {
        return tla.def().name;
    }

    private static String classNameToDesc(String name) {
        return "L" + name.replace('.', '/') + ";";
    }

    private static String classDescToName(String desc) {
        return desc.substring(1, desc.length() - 1).replace('/', '.');
    }

    private AnnotationVisitor visitAnnotation(Annotation tla) {
        return super.visitAnnotation(ClassAnnotationSceneWriter.classNameToDesc(ClassAnnotationSceneWriter.name(tla)), ClassAnnotationSceneWriter.isRuntimeRetention(tla));
    }

    private TypeAnnotationVisitor visitTypeAnnotation(Annotation tla) {
        return super.visitTypeAnnotation(ClassAnnotationSceneWriter.classNameToDesc(ClassAnnotationSceneWriter.name(tla)), ClassAnnotationSceneWriter.isRuntimeRetention(tla), false);
    }

    private void visitFields(TypeAnnotationVisitor tav, Annotation a) {
        tav.visitXNameAndArgsSize();
        this.visitFields((AnnotationVisitor)tav, a);
    }

    private void visitFields(AnnotationVisitor av, Annotation a) {
        for (String fieldName : a.def().fieldTypes.keySet()) {
            Object value = a.getFieldValue(fieldName);
            if (value == null) continue;
            AnnotationFieldType aft = a.def().fieldTypes.get(fieldName);
            if (value instanceof Annotation) {
                AnnotationVisitor nav = av.visitAnnotation(fieldName, ClassAnnotationSceneWriter.classDescToName(a.def().name));
                this.visitFields(nav, a);
                nav.visitEnd();
                continue;
            }
            if (value instanceof List) {
                AnnotationVisitor aav = av.visitArray(fieldName);
                aft = ((ArrayAFT)aft).elementType;
                for (Object o : (List)value) {
                    if (aft instanceof EnumAFT) {
                        aav.visitEnum(null, ((EnumAFT)aft).typeName, o.toString());
                        continue;
                    }
                    aav.visit(null, o);
                }
                aav.visitEnd();
                continue;
            }
            if (aft instanceof EnumAFT) {
                av.visitEnum(fieldName, ((EnumAFT)aft).typeName, value.toString());
                continue;
            }
            if (aft instanceof ClassTokenAFT) {
                av.visit(fieldName, Type.getType((Class)value));
                continue;
            }
            av.visit(fieldName, value);
        }
    }

    private void visitTargetType(TypeAnnotationVisitor xav, TargetType t) {
        xav.visitXTargetType(t.targetTypeValue());
    }

    private void visitLocations(TypeAnnotationVisitor xav, InnerTypeLocation loc) {
        List<TypeAnnotationPosition.TypePathEntry> location = loc.location;
        xav.visitXLocationLength(location.size());
        for (TypeAnnotationPosition.TypePathEntry l : location) {
            xav.visitXLocation(l);
        }
    }

    private void visitLocalVar(TypeAnnotationVisitor xav, LocalLocation loc) {
        xav.visitXNumEntries(1);
        xav.visitXStartPc(loc.scopeStart);
        xav.visitXLength(loc.scopeLength);
        xav.visitXIndex(loc.index);
    }

    private void visitOffset(TypeAnnotationVisitor xav, int offset) {
        xav.visitXOffset(offset);
    }

    private void visitParameterIndex(TypeAnnotationVisitor xav, int index) {
        xav.visitXParamIndex(index);
    }

    private void visitTypeIndex(TypeAnnotationVisitor xav, int index) {
        xav.visitXTypeIndex(index);
    }

    private void visitBound(TypeAnnotationVisitor xav, BoundLocation loc) {
        xav.visitXParamIndex(loc.paramIndex);
        if (loc.boundIndex != -1) {
            xav.visitXBoundIndex(loc.boundIndex);
        }
    }

    class MethodCodeIndexer
    extends EmptyVisitor {
        private int codeStart = 0;
        Set<Integer> constrs;
        Set<Integer> lambdas;

        MethodCodeIndexer() {
            this.codeStart = ((ClassAnnotationSceneWriter)ClassAnnotationSceneWriter.this).cr.header + 6;
            this.codeStart += 2 + 2 * ClassAnnotationSceneWriter.this.cr.readUnsignedShort(this.codeStart);
            int fieldCount = ClassAnnotationSceneWriter.this.cr.readUnsignedShort(this.codeStart);
            this.codeStart += 2;
            while (--fieldCount >= 0) {
                int attrCount = ClassAnnotationSceneWriter.this.cr.readUnsignedShort(this.codeStart + 6);
                this.codeStart += 8;
                while (--attrCount >= 0) {
                    this.codeStart += 6 + ClassAnnotationSceneWriter.this.cr.readInt(this.codeStart + 2);
                }
            }
            this.codeStart += 2;
        }

        @Override
        public void visit(int version2, int access, String name, String signature, String superName, String[] interfaces) {
        }

        @Override
        public void visitSource(String source, String debug) {
        }

        @Override
        public void visitOuterClass(String owner, String name, String desc) {
        }

        @Override
        public void visitInnerClass(String name, String outerName, String innerName, int access) {
        }

        @Override
        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            return null;
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            String methodDescription = name + desc;
            this.constrs = (Set)ClassAnnotationSceneWriter.this.dynamicConstructors.get(methodDescription);
            if (this.constrs == null) {
                this.constrs = new TreeSet<Integer>();
                ClassAnnotationSceneWriter.this.dynamicConstructors.put(methodDescription, this.constrs);
            }
            this.lambdas = (Set)ClassAnnotationSceneWriter.this.lambdaExpressions.get(methodDescription);
            if (this.lambdas == null) {
                this.lambdas = new TreeSet<Integer>();
                ClassAnnotationSceneWriter.this.lambdaExpressions.put(methodDescription, this.lambdas);
            }
            return new MethodAdapter(new MethodCodeOffsetAdapter(ClassAnnotationSceneWriter.this.cr, new EmptyVisitor(), this.codeStart){

                @Override
                public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
                    String methodName = ((Handle)bsmArgs[1]).getName();
                    int off = this.getMethodCodeOffset();
                    if ("<init>".equals(methodName)) {
                        MethodCodeIndexer.this.constrs.add(off);
                    } else {
                        int ix = methodName.lastIndexOf(46);
                        if (ix >= 0) {
                            methodName = methodName.substring(ix + 1);
                        }
                        if (methodName.startsWith("lambda$")) {
                            MethodCodeIndexer.this.lambdas.add(off);
                        }
                    }
                    super.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
                }
            });
        }
    }

    private class MethodAnnotationSceneWriter
    extends MethodAdapter {
        private final AMethod aMethod;
        private boolean hasVisitedMethodAnnotations;
        private final List<String> existingMethodAnnotations;

        MethodAnnotationSceneWriter(String name, String desc, MethodVisitor mv) {
            super(mv);
            this.hasVisitedMethodAnnotations = false;
            this.aMethod = ((ClassAnnotationSceneWriter)ClassAnnotationSceneWriter.this).aClass.methods.vivify(name + desc);
            this.existingMethodAnnotations = new ArrayList<String>();
        }

        @Override
        public void visitCode() {
            this.ensureVisitSceneMethodAnnotations();
            super.visitCode();
        }

        @Override
        public void visitEnd() {
            this.ensureVisitSceneMethodAnnotations();
            super.visitEnd();
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            this.existingMethodAnnotations.add(desc);
            if (this.shouldSkipExisting(ClassAnnotationSceneWriter.classDescToName(desc))) {
                return new EmptyVisitor();
            }
            return super.visitAnnotation(desc, visible);
        }

        @Override
        public TypeAnnotationVisitor visitTypeAnnotation(String desc, boolean visible, boolean inCode) {
            this.existingMethodAnnotations.add(desc);
            if (this.shouldSkipExisting(ClassAnnotationSceneWriter.classDescToName(desc))) {
                return new EmptyVisitor();
            }
            return new SafeTypeAnnotationVisitor(super.visitTypeAnnotation(desc, visible, inCode));
        }

        private boolean shouldSkip(Annotation tla) {
            return !ClassAnnotationSceneWriter.this.overwrite && this.existingMethodAnnotations.contains(ClassAnnotationSceneWriter.name(tla));
        }

        private boolean shouldSkipExisting(String name) {
            return !ClassAnnotationSceneWriter.this.overwrite && this.aMethod.lookup(name) != null;
        }

        private AnnotationVisitor visitAnnotation(Annotation tla) {
            return super.visitAnnotation(ClassAnnotationSceneWriter.classNameToDesc(ClassAnnotationSceneWriter.name(tla)), ClassAnnotationSceneWriter.isRuntimeRetention(tla));
        }

        private TypeAnnotationVisitor visitTypeAnnotation(Annotation tla, boolean inCode) {
            return super.visitTypeAnnotation(ClassAnnotationSceneWriter.classNameToDesc(ClassAnnotationSceneWriter.name(tla)), ClassAnnotationSceneWriter.isRuntimeRetention(tla), inCode);
        }

        private AnnotationVisitor visitParameterAnnotation(Annotation tla, int index) {
            return super.visitParameterAnnotation(index, ClassAnnotationSceneWriter.classNameToDesc(ClassAnnotationSceneWriter.name(tla)), ClassAnnotationSceneWriter.isRuntimeRetention(tla));
        }

        private void ensureVisitMethodDeclarationAnnotations() {
            for (Annotation tla : this.aMethod.tlAnnotationsHere) {
                if (this.shouldSkip(tla)) continue;
                AnnotationVisitor av = this.visitAnnotation(tla);
                ClassAnnotationSceneWriter.this.visitFields(av, tla);
                av.visitEnd();
            }
        }

        private void ensureVisitReturnTypeAnnotations() {
            for (Annotation annotation : this.aMethod.returnType.tlAnnotationsHere) {
                if (this.shouldSkip(annotation)) continue;
                TypeAnnotationVisitor av = this.visitTypeAnnotation(annotation, false);
                ClassAnnotationSceneWriter.this.visitTargetType(av, TargetType.METHOD_RETURN);
                ClassAnnotationSceneWriter.this.visitLocations(av, InnerTypeLocation.EMPTY_INNER_TYPE_LOCATION);
                ClassAnnotationSceneWriter.this.visitFields(av, annotation);
                av.visitEnd();
            }
            for (Map.Entry entry : this.aMethod.returnType.innerTypes.entrySet()) {
                InnerTypeLocation loc = (InnerTypeLocation)entry.getKey();
                ATypeElement innerType = (ATypeElement)entry.getValue();
                for (Annotation tla : innerType.tlAnnotationsHere) {
                    TypeAnnotationVisitor xav = this.visitTypeAnnotation(tla, false);
                    ClassAnnotationSceneWriter.this.visitTargetType(xav, TargetType.METHOD_RETURN);
                    ClassAnnotationSceneWriter.this.visitLocations(xav, loc);
                    ClassAnnotationSceneWriter.this.visitFields(xav, tla);
                    xav.visitEnd();
                }
            }
        }

        private void ensureVisitTypeParameterBoundAnnotations() {
            for (Map.Entry e : this.aMethod.bounds.entrySet()) {
                BoundLocation bloc = (BoundLocation)e.getKey();
                ATypeElement bound = (ATypeElement)e.getValue();
                for (Annotation annotation : bound.tlAnnotationsHere) {
                    TypeAnnotationVisitor xav = this.visitTypeAnnotation(annotation, false);
                    if (bloc.boundIndex == -1) {
                        ClassAnnotationSceneWriter.this.visitTargetType(xav, TargetType.METHOD_TYPE_PARAMETER);
                        ClassAnnotationSceneWriter.this.visitBound(xav, bloc);
                    } else {
                        ClassAnnotationSceneWriter.this.visitTargetType(xav, TargetType.METHOD_TYPE_PARAMETER_BOUND);
                        ClassAnnotationSceneWriter.this.visitBound(xav, bloc);
                    }
                    ClassAnnotationSceneWriter.this.visitLocations(xav, InnerTypeLocation.EMPTY_INNER_TYPE_LOCATION);
                    ClassAnnotationSceneWriter.this.visitFields(xav, annotation);
                    xav.visitEnd();
                }
                for (Map.Entry entry : bound.innerTypes.entrySet()) {
                    InnerTypeLocation itloc = (InnerTypeLocation)entry.getKey();
                    ATypeElement innerType = (ATypeElement)entry.getValue();
                    for (Annotation tla : innerType.tlAnnotationsHere) {
                        TypeAnnotationVisitor xav = this.visitTypeAnnotation(tla, false);
                        ClassAnnotationSceneWriter.this.visitTargetType(xav, TargetType.METHOD_TYPE_PARAMETER_BOUND);
                        ClassAnnotationSceneWriter.this.visitBound(xav, bloc);
                        ClassAnnotationSceneWriter.this.visitLocations(xav, itloc);
                        ClassAnnotationSceneWriter.this.visitFields(xav, tla);
                        xav.visitEnd();
                    }
                }
            }
        }

        private void ensureVisitLocalVariablesAnnotations() {
            for (Map.Entry entry : this.aMethod.body.locals.entrySet()) {
                LocalLocation localLocation = (LocalLocation)entry.getKey();
                AElement aLocation = (AElement)entry.getValue();
                for (Annotation annotation : aLocation.tlAnnotationsHere) {
                    if (this.shouldSkip(annotation)) continue;
                    TypeAnnotationVisitor xav = this.visitTypeAnnotation(annotation, true);
                    ClassAnnotationSceneWriter.this.visitTargetType(xav, TargetType.LOCAL_VARIABLE);
                    ClassAnnotationSceneWriter.this.visitLocalVar(xav, localLocation);
                    ClassAnnotationSceneWriter.this.visitLocations(xav, InnerTypeLocation.EMPTY_INNER_TYPE_LOCATION);
                    ClassAnnotationSceneWriter.this.visitFields(xav, annotation);
                    xav.visitEnd();
                }
                for (Map.Entry entry2 : aLocation.type.innerTypes.entrySet()) {
                    InnerTypeLocation localVariableLocation = (InnerTypeLocation)entry2.getKey();
                    ATypeElement aInnerType = (ATypeElement)entry2.getValue();
                    for (Annotation tla : aInnerType.tlAnnotationsHere) {
                        if (this.shouldSkip(tla)) continue;
                        TypeAnnotationVisitor xav = this.visitTypeAnnotation(tla, true);
                        ClassAnnotationSceneWriter.this.visitTargetType(xav, TargetType.LOCAL_VARIABLE);
                        ClassAnnotationSceneWriter.this.visitLocalVar(xav, localLocation);
                        ClassAnnotationSceneWriter.this.visitLocations(xav, localVariableLocation);
                        ClassAnnotationSceneWriter.this.visitFields(xav, tla);
                        xav.visitEnd();
                    }
                }
            }
        }

        private void ensureVisitObjectCreationAnnotations() {
            for (Map.Entry entry : this.aMethod.body.news.entrySet()) {
                if (!((RelativeLocation)entry.getKey()).isBytecodeOffset()) {
                    // empty if block
                }
                int offset = ((RelativeLocation)entry.getKey()).offset;
                ATypeElement aNew = (ATypeElement)entry.getValue();
                for (Annotation annotation : aNew.tlAnnotationsHere) {
                    if (this.shouldSkip(annotation)) continue;
                    TypeAnnotationVisitor xav = this.visitTypeAnnotation(annotation, true);
                    ClassAnnotationSceneWriter.this.visitTargetType(xav, TargetType.NEW);
                    ClassAnnotationSceneWriter.this.visitOffset(xav, offset);
                    ClassAnnotationSceneWriter.this.visitLocations(xav, InnerTypeLocation.EMPTY_INNER_TYPE_LOCATION);
                    ClassAnnotationSceneWriter.this.visitFields(xav, annotation);
                    xav.visitEnd();
                }
                for (Map.Entry entry2 : aNew.innerTypes.entrySet()) {
                    InnerTypeLocation aNewLocation = (InnerTypeLocation)entry2.getKey();
                    ATypeElement aInnerType = (ATypeElement)entry2.getValue();
                    for (Annotation tla : aInnerType.tlAnnotationsHere) {
                        if (this.shouldSkip(tla)) continue;
                        TypeAnnotationVisitor xav = this.visitTypeAnnotation(tla, true);
                        ClassAnnotationSceneWriter.this.visitTargetType(xav, TargetType.NEW);
                        ClassAnnotationSceneWriter.this.visitOffset(xav, offset);
                        ClassAnnotationSceneWriter.this.visitLocations(xav, aNewLocation);
                        ClassAnnotationSceneWriter.this.visitFields(xav, tla);
                        xav.visitEnd();
                    }
                }
            }
        }

        private void ensureVisitParameterAnnotations() {
            for (Map.Entry entry : this.aMethod.parameters.entrySet()) {
                AnnotationVisitor av;
                AField aParameter = (AField)entry.getValue();
                int index = (Integer)entry.getKey();
                for (Annotation annotation : aParameter.tlAnnotationsHere) {
                    if (this.shouldSkip(annotation)) continue;
                    av = this.visitParameterAnnotation(annotation, index);
                    ClassAnnotationSceneWriter.this.visitFields(av, annotation);
                    av.visitEnd();
                }
                for (Annotation annotation : aParameter.type.tlAnnotationsHere) {
                    if (this.shouldSkip(annotation)) continue;
                    av = this.visitTypeAnnotation(annotation, false);
                    ClassAnnotationSceneWriter.this.visitTargetType((TypeAnnotationVisitor)av, TargetType.METHOD_FORMAL_PARAMETER);
                    ClassAnnotationSceneWriter.this.visitParameterIndex((TypeAnnotationVisitor)av, index);
                    ClassAnnotationSceneWriter.this.visitLocations((TypeAnnotationVisitor)av, InnerTypeLocation.EMPTY_INNER_TYPE_LOCATION);
                    ClassAnnotationSceneWriter.this.visitFields((TypeAnnotationVisitor)av, annotation);
                    av.visitEnd();
                }
                for (Map.Entry entry2 : aParameter.type.innerTypes.entrySet()) {
                    InnerTypeLocation aParameterLocation = (InnerTypeLocation)entry2.getKey();
                    ATypeElement aInnerType = (ATypeElement)entry2.getValue();
                    for (Annotation tla : aInnerType.tlAnnotationsHere) {
                        if (this.shouldSkip(tla)) continue;
                        TypeAnnotationVisitor xav = this.visitTypeAnnotation(tla, false);
                        ClassAnnotationSceneWriter.this.visitTargetType(xav, TargetType.METHOD_FORMAL_PARAMETER);
                        ClassAnnotationSceneWriter.this.visitParameterIndex(xav, index);
                        ClassAnnotationSceneWriter.this.visitLocations(xav, aParameterLocation);
                        ClassAnnotationSceneWriter.this.visitFields(xav, tla);
                        xav.visitEnd();
                    }
                }
            }
        }

        private void ensureVisitReceiverAnnotations() {
            AField aReceiver = this.aMethod.receiver;
            for (Annotation annotation : aReceiver.type.tlAnnotationsHere) {
                if (this.shouldSkip(annotation)) continue;
                TypeAnnotationVisitor xav = this.visitTypeAnnotation(annotation, false);
                ClassAnnotationSceneWriter.this.visitTargetType(xav, TargetType.METHOD_RECEIVER);
                ClassAnnotationSceneWriter.this.visitLocations(xav, InnerTypeLocation.EMPTY_INNER_TYPE_LOCATION);
                ClassAnnotationSceneWriter.this.visitFields(xav, annotation);
                xav.visitEnd();
            }
            for (Map.Entry entry : aReceiver.type.innerTypes.entrySet()) {
                InnerTypeLocation aReceiverLocation = (InnerTypeLocation)entry.getKey();
                ATypeElement aInnerType = (ATypeElement)entry.getValue();
                for (Annotation tla : aInnerType.tlAnnotationsHere) {
                    if (this.shouldSkip(tla)) continue;
                    TypeAnnotationVisitor xav = this.visitTypeAnnotation(tla, false);
                    ClassAnnotationSceneWriter.this.visitTargetType(xav, TargetType.METHOD_RECEIVER);
                    ClassAnnotationSceneWriter.this.visitLocations(xav, aReceiverLocation);
                    ClassAnnotationSceneWriter.this.visitFields(xav, tla);
                    xav.visitEnd();
                }
            }
        }

        private void ensureVisitTypecastAnnotations() {
            for (Map.Entry entry : this.aMethod.body.typecasts.entrySet()) {
                if (!((RelativeLocation)entry.getKey()).isBytecodeOffset()) {
                    // empty if block
                }
                int offset = ((RelativeLocation)entry.getKey()).offset;
                int typeIndex = ((RelativeLocation)entry.getKey()).type_index;
                ATypeElement aTypecast = (ATypeElement)entry.getValue();
                for (Annotation annotation : aTypecast.tlAnnotationsHere) {
                    if (this.shouldSkip(annotation)) continue;
                    TypeAnnotationVisitor xav = this.visitTypeAnnotation(annotation, true);
                    ClassAnnotationSceneWriter.this.visitTargetType(xav, TargetType.CAST);
                    ClassAnnotationSceneWriter.this.visitOffset(xav, offset);
                    ClassAnnotationSceneWriter.this.visitTypeIndex(xav, typeIndex);
                    ClassAnnotationSceneWriter.this.visitLocations(xav, InnerTypeLocation.EMPTY_INNER_TYPE_LOCATION);
                    ClassAnnotationSceneWriter.this.visitFields(xav, annotation);
                    xav.visitEnd();
                }
                for (Map.Entry entry2 : aTypecast.innerTypes.entrySet()) {
                    InnerTypeLocation aTypecastLocation = (InnerTypeLocation)entry2.getKey();
                    ATypeElement aInnerType = (ATypeElement)entry2.getValue();
                    for (Annotation tla : aInnerType.tlAnnotationsHere) {
                        if (this.shouldSkip(tla)) continue;
                        TypeAnnotationVisitor xav = this.visitTypeAnnotation(tla, true);
                        ClassAnnotationSceneWriter.this.visitTargetType(xav, TargetType.CAST);
                        ClassAnnotationSceneWriter.this.visitOffset(xav, offset);
                        ClassAnnotationSceneWriter.this.visitTypeIndex(xav, typeIndex);
                        ClassAnnotationSceneWriter.this.visitLocations(xav, aTypecastLocation);
                        ClassAnnotationSceneWriter.this.visitFields(xav, tla);
                        xav.visitEnd();
                    }
                }
            }
        }

        private void ensureVisitTypeTestAnnotations() {
            for (Map.Entry entry : this.aMethod.body.instanceofs.entrySet()) {
                if (!((RelativeLocation)entry.getKey()).isBytecodeOffset()) {
                    // empty if block
                }
                int offset = ((RelativeLocation)entry.getKey()).offset;
                ATypeElement aTypeTest = (ATypeElement)entry.getValue();
                for (Annotation annotation : aTypeTest.tlAnnotationsHere) {
                    if (this.shouldSkip(annotation)) continue;
                    TypeAnnotationVisitor xav = this.visitTypeAnnotation(annotation, true);
                    ClassAnnotationSceneWriter.this.visitTargetType(xav, TargetType.INSTANCEOF);
                    ClassAnnotationSceneWriter.this.visitOffset(xav, offset);
                    ClassAnnotationSceneWriter.this.visitLocations(xav, InnerTypeLocation.EMPTY_INNER_TYPE_LOCATION);
                    ClassAnnotationSceneWriter.this.visitFields(xav, annotation);
                    xav.visitEnd();
                }
                for (Map.Entry entry2 : aTypeTest.innerTypes.entrySet()) {
                    InnerTypeLocation aTypeTestLocation = (InnerTypeLocation)entry2.getKey();
                    AElement aInnerType = (AElement)entry2.getValue();
                    for (Annotation tla : aInnerType.tlAnnotationsHere) {
                        if (this.shouldSkip(tla)) continue;
                        TypeAnnotationVisitor xav = this.visitTypeAnnotation(tla, true);
                        ClassAnnotationSceneWriter.this.visitTargetType(xav, TargetType.INSTANCEOF);
                        ClassAnnotationSceneWriter.this.visitOffset(xav, offset);
                        ClassAnnotationSceneWriter.this.visitLocations(xav, aTypeTestLocation);
                        ClassAnnotationSceneWriter.this.visitFields(xav, tla);
                        xav.visitEnd();
                    }
                }
            }
        }

        private void ensureVisitLambdaExpressionAnnotations() {
            for (Map.Entry entry : this.aMethod.body.funs.entrySet()) {
                if (!((RelativeLocation)entry.getKey()).isBytecodeOffset()) continue;
                AMethod aLambda = (AMethod)entry.getValue();
                for (Map.Entry e0 : aLambda.parameters.entrySet()) {
                    AField aParameter = (AField)e0.getValue();
                    int index = (Integer)e0.getKey();
                    for (Annotation annotation : aParameter.tlAnnotationsHere) {
                        if (this.shouldSkip(annotation)) continue;
                        AnnotationVisitor av = this.visitParameterAnnotation(annotation, index);
                        ClassAnnotationSceneWriter.this.visitFields(av, annotation);
                        av.visitEnd();
                    }
                    for (Annotation annotation : aParameter.type.tlAnnotationsHere) {
                        if (this.shouldSkip(annotation)) continue;
                        TypeAnnotationVisitor xav = this.visitTypeAnnotation(annotation, false);
                        ClassAnnotationSceneWriter.this.visitTargetType(xav, TargetType.METHOD_FORMAL_PARAMETER);
                        ClassAnnotationSceneWriter.this.visitParameterIndex(xav, index);
                        ClassAnnotationSceneWriter.this.visitLocations(xav, InnerTypeLocation.EMPTY_INNER_TYPE_LOCATION);
                        ClassAnnotationSceneWriter.this.visitFields(xav, annotation);
                        xav.visitEnd();
                    }
                    for (Map.Entry entry2 : aParameter.type.innerTypes.entrySet()) {
                        InnerTypeLocation aParameterLocation = (InnerTypeLocation)entry2.getKey();
                        ATypeElement aInnerType = (ATypeElement)entry2.getValue();
                        for (Annotation tla : aInnerType.tlAnnotationsHere) {
                            if (this.shouldSkip(tla)) continue;
                            TypeAnnotationVisitor xav = this.visitTypeAnnotation(tla, false);
                            ClassAnnotationSceneWriter.this.visitTargetType(xav, TargetType.METHOD_FORMAL_PARAMETER);
                            ClassAnnotationSceneWriter.this.visitParameterIndex(xav, index);
                            ClassAnnotationSceneWriter.this.visitLocations(xav, aParameterLocation);
                            ClassAnnotationSceneWriter.this.visitFields(xav, tla);
                            xav.visitEnd();
                        }
                    }
                }
            }
        }

        private void ensureVisitMemberReferenceAnnotations() {
            for (Map.Entry entry : this.aMethod.body.refs.entrySet()) {
                if (!((RelativeLocation)entry.getKey()).isBytecodeOffset()) continue;
                int offset = ((RelativeLocation)entry.getKey()).offset;
                int typeIndex = ((RelativeLocation)entry.getKey()).type_index;
                ATypeElement aTypeArg = (ATypeElement)entry.getValue();
                Set lset = (Set)ClassAnnotationSceneWriter.this.lambdaExpressions.get(this.aMethod.methodName);
                if (lset.contains(offset)) continue;
                Set cset = (Set)ClassAnnotationSceneWriter.this.dynamicConstructors.get(this.aMethod.methodName);
                TargetType tt = cset != null && cset.contains(offset) ? TargetType.CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT : TargetType.METHOD_REFERENCE_TYPE_ARGUMENT;
                for (Annotation annotation : aTypeArg.tlAnnotationsHere) {
                    if (this.shouldSkip(annotation)) continue;
                    TypeAnnotationVisitor xav = this.visitTypeAnnotation(annotation, true);
                    ClassAnnotationSceneWriter.this.visitTargetType(xav, tt);
                    ClassAnnotationSceneWriter.this.visitOffset(xav, offset);
                    ClassAnnotationSceneWriter.this.visitTypeIndex(xav, typeIndex);
                    ClassAnnotationSceneWriter.this.visitLocations(xav, InnerTypeLocation.EMPTY_INNER_TYPE_LOCATION);
                    ClassAnnotationSceneWriter.this.visitFields(xav, annotation);
                    xav.visitEnd();
                }
                for (Map.Entry entry2 : aTypeArg.innerTypes.entrySet()) {
                    InnerTypeLocation aTypeArgLocation = (InnerTypeLocation)entry2.getKey();
                    AElement aInnerType = (AElement)entry2.getValue();
                    for (Annotation tla : aInnerType.tlAnnotationsHere) {
                        if (this.shouldSkip(tla)) continue;
                        TypeAnnotationVisitor xav = this.visitTypeAnnotation(tla, true);
                        ClassAnnotationSceneWriter.this.visitTargetType(xav, tt);
                        ClassAnnotationSceneWriter.this.visitOffset(xav, offset);
                        ClassAnnotationSceneWriter.this.visitTypeIndex(xav, typeIndex);
                        ClassAnnotationSceneWriter.this.visitLocations(xav, aTypeArgLocation);
                        ClassAnnotationSceneWriter.this.visitFields(xav, tla);
                        xav.visitEnd();
                    }
                }
            }
        }

        private void ensureVisitMethodInvocationAnnotations() {
            for (Map.Entry entry : this.aMethod.body.calls.entrySet()) {
                if (!((RelativeLocation)entry.getKey()).isBytecodeOffset()) {
                    // empty if block
                }
                int offset = ((RelativeLocation)entry.getKey()).offset;
                int typeIndex = ((RelativeLocation)entry.getKey()).type_index;
                ATypeElement aCall = (ATypeElement)entry.getValue();
                Set cset = (Set)ClassAnnotationSceneWriter.this.dynamicConstructors.get(this.aMethod.methodName);
                TargetType tt = cset != null && cset.contains(offset) ? TargetType.CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT : TargetType.METHOD_INVOCATION_TYPE_ARGUMENT;
                for (Annotation annotation : aCall.tlAnnotationsHere) {
                    if (this.shouldSkip(annotation)) continue;
                    TypeAnnotationVisitor xav = this.visitTypeAnnotation(annotation, true);
                    ClassAnnotationSceneWriter.this.visitTargetType(xav, tt);
                    ClassAnnotationSceneWriter.this.visitOffset(xav, offset);
                    ClassAnnotationSceneWriter.this.visitTypeIndex(xav, typeIndex);
                    ClassAnnotationSceneWriter.this.visitLocations(xav, InnerTypeLocation.EMPTY_INNER_TYPE_LOCATION);
                    ClassAnnotationSceneWriter.this.visitFields(xav, annotation);
                    xav.visitEnd();
                }
                for (Map.Entry entry2 : aCall.innerTypes.entrySet()) {
                    InnerTypeLocation aCallLocation = (InnerTypeLocation)entry2.getKey();
                    AElement aInnerType = (AElement)entry2.getValue();
                    for (Annotation tla : aInnerType.tlAnnotationsHere) {
                        if (this.shouldSkip(tla)) continue;
                        TypeAnnotationVisitor xav = this.visitTypeAnnotation(tla, true);
                        ClassAnnotationSceneWriter.this.visitTargetType(xav, TargetType.INSTANCEOF);
                        ClassAnnotationSceneWriter.this.visitOffset(xav, offset);
                        ClassAnnotationSceneWriter.this.visitTypeIndex(xav, typeIndex);
                        ClassAnnotationSceneWriter.this.visitLocations(xav, aCallLocation);
                        ClassAnnotationSceneWriter.this.visitFields(xav, tla);
                        xav.visitEnd();
                    }
                }
            }
        }

        private void ensureVisitSceneMethodAnnotations() {
            if (!this.hasVisitedMethodAnnotations) {
                this.hasVisitedMethodAnnotations = true;
                this.ensureVisitMethodDeclarationAnnotations();
                this.ensureVisitReturnTypeAnnotations();
                this.ensureVisitTypeParameterBoundAnnotations();
                this.ensureVisitLocalVariablesAnnotations();
                this.ensureVisitObjectCreationAnnotations();
                this.ensureVisitParameterAnnotations();
                this.ensureVisitReceiverAnnotations();
                this.ensureVisitTypecastAnnotations();
                this.ensureVisitTypeTestAnnotations();
                this.ensureVisitLambdaExpressionAnnotations();
                this.ensureVisitMemberReferenceAnnotations();
                this.ensureVisitMethodInvocationAnnotations();
            }
        }
    }

    private class FieldAnnotationSceneWriter
    implements FieldVisitor {
        private final FieldVisitor fv;
        private final List<String> existingFieldAnnotations;
        private final AElement aField;

        public FieldAnnotationSceneWriter(String name, FieldVisitor fv) {
            this.fv = fv;
            this.existingFieldAnnotations = new ArrayList<String>();
            this.aField = ((ClassAnnotationSceneWriter)ClassAnnotationSceneWriter.this).aClass.fields.vivify(name);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            this.existingFieldAnnotations.add(desc);
            if (this.aField.lookup(ClassAnnotationSceneWriter.classDescToName(desc)) != null && ClassAnnotationSceneWriter.this.overwrite) {
                return new EmptyVisitor();
            }
            return this.fv.visitAnnotation(desc, visible);
        }

        @Override
        public TypeAnnotationVisitor visitTypeAnnotation(String desc, boolean visible, boolean inCode) {
            this.existingFieldAnnotations.add(desc);
            if (this.aField.lookup(ClassAnnotationSceneWriter.classDescToName(desc)) != null && ClassAnnotationSceneWriter.this.overwrite) {
                return new EmptyVisitor();
            }
            return new SafeTypeAnnotationVisitor(this.fv.visitTypeAnnotation(desc, visible, inCode));
        }

        @Override
        public void visitAttribute(Attribute attr) {
            this.fv.visitAttribute(attr);
        }

        @Override
        public void visitEnd() {
            this.ensureVisitSceneFieldAnnotations();
            this.fv.visitEnd();
        }

        private void ensureVisitSceneFieldAnnotations() {
            AnnotationVisitor av;
            for (Annotation annotation : this.aField.tlAnnotationsHere) {
                if (!ClassAnnotationSceneWriter.this.overwrite && this.existingFieldAnnotations.contains(ClassAnnotationSceneWriter.name(annotation))) continue;
                av = this.fv.visitAnnotation(ClassAnnotationSceneWriter.classNameToDesc(ClassAnnotationSceneWriter.name(annotation)), ClassAnnotationSceneWriter.isRuntimeRetention(annotation));
                ClassAnnotationSceneWriter.this.visitFields(av, annotation);
                av.visitEnd();
            }
            for (Annotation annotation : this.aField.type.tlAnnotationsHere) {
                if (!ClassAnnotationSceneWriter.this.overwrite && this.existingFieldAnnotations.contains(ClassAnnotationSceneWriter.name(annotation))) continue;
                av = this.fv.visitTypeAnnotation(ClassAnnotationSceneWriter.classNameToDesc(ClassAnnotationSceneWriter.name(annotation)), ClassAnnotationSceneWriter.isRuntimeRetention(annotation), false);
                ClassAnnotationSceneWriter.this.visitTargetType((TypeAnnotationVisitor)av, TargetType.FIELD);
                ClassAnnotationSceneWriter.this.visitLocations((TypeAnnotationVisitor)av, InnerTypeLocation.EMPTY_INNER_TYPE_LOCATION);
                ClassAnnotationSceneWriter.this.visitFields((TypeAnnotationVisitor)av, annotation);
                av.visitEnd();
            }
            for (Map.Entry entry : this.aField.type.innerTypes.entrySet()) {
                for (Annotation tla : ((ATypeElement)entry.getValue()).tlAnnotationsHere) {
                    if (!ClassAnnotationSceneWriter.this.overwrite && this.existingFieldAnnotations.contains(ClassAnnotationSceneWriter.name(tla))) continue;
                    TypeAnnotationVisitor xav = this.fv.visitTypeAnnotation(ClassAnnotationSceneWriter.classNameToDesc(ClassAnnotationSceneWriter.name(tla)), ClassAnnotationSceneWriter.isRuntimeRetention(tla), false);
                    ClassAnnotationSceneWriter.this.visitTargetType(xav, TargetType.FIELD);
                    ClassAnnotationSceneWriter.this.visitLocations(xav, (InnerTypeLocation)entry.getKey());
                    ClassAnnotationSceneWriter.this.visitFields(xav, tla);
                    xav.visitEnd();
                }
            }
        }
    }
}

