/*
 * Decompiled with CFR 0.152.
 */
package annotations.el;

import annotations.Annotation;
import annotations.el.ABlock;
import annotations.el.ADeclaration;
import annotations.el.AExpression;
import annotations.el.AField;
import annotations.el.AMethod;
import annotations.el.ATypeElement;
import annotations.el.BoundLocation;
import annotations.el.ElementVisitor;
import annotations.el.TypeIndexLocation;
import annotations.util.coll.VivifyingMap;
import java.util.LinkedHashMap;
import plume.UtilMDE;

public final class AClass
extends ADeclaration {
    public final VivifyingMap<BoundLocation, ATypeElement> bounds = ATypeElement.newVivifyingLHMap_ATE();
    public final VivifyingMap<TypeIndexLocation, ATypeElement> extendsImplements = ATypeElement.newVivifyingLHMap_ATE();
    public final VivifyingMap<String, AMethod> methods = AClass.createMethodMap();
    public final VivifyingMap<Integer, ABlock> staticInits = AClass.createInitBlockMap();
    public final VivifyingMap<Integer, ABlock> instanceInits = AClass.createInitBlockMap();
    public final VivifyingMap<String, AField> fields = AField.newVivifyingLHMap_AF();
    public final VivifyingMap<String, AExpression> fieldInits = AClass.createFieldInitMap();
    private final String className;

    private static VivifyingMap<String, AMethod> createMethodMap() {
        return new VivifyingMap<String, AMethod>(new LinkedHashMap()){

            @Override
            public AMethod createValueFor(String k) {
                return new AMethod(k);
            }

            @Override
            public boolean subPrune(AMethod v) {
                return v.prune();
            }
        };
    }

    private static VivifyingMap<Integer, ABlock> createInitBlockMap() {
        return new VivifyingMap<Integer, ABlock>(new LinkedHashMap()){

            @Override
            public ABlock createValueFor(Integer k) {
                return new ABlock(k);
            }

            @Override
            public boolean subPrune(ABlock v) {
                return v.prune();
            }
        };
    }

    private static VivifyingMap<String, AExpression> createFieldInitMap() {
        return new VivifyingMap<String, AExpression>(new LinkedHashMap()){

            @Override
            public AExpression createValueFor(String k) {
                return new AExpression(k);
            }

            @Override
            public boolean subPrune(AExpression v) {
                return v.prune();
            }
        };
    }

    AClass(String className) {
        super("class: " + className);
        this.className = className;
    }

    AClass(AClass clazz) {
        super(clazz);
        this.className = clazz.className;
        this.copyMapContents(clazz.bounds, this.bounds);
        this.copyMapContents(clazz.extendsImplements, this.extendsImplements);
        this.copyMapContents(clazz.fieldInits, this.fieldInits);
        this.copyMapContents(clazz.fields, this.fields);
        this.copyMapContents(clazz.instanceInits, this.instanceInits);
        this.copyMapContents(clazz.methods, this.methods);
        this.copyMapContents(clazz.staticInits, this.staticInits);
    }

    @Override
    public AClass clone() {
        return new AClass(this);
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof AClass && ((AClass)o).equalsClass(this);
    }

    final boolean equalsClass(AClass o) {
        return super.equals(o) && this.className.equals(o.className) && this.bounds.equals(o.bounds) && this.methods.equals(o.methods) && this.fields.equals(o.fields) && this.extendsImplements.equals(o.extendsImplements);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.bounds.hashCode() + this.methods.hashCode() + this.fields.hashCode() + this.staticInits.hashCode() + this.instanceInits.hashCode() + this.extendsImplements.hashCode();
    }

    @Override
    public boolean prune() {
        return super.prune() & this.bounds.prune() & this.methods.prune() & this.fields.prune() & this.staticInits.prune() & this.instanceInits.prune() & this.extendsImplements.prune();
    }

    @Override
    public String toString() {
        return "AClass: " + this.className;
    }

    public String unparse() {
        return this.unparse("");
    }

    public String unparse(String linePrefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(linePrefix);
        sb.append(this.toString());
        sb.append("\n");
        sb.append(linePrefix);
        sb.append("Annotations:\n");
        for (Annotation a : this.tlAnnotationsHere) {
            sb.append(linePrefix);
            sb.append("  " + a + "\n");
        }
        sb.append(linePrefix);
        sb.append("Bounds:\n");
        UtilMDE.mapToString(sb, this.bounds, linePrefix + "  ");
        sb.append(linePrefix);
        sb.append("Extends/implements:\n");
        UtilMDE.mapToString(sb, this.extendsImplements, linePrefix + "  ");
        sb.append(linePrefix);
        sb.append("Fields:\n");
        UtilMDE.mapToString(sb, this.fields, linePrefix + "  ");
        sb.append(linePrefix);
        sb.append("Field Initializers:\n");
        UtilMDE.mapToString(sb, this.fieldInits, linePrefix + "  ");
        sb.append(linePrefix);
        sb.append("Static Initializers:\n");
        UtilMDE.mapToString(sb, this.staticInits, linePrefix + "  ");
        sb.append(linePrefix);
        sb.append("Instance Initializers:\n");
        UtilMDE.mapToString(sb, this.instanceInits, linePrefix + "  ");
        sb.append(linePrefix);
        sb.append("AST Typecasts:\n");
        UtilMDE.mapToString(sb, this.insertTypecasts, linePrefix + "  ");
        sb.append(linePrefix);
        sb.append("AST Annotations:\n");
        UtilMDE.mapToString(sb, this.insertAnnotations, linePrefix + "  ");
        sb.append(linePrefix);
        sb.append("Methods:\n");
        UtilMDE.mapToString(sb, this.methods, linePrefix + "  ");
        return sb.toString();
    }

    @Override
    public <R, T> R accept(ElementVisitor<R, T> v, T t) {
        return v.visitClass(this, t);
    }
}

