/*
 * Decompiled with CFR 0.152.
 */
package annotations;

import annotations.Annotation;
import annotations.ArrayBuilder;
import annotations.el.AnnotationDef;
import annotations.field.AnnotationFieldType;
import annotations.field.ArrayAFT;
import annotations.field.ScalarAFT;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AnnotationBuilder {
    AnnotationDef def;
    private String typeName;
    Set<Annotation> tlAnnotationsHere;
    boolean arrayInProgress = false;
    boolean active = true;
    private Map<String, AnnotationFieldType> fieldTypes = new LinkedHashMap<String, AnnotationFieldType>();
    Map<String, Object> fieldValues = new LinkedHashMap<String, Object>();

    public String typeName() {
        if (this.def != null) {
            return this.def.name;
        }
        return this.typeName;
    }

    public Map<String, AnnotationFieldType> fieldTypes() {
        if (this.def != null) {
            return this.def.fieldTypes;
        }
        return this.fieldTypes;
    }

    private void checkAddField(String fieldName) {
        if (!this.active) {
            throw new IllegalStateException("Already finished");
        }
        if (this.arrayInProgress) {
            throw new IllegalStateException("Array in progress");
        }
        if (this.fieldValues.containsKey(fieldName)) {
            throw new IllegalArgumentException("Duplicate field '" + fieldName + "' in " + this.fieldValues);
        }
    }

    public void addScalarField(String fieldName, ScalarAFT aft, Object x) {
        this.checkAddField(fieldName);
        if (x instanceof Annotation && !(x instanceof Annotation)) {
            throw new IllegalArgumentException("All subannotations must be Annotations");
        }
        if (this.def == null) {
            this.fieldTypes.put(fieldName, aft);
        }
        this.fieldValues.put(fieldName, x);
    }

    public ArrayBuilder beginArrayField(String fieldName, ArrayAFT aft) {
        this.checkAddField(fieldName);
        if (this.def == null) {
            this.fieldTypes.put(fieldName, aft);
        } else {
            aft = (ArrayAFT)this.fieldTypes().get(fieldName);
            if (aft == null) {
                throw new Error(String.format("Definition for %s lacks field %s:%n  %s", this.def.name, fieldName, this.def));
            }
            assert (aft != null);
        }
        this.arrayInProgress = true;
        assert (aft.elementType != null);
        return new SimpleArrayBuilder(fieldName, aft.elementType);
    }

    public void addEmptyArrayField(String fieldName) {
        this.checkAddField(fieldName);
        if (this.def == null) {
            this.fieldTypes.put(fieldName, new ArrayAFT(null));
        }
        this.fieldValues.put(fieldName, Collections.emptyList());
    }

    public Annotation finish() {
        if (!this.active) {
            throw new IllegalStateException("Already finished: " + this);
        }
        if (this.arrayInProgress) {
            throw new IllegalStateException("Array in progress: " + this);
        }
        this.active = false;
        if (this.def == null) {
            assert (this.fieldTypes != null);
            this.def = new AnnotationDef(this.typeName, this.tlAnnotationsHere, this.fieldTypes);
        } else {
            assert (this.typeName == null);
            assert (this.fieldTypes.isEmpty());
        }
        return new Annotation(this.def, this.fieldValues);
    }

    AnnotationBuilder(AnnotationDef def) {
        assert (def != null);
        this.def = def;
    }

    AnnotationBuilder(String typeName) {
        assert (typeName != null);
        this.typeName = typeName;
    }

    AnnotationBuilder(String typeName, Set<Annotation> tlAnnotationsHere) {
        assert (typeName != null);
        this.typeName = typeName;
        this.tlAnnotationsHere = tlAnnotationsHere;
    }

    public String toString() {
        if (this.def != null) {
            return String.format("AnnotationBuilder %s", this.def);
        }
        return String.format("(AnnotationBuilder %s : %s)", this.typeName, this.tlAnnotationsHere);
    }

    class SimpleArrayBuilder
    implements ArrayBuilder {
        boolean abActive = true;
        String fieldName;
        AnnotationFieldType aft;
        List<Object> arrayElements = new ArrayList<Object>();

        SimpleArrayBuilder(String fieldName, AnnotationFieldType aft) {
            assert (aft != null);
            assert (fieldName != null);
            this.fieldName = fieldName;
            this.aft = aft;
        }

        @Override
        public void appendElement(Object x) {
            if (!this.abActive) {
                throw new IllegalStateException("Array is finished");
            }
            if (!this.aft.isValidValue(x)) {
                throw new IllegalArgumentException(String.format("Bad array element value%n  %s (%s)%nfor field %s%n  %s (%s)", x, x.getClass(), this.fieldName, this.aft, this.aft.getClass()));
            }
            this.arrayElements.add(x);
        }

        @Override
        public void finish() {
            if (!this.abActive) {
                throw new IllegalStateException("Array is finished");
            }
            AnnotationBuilder.this.fieldValues.put(this.fieldName, Collections.unmodifiableList(this.arrayElements));
            AnnotationBuilder.this.arrayInProgress = false;
            this.abActive = false;
        }
    }
}

