/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.math.BigDecimal;
import java.nio.CharBuffer;

public class ByteConverter {
    private static final int NBASE = 10000;
    private static final int NUMERIC_DSCALE_MASK = 16383;
    private static final short NUMERIC_POS = 0;
    private static final short NUMERIC_NEG = 16384;
    private static final short NUMERIC_NAN = -16384;
    private static final int DEC_DIGITS = 4;
    private static final int[] round_powers = new int[]{0, 1000, 100, 10};
    private static final int SHORT_BYTES = 2;
    private static final int LONG_BYTES = 4;

    private ByteConverter() {
    }

    public static int bytesToInt(byte[] bytes) {
        if (bytes.length == 1) {
            return bytes[0];
        }
        if (bytes.length == 2) {
            return ByteConverter.int2(bytes, 0);
        }
        if (bytes.length == 4) {
            return ByteConverter.int4(bytes, 0);
        }
        throw new IllegalArgumentException("Argument bytes is empty");
    }

    private static void digitToString(int idx, short[] digits, CharBuffer buffer, boolean alwaysPutIt) {
        short dig = idx >= 0 && idx < digits.length ? digits[idx] : (short)0;
        for (int p2 = 1; p2 < round_powers.length; ++p2) {
            boolean putit;
            int pow = round_powers[p2];
            short d1 = (short)(dig / pow);
            dig = (short)(dig - d1 * pow);
            boolean bl2 = putit = d1 > 0;
            if (!putit && !alwaysPutIt) continue;
            buffer.put((char)(d1 + 48));
        }
        buffer.put((char)(dig + 48));
    }

    private static String numberBytesToString(short[] digits, int scale, int weight, int sign) {
        int d2;
        int i2 = (weight + 1) * 4;
        if (i2 <= 0) {
            i2 = 1;
        }
        CharBuffer buffer = CharBuffer.allocate(i2 + scale + 4 + 2);
        if (sign == 16384) {
            buffer.put('-');
        }
        if (weight < 0) {
            d2 = weight + 1;
            buffer.put('0');
        } else {
            for (d2 = 0; d2 <= weight; ++d2) {
                ByteConverter.digitToString(d2, digits, buffer, d2 != 0);
            }
        }
        if (scale > 0) {
            buffer.put('.');
            for (i2 = 0; i2 < scale; i2 += 4) {
                ByteConverter.digitToString(d2, digits, buffer, true);
                ++d2;
            }
        }
        int extra = (i2 - scale) % 4;
        return new String(buffer.array(), 0, buffer.position() - extra);
    }

    public static Number numeric(byte[] bytes) {
        return ByteConverter.numeric(bytes, 0, bytes.length);
    }

    public static Number numeric(byte[] bytes, int pos, int numBytes) {
        if (numBytes < 8) {
            throw new IllegalArgumentException("number of bytes should be at-least 8");
        }
        int len = ByteConverter.int2(bytes, pos);
        short weight = ByteConverter.int2(bytes, pos + 2);
        short sign = ByteConverter.int2(bytes, pos + 4);
        short scale = ByteConverter.int2(bytes, pos + 6);
        if (numBytes != len * 2 + 8) {
            throw new IllegalArgumentException("invalid length of bytes \"numeric\" value");
        }
        if (sign != 0 && sign != 16384 && sign != -16384) {
            throw new IllegalArgumentException("invalid sign in \"numeric\" value");
        }
        if (sign == -16384) {
            return Double.NaN;
        }
        if ((scale & 0x3FFF) != scale) {
            throw new IllegalArgumentException("invalid scale in \"numeric\" value");
        }
        short[] digits = new short[len];
        int idx = pos + 8;
        for (int i2 = 0; i2 < len; ++i2) {
            short d2 = ByteConverter.int2(bytes, idx);
            idx += 2;
            if (d2 < 0 || d2 >= 10000) {
                throw new IllegalArgumentException("invalid digit in \"numeric\" value");
            }
            digits[i2] = d2;
        }
        String numString = ByteConverter.numberBytesToString(digits, scale, weight, sign);
        return new BigDecimal(numString);
    }

    public static long int8(byte[] bytes, int idx) {
        return ((long)(bytes[idx + 0] & 0xFF) << 56) + ((long)(bytes[idx + 1] & 0xFF) << 48) + ((long)(bytes[idx + 2] & 0xFF) << 40) + ((long)(bytes[idx + 3] & 0xFF) << 32) + ((long)(bytes[idx + 4] & 0xFF) << 24) + ((long)(bytes[idx + 5] & 0xFF) << 16) + ((long)(bytes[idx + 6] & 0xFF) << 8) + (long)(bytes[idx + 7] & 0xFF);
    }

    public static int int4(byte[] bytes, int idx) {
        return ((bytes[idx] & 0xFF) << 24) + ((bytes[idx + 1] & 0xFF) << 16) + ((bytes[idx + 2] & 0xFF) << 8) + (bytes[idx + 3] & 0xFF);
    }

    public static short int2(byte[] bytes, int idx) {
        return (short)(((bytes[idx] & 0xFF) << 8) + (bytes[idx + 1] & 0xFF));
    }

    public static boolean bool(byte[] bytes, int idx) {
        return bytes[idx] == 1;
    }

    public static float float4(byte[] bytes, int idx) {
        return Float.intBitsToFloat(ByteConverter.int4(bytes, idx));
    }

    public static double float8(byte[] bytes, int idx) {
        return Double.longBitsToDouble(ByteConverter.int8(bytes, idx));
    }

    public static void int8(byte[] target, int idx, long value) {
        target[idx + 0] = (byte)(value >>> 56);
        target[idx + 1] = (byte)(value >>> 48);
        target[idx + 2] = (byte)(value >>> 40);
        target[idx + 3] = (byte)(value >>> 32);
        target[idx + 4] = (byte)(value >>> 24);
        target[idx + 5] = (byte)(value >>> 16);
        target[idx + 6] = (byte)(value >>> 8);
        target[idx + 7] = (byte)value;
    }

    public static void int4(byte[] target, int idx, int value) {
        target[idx + 0] = (byte)(value >>> 24);
        target[idx + 1] = (byte)(value >>> 16);
        target[idx + 2] = (byte)(value >>> 8);
        target[idx + 3] = (byte)value;
    }

    public static void int2(byte[] target, int idx, int value) {
        target[idx + 0] = (byte)(value >>> 8);
        target[idx + 1] = (byte)value;
    }

    public static void bool(byte[] target, int idx, boolean value) {
        target[idx] = value ? (byte)1 : 0;
    }

    public static void float4(byte[] target, int idx, float value) {
        ByteConverter.int4(target, idx, Float.floatToRawIntBits(value));
    }

    public static void float8(byte[] target, int idx, double value) {
        ByteConverter.int8(target, idx, Double.doubleToRawLongBits(value));
    }
}

