/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.geometric;

import java.awt.Point;
import java.io.Serializable;
import java.sql.SQLException;
import org.postgresql.util.ByteConverter;
import org.postgresql.util.GT;
import org.postgresql.util.PGBinaryObject;
import org.postgresql.util.PGobject;
import org.postgresql.util.PGtokenizer;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class PGpoint
extends PGobject
implements PGBinaryObject,
Serializable,
Cloneable {
    public double x;
    public double y;

    public PGpoint(double x2, double y2) {
        this();
        this.x = x2;
        this.y = y2;
    }

    public PGpoint(String value) throws SQLException {
        this();
        this.setValue(value);
    }

    public PGpoint() {
        this.setType("point");
    }

    @Override
    public void setValue(String s2) throws SQLException {
        PGtokenizer t2 = new PGtokenizer(PGtokenizer.removePara(s2), ',');
        try {
            this.x = Double.parseDouble(t2.getToken(0));
            this.y = Double.parseDouble(t2.getToken(1));
        }
        catch (NumberFormatException e2) {
            throw new PSQLException(GT.tr("Conversion to type {0} failed: {1}.", this.type, s2), PSQLState.DATA_TYPE_MISMATCH, (Throwable)e2);
        }
    }

    @Override
    public void setByteValue(byte[] b2, int offset) {
        this.x = ByteConverter.float8(b2, offset);
        this.y = ByteConverter.float8(b2, offset + 8);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PGpoint) {
            PGpoint p2 = (PGpoint)obj;
            return this.x == p2.x && this.y == p2.y;
        }
        return false;
    }

    @Override
    public int hashCode() {
        long v1 = Double.doubleToLongBits(this.x);
        long v2 = Double.doubleToLongBits(this.y);
        return (int)(v1 ^ v2 ^ v1 >>> 32 ^ v2 >>> 32);
    }

    @Override
    public String getValue() {
        return "(" + this.x + "," + this.y + ")";
    }

    @Override
    public int lengthInBytes() {
        return 16;
    }

    @Override
    public void toBytes(byte[] b2, int offset) {
        ByteConverter.float8(b2, offset, this.x);
        ByteConverter.float8(b2, offset + 8, this.y);
    }

    public void translate(int x2, int y2) {
        this.translate((double)x2, (double)y2);
    }

    public void translate(double x2, double y2) {
        this.x += x2;
        this.y += y2;
    }

    public void move(int x2, int y2) {
        this.setLocation(x2, y2);
    }

    public void move(double x2, double y2) {
        this.x = x2;
        this.y = y2;
    }

    public void setLocation(int x2, int y2) {
        this.move((double)x2, (double)y2);
    }

    public void setLocation(Point p2) {
        this.setLocation(p2.x, p2.y);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

