/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober.distributionanalysis;

public abstract class CharDistributionAnalysis {
    public static final float SURE_NO = 0.01f;
    public static final float SURE_YES = 0.99f;
    public static final int ENOUGH_DATA_THRESHOLD = 1024;
    public static final int MINIMUM_DATA_THRESHOLD = 4;
    private int freqChars;
    private int totalChars;
    protected int[] charToFreqOrder;
    protected float typicalDistributionRatio;
    protected boolean done;

    public CharDistributionAnalysis() {
        this.reset();
    }

    public void handleData(byte[] byArray, int n2, int n3) {
    }

    public void handleOneChar(byte[] byArray, int n2, int n3) {
        int n4 = -1;
        if (n3 == 2) {
            n4 = this.getOrder(byArray, n2);
        }
        if (n4 >= 0) {
            ++this.totalChars;
            if (n4 < this.charToFreqOrder.length && 512 > this.charToFreqOrder[n4]) {
                ++this.freqChars;
            }
        }
    }

    public float getConfidence() {
        float f2;
        if (this.totalChars <= 0 || this.freqChars <= 4) {
            return 0.01f;
        }
        if (this.totalChars != this.freqChars && (f2 = (float)(this.freqChars / (this.totalChars - this.freqChars)) * this.typicalDistributionRatio) < 0.99f) {
            return f2;
        }
        return 0.99f;
    }

    public void reset() {
        this.done = false;
        this.totalChars = 0;
        this.freqChars = 0;
    }

    public void setOption() {
    }

    public boolean gotEnoughData() {
        return this.totalChars > 1024;
    }

    protected abstract int getOrder(byte[] var1, int var2);
}

