/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import org.mozilla.universalchardet.Constants;
import org.mozilla.universalchardet.prober.CharsetProber;
import org.mozilla.universalchardet.prober.statemachine.CodingStateMachine;
import org.mozilla.universalchardet.prober.statemachine.SMModel;
import org.mozilla.universalchardet.prober.statemachine.UTF8SMModel;

public class UTF8Prober
extends CharsetProber {
    public static final float ONE_CHAR_PROB = 0.5f;
    private CodingStateMachine codingSM = new CodingStateMachine(smModel);
    private CharsetProber.ProbingState state;
    private int numOfMBChar = 0;
    private static final SMModel smModel = new UTF8SMModel();

    public UTF8Prober() {
        this.reset();
    }

    public String getCharSetName() {
        return Constants.CHARSET_UTF_8;
    }

    public CharsetProber.ProbingState handleData(byte[] byArray, int n2, int n3) {
        int n4 = n2 + n3;
        for (int i2 = n2; i2 < n4; ++i2) {
            int n5 = this.codingSM.nextState(byArray[i2]);
            if (n5 == 1) {
                this.state = CharsetProber.ProbingState.NOT_ME;
                break;
            }
            if (n5 == 2) {
                this.state = CharsetProber.ProbingState.FOUND_IT;
                break;
            }
            if (n5 != 0 || this.codingSM.getCurrentCharLen() < 2) continue;
            ++this.numOfMBChar;
        }
        if (this.state == CharsetProber.ProbingState.DETECTING && this.getConfidence() > 0.95f) {
            this.state = CharsetProber.ProbingState.FOUND_IT;
        }
        return this.state;
    }

    public CharsetProber.ProbingState getState() {
        return this.state;
    }

    public void reset() {
        this.codingSM.reset();
        this.numOfMBChar = 0;
        this.state = CharsetProber.ProbingState.DETECTING;
    }

    public float getConfidence() {
        float f2 = 0.99f;
        if (this.numOfMBChar < 6) {
            for (int i2 = 0; i2 < this.numOfMBChar; ++i2) {
                f2 *= 0.5f;
            }
            return 1.0f - f2;
        }
        return 0.99f;
    }

    public void setOption() {
    }
}

