/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import org.mozilla.universalchardet.prober.CharsetProber;
import org.mozilla.universalchardet.prober.sequence.SequenceModel;

public class SingleByteCharsetProber
extends CharsetProber {
    public static final int SAMPLE_SIZE = 64;
    public static final int SB_ENOUGH_REL_THRESHOLD = 1024;
    public static final float POSITIVE_SHORTCUT_THRESHOLD = 0.95f;
    public static final float NEGATIVE_SHORTCUT_THRESHOLD = 0.05f;
    public static final int SYMBOL_CAT_ORDER = 250;
    public static final int NUMBER_OF_SEQ_CAT = 4;
    public static final int POSITIVE_CAT = 3;
    public static final int NEGATIVE_CAT = 0;
    private CharsetProber.ProbingState state;
    private SequenceModel model;
    private boolean reversed;
    private short lastOrder;
    private int totalSeqs;
    private int[] seqCounters;
    private int totalChar;
    private int freqChar;
    private CharsetProber nameProber;

    public SingleByteCharsetProber(SequenceModel sequenceModel) {
        this.model = sequenceModel;
        this.reversed = false;
        this.nameProber = null;
        this.seqCounters = new int[4];
        this.reset();
    }

    public SingleByteCharsetProber(SequenceModel sequenceModel, boolean bl2, CharsetProber charsetProber) {
        this.model = sequenceModel;
        this.reversed = bl2;
        this.nameProber = charsetProber;
        this.seqCounters = new int[4];
        this.reset();
    }

    boolean keepEnglishLetters() {
        return this.model.getKeepEnglishLetter();
    }

    public String getCharSetName() {
        if (this.nameProber == null) {
            return this.model.getCharsetName();
        }
        return this.nameProber.getCharSetName();
    }

    public float getConfidence() {
        if (this.totalSeqs > 0) {
            float f2 = 1.0f * (float)this.seqCounters[3] / (float)this.totalSeqs / this.model.getTypicalPositiveRatio();
            if ((f2 = f2 * (float)this.freqChar / (float)this.totalChar) >= 1.0f) {
                f2 = 0.99f;
            }
            return f2;
        }
        return 0.01f;
    }

    public CharsetProber.ProbingState getState() {
        return this.state;
    }

    public CharsetProber.ProbingState handleData(byte[] byArray, int n2, int n3) {
        int n4 = n2 + n3;
        for (int i2 = n2; i2 < n4; ++i2) {
            short s2 = this.model.getOrder(byArray[i2]);
            if (s2 < 250) {
                ++this.totalChar;
            }
            if (s2 < 64) {
                ++this.freqChar;
                if (this.lastOrder < 64) {
                    ++this.totalSeqs;
                    if (!this.reversed) {
                        byte by = this.model.getPrecedence(this.lastOrder * 64 + s2);
                        this.seqCounters[by] = this.seqCounters[by] + 1;
                    } else {
                        byte by = this.model.getPrecedence(s2 * 64 + this.lastOrder);
                        this.seqCounters[by] = this.seqCounters[by] + 1;
                    }
                }
            }
            this.lastOrder = s2;
        }
        if (this.state == CharsetProber.ProbingState.DETECTING && this.totalSeqs > 1024) {
            float f2 = this.getConfidence();
            if (f2 > 0.95f) {
                this.state = CharsetProber.ProbingState.FOUND_IT;
            } else if (f2 < 0.05f) {
                this.state = CharsetProber.ProbingState.NOT_ME;
            }
        }
        return this.state;
    }

    public void reset() {
        this.state = CharsetProber.ProbingState.DETECTING;
        this.lastOrder = (short)255;
        for (int i2 = 0; i2 < 4; ++i2) {
            this.seqCounters[i2] = 0;
        }
        this.totalSeqs = 0;
        this.totalChar = 0;
        this.freqChar = 0;
    }

    public void setOption() {
    }
}

