/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import org.mozilla.universalchardet.prober.Big5Prober;
import org.mozilla.universalchardet.prober.CharsetProber;
import org.mozilla.universalchardet.prober.EUCJPProber;
import org.mozilla.universalchardet.prober.EUCKRProber;
import org.mozilla.universalchardet.prober.EUCTWProber;
import org.mozilla.universalchardet.prober.GB18030Prober;
import org.mozilla.universalchardet.prober.SJISProber;
import org.mozilla.universalchardet.prober.UTF8Prober;

public class MBCSGroupProber
extends CharsetProber {
    private CharsetProber.ProbingState state;
    private CharsetProber[] probers = new CharsetProber[7];
    private boolean[] isActive = new boolean[7];
    private int bestGuess;
    private int activeNum;

    public MBCSGroupProber() {
        this.probers[0] = new UTF8Prober();
        this.probers[1] = new SJISProber();
        this.probers[2] = new EUCJPProber();
        this.probers[3] = new GB18030Prober();
        this.probers[4] = new EUCKRProber();
        this.probers[5] = new Big5Prober();
        this.probers[6] = new EUCTWProber();
        this.reset();
    }

    public String getCharSetName() {
        if (this.bestGuess == -1) {
            this.getConfidence();
            if (this.bestGuess == -1) {
                this.bestGuess = 0;
            }
        }
        return this.probers[this.bestGuess].getCharSetName();
    }

    public float getConfidence() {
        float f2 = 0.0f;
        if (this.state == CharsetProber.ProbingState.FOUND_IT) {
            return 0.99f;
        }
        if (this.state == CharsetProber.ProbingState.NOT_ME) {
            return 0.01f;
        }
        for (int i2 = 0; i2 < this.probers.length; ++i2) {
            float f3;
            if (!this.isActive[i2] || !(f2 < (f3 = this.probers[i2].getConfidence()))) continue;
            f2 = f3;
            this.bestGuess = i2;
        }
        return f2;
    }

    public CharsetProber.ProbingState getState() {
        return this.state;
    }

    public CharsetProber.ProbingState handleData(byte[] byArray, int n2, int n3) {
        int n4;
        boolean bl2 = true;
        byte[] byArray2 = new byte[n3];
        int n5 = 0;
        int n6 = n2 + n3;
        for (n4 = n2; n4 < n6; ++n4) {
            if ((byArray[n4] & 0x80) != 0) {
                byArray2[n5++] = byArray[n4];
                bl2 = true;
                continue;
            }
            if (!bl2) continue;
            byArray2[n5++] = byArray[n4];
            bl2 = false;
        }
        for (n4 = 0; n4 < this.probers.length; ++n4) {
            if (!this.isActive[n4]) continue;
            CharsetProber.ProbingState probingState = this.probers[n4].handleData(byArray2, 0, n5);
            if (probingState == CharsetProber.ProbingState.FOUND_IT) {
                this.bestGuess = n4;
                this.state = CharsetProber.ProbingState.FOUND_IT;
                break;
            }
            if (probingState != CharsetProber.ProbingState.NOT_ME) continue;
            this.isActive[n4] = false;
            --this.activeNum;
            if (this.activeNum > 0) continue;
            this.state = CharsetProber.ProbingState.NOT_ME;
            break;
        }
        return this.state;
    }

    public void reset() {
        this.activeNum = 0;
        for (int i2 = 0; i2 < this.probers.length; ++i2) {
            this.probers[i2].reset();
            this.isActive[i2] = true;
            ++this.activeNum;
        }
        this.bestGuess = -1;
        this.state = CharsetProber.ProbingState.DETECTING;
    }

    public void setOption() {
    }
}

