/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import org.mozilla.universalchardet.Constants;
import org.mozilla.universalchardet.prober.CharsetProber;

public class HebrewProber
extends CharsetProber {
    public static final int FINAL_KAF = 234;
    public static final int NORMAL_KAF = 235;
    public static final int FINAL_MEM = 237;
    public static final int NORMAL_MEM = 238;
    public static final int FINAL_NUN = 239;
    public static final int NORMAL_NUN = 240;
    public static final int FINAL_PE = 243;
    public static final int NORMAL_PE = 244;
    public static final int FINAL_TSADI = 245;
    public static final int NORMAL_TSADI = 246;
    public static final byte SPACE = 32;
    public static final int MIN_FINAL_CHAR_DISTANCE = 5;
    public static final float MIN_MODEL_DISTANCE = 0.01f;
    private int finalCharLogicalScore;
    private int finalCharVisualScore;
    private byte prev;
    private byte beforePrev;
    private CharsetProber logicalProber = null;
    private CharsetProber visualProber = null;

    public HebrewProber() {
        this.reset();
    }

    public void setModalProbers(CharsetProber charsetProber, CharsetProber charsetProber2) {
        this.logicalProber = charsetProber;
        this.visualProber = charsetProber2;
    }

    public String getCharSetName() {
        int n2 = this.finalCharLogicalScore - this.finalCharVisualScore;
        if (n2 >= 5) {
            return Constants.CHARSET_WINDOWS_1255;
        }
        if (n2 <= -5) {
            return Constants.CHARSET_ISO_8859_8;
        }
        float f2 = this.logicalProber.getConfidence() - this.visualProber.getConfidence();
        if (f2 > 0.01f) {
            return Constants.CHARSET_WINDOWS_1255;
        }
        if (f2 < -0.01f) {
            return Constants.CHARSET_ISO_8859_8;
        }
        if (n2 < 0) {
            return Constants.CHARSET_ISO_8859_8;
        }
        return Constants.CHARSET_WINDOWS_1255;
    }

    public float getConfidence() {
        return 0.0f;
    }

    public CharsetProber.ProbingState getState() {
        if (this.logicalProber.getState() == CharsetProber.ProbingState.NOT_ME && this.visualProber.getState() == CharsetProber.ProbingState.NOT_ME) {
            return CharsetProber.ProbingState.NOT_ME;
        }
        return CharsetProber.ProbingState.DETECTING;
    }

    public CharsetProber.ProbingState handleData(byte[] byArray, int n2, int n3) {
        if (this.getState() == CharsetProber.ProbingState.NOT_ME) {
            return CharsetProber.ProbingState.NOT_ME;
        }
        int n4 = n2 + n3;
        for (int i2 = n2; i2 < n4; ++i2) {
            byte by = byArray[i2];
            if (by == 32) {
                if (this.beforePrev != 32) {
                    if (HebrewProber.isFinal(this.prev)) {
                        ++this.finalCharLogicalScore;
                    } else if (HebrewProber.isNonFinal(this.prev)) {
                        ++this.finalCharVisualScore;
                    }
                }
            } else if (this.beforePrev == 32 && HebrewProber.isFinal(this.prev) && by != 32) {
                ++this.finalCharVisualScore;
            }
            this.beforePrev = this.prev;
            this.prev = by;
        }
        return CharsetProber.ProbingState.DETECTING;
    }

    public void reset() {
        this.finalCharLogicalScore = 0;
        this.finalCharVisualScore = 0;
        this.prev = (byte)32;
        this.beforePrev = (byte)32;
    }

    public void setOption() {
    }

    protected static boolean isFinal(byte by) {
        int n2 = by & 0xFF;
        return n2 == 234 || n2 == 237 || n2 == 239 || n2 == 243 || n2 == 245;
    }

    protected static boolean isNonFinal(byte by) {
        int n2 = by & 0xFF;
        return n2 == 235 || n2 == 238 || n2 == 240 || n2 == 244;
    }
}

