/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import org.mozilla.universalchardet.prober.CharsetProber;
import org.mozilla.universalchardet.prober.statemachine.CodingStateMachine;
import org.mozilla.universalchardet.prober.statemachine.HZSMModel;
import org.mozilla.universalchardet.prober.statemachine.ISO2022CNSMModel;
import org.mozilla.universalchardet.prober.statemachine.ISO2022JPSMModel;
import org.mozilla.universalchardet.prober.statemachine.ISO2022KRSMModel;

public class EscCharsetProber
extends CharsetProber {
    private CodingStateMachine[] codingSM = new CodingStateMachine[4];
    private int activeSM;
    private CharsetProber.ProbingState state;
    private String detectedCharset;
    private static final HZSMModel hzsModel = new HZSMModel();
    private static final ISO2022CNSMModel iso2022cnModel = new ISO2022CNSMModel();
    private static final ISO2022JPSMModel iso2022jpModel = new ISO2022JPSMModel();
    private static final ISO2022KRSMModel iso2022krModel = new ISO2022KRSMModel();

    public EscCharsetProber() {
        this.codingSM[0] = new CodingStateMachine(hzsModel);
        this.codingSM[1] = new CodingStateMachine(iso2022cnModel);
        this.codingSM[2] = new CodingStateMachine(iso2022jpModel);
        this.codingSM[3] = new CodingStateMachine(iso2022krModel);
        this.reset();
    }

    public String getCharSetName() {
        return this.detectedCharset;
    }

    public float getConfidence() {
        return 0.99f;
    }

    public CharsetProber.ProbingState getState() {
        return this.state;
    }

    public CharsetProber.ProbingState handleData(byte[] byArray, int n2, int n3) {
        int n4 = n2 + n3;
        for (int i2 = n2; i2 < n4 && this.state == CharsetProber.ProbingState.DETECTING; ++i2) {
            for (int i3 = this.activeSM - 1; i3 >= 0; --i3) {
                int n5 = this.codingSM[i3].nextState(byArray[i2]);
                if (n5 == 1) {
                    --this.activeSM;
                    if (this.activeSM <= 0) {
                        this.state = CharsetProber.ProbingState.NOT_ME;
                        return this.state;
                    }
                    if (i3 == this.activeSM) continue;
                    CodingStateMachine codingStateMachine = this.codingSM[this.activeSM];
                    this.codingSM[this.activeSM] = this.codingSM[i3];
                    this.codingSM[i3] = codingStateMachine;
                    continue;
                }
                if (n5 != 2) continue;
                this.state = CharsetProber.ProbingState.FOUND_IT;
                this.detectedCharset = this.codingSM[i3].getCodingStateMachine();
                return this.state;
            }
        }
        return this.state;
    }

    public void reset() {
        this.state = CharsetProber.ProbingState.DETECTING;
        for (int i2 = 0; i2 < this.codingSM.length; ++i2) {
            this.codingSM[i2].reset();
        }
        this.activeSM = this.codingSM.length;
        this.detectedCharset = null;
    }

    public void setOption() {
    }
}

