/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import java.nio.ByteBuffer;

public abstract class CharsetProber {
    public static final float SHORTCUT_THRESHOLD = 0.95f;
    public static final int ASCII_A = 97;
    public static final int ASCII_Z = 122;
    public static final int ASCII_A_CAPITAL = 65;
    public static final int ASCII_Z_CAPITAL = 90;
    public static final int ASCII_LT = 60;
    public static final int ASCII_GT = 62;
    public static final int ASCII_SP = 32;

    public abstract String getCharSetName();

    public abstract ProbingState handleData(byte[] var1, int var2, int var3);

    public abstract ProbingState getState();

    public abstract void reset();

    public abstract float getConfidence();

    public abstract void setOption();

    public ByteBuffer filterWithoutEnglishLetters(byte[] byArray, int n2, int n3) {
        int n4;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n3);
        boolean bl2 = false;
        int n5 = n2;
        int n6 = n2 + n3;
        for (n4 = n2; n4 < n6; ++n4) {
            byte by = byArray[n4];
            if (!this.isAscii(by)) {
                bl2 = true;
                continue;
            }
            if (!this.isAsciiSymbol(by)) continue;
            if (bl2 && n4 > n5) {
                byteBuffer.put(byArray, n5, n4 - n5);
                byteBuffer.put((byte)32);
                n5 = n4 + 1;
                bl2 = false;
                continue;
            }
            n5 = n4 + 1;
        }
        if (bl2 && n4 > n5) {
            byteBuffer.put(byArray, n5, n4 - n5);
        }
        return byteBuffer;
    }

    public ByteBuffer filterWithEnglishLetters(byte[] byArray, int n2, int n3) {
        int n4;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n3);
        boolean bl2 = false;
        int n5 = n2;
        int n6 = n2 + n3;
        for (n4 = n2; n4 < n6; ++n4) {
            byte by = byArray[n4];
            if (by == 62) {
                bl2 = false;
            } else if (by == 60) {
                bl2 = true;
            }
            if (!this.isAscii(by) || !this.isAsciiSymbol(by)) continue;
            if (n4 > n5 && !bl2) {
                byteBuffer.put(byArray, n5, n4 - n5);
                byteBuffer.put((byte)32);
                n5 = n4 + 1;
                continue;
            }
            n5 = n4 + 1;
        }
        if (!bl2 && n4 > n5) {
            byteBuffer.put(byArray, n5, n4 - n5);
        }
        return byteBuffer;
    }

    private boolean isAscii(byte by) {
        return (by & 0x80) == 0;
    }

    private boolean isAsciiSymbol(byte by) {
        int n2 = by & 0xFF;
        return n2 < 65 || n2 > 90 && n2 < 97 || n2 > 122;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProbingState {
        DETECTING,
        FOUND_IT,
        NOT_ME;

    }
}

