/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet;

import java.io.FileInputStream;
import org.mozilla.universalchardet.CharsetListener;
import org.mozilla.universalchardet.Constants;
import org.mozilla.universalchardet.prober.CharsetProber;
import org.mozilla.universalchardet.prober.EscCharsetProber;
import org.mozilla.universalchardet.prober.Latin1Prober;
import org.mozilla.universalchardet.prober.MBCSGroupProber;
import org.mozilla.universalchardet.prober.SBCSGroupProber;

public class UniversalDetector {
    public static final float SHORTCUT_THRESHOLD = 0.95f;
    public static final float MINIMUM_THRESHOLD = 0.2f;
    private InputState inputState;
    private boolean done;
    private boolean start;
    private boolean gotData;
    private byte lastChar;
    private String detectedCharset;
    private CharsetProber[] probers;
    private CharsetProber escCharsetProber;
    private CharsetListener listener;

    public UniversalDetector(CharsetListener charsetListener) {
        this.listener = charsetListener;
        this.escCharsetProber = null;
        this.probers = new CharsetProber[3];
        for (int i2 = 0; i2 < this.probers.length; ++i2) {
            this.probers[i2] = null;
        }
        this.reset();
    }

    public boolean isDone() {
        return this.done;
    }

    public String getDetectedCharset() {
        return this.detectedCharset;
    }

    public void setListener(CharsetListener charsetListener) {
        this.listener = charsetListener;
    }

    public CharsetListener getListener() {
        return this.listener;
    }

    public void handleData(byte[] byArray, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        if (this.done) {
            return;
        }
        if (n3 > 0) {
            this.gotData = true;
        }
        if (this.start) {
            this.start = false;
            if (n3 > 3) {
                n6 = byArray[n2] & 0xFF;
                n5 = byArray[n2 + 1] & 0xFF;
                n4 = byArray[n2 + 2] & 0xFF;
                int n7 = byArray[n2 + 3] & 0xFF;
                switch (n6) {
                    case 239: {
                        if (n5 != 187 || n4 != 191) break;
                        this.detectedCharset = Constants.CHARSET_UTF_8;
                        break;
                    }
                    case 254: {
                        if (n5 == 255 && n4 == 0 && n7 == 0) {
                            this.detectedCharset = Constants.CHARSET_X_ISO_10646_UCS_4_3412;
                            break;
                        }
                        if (n5 != 255) break;
                        this.detectedCharset = Constants.CHARSET_UTF_16BE;
                        break;
                    }
                    case 0: {
                        if (n5 == 0 && n4 == 254 && n7 == 255) {
                            this.detectedCharset = Constants.CHARSET_UTF_32BE;
                            break;
                        }
                        if (n5 != 0 || n4 != 255 || n7 != 254) break;
                        this.detectedCharset = Constants.CHARSET_X_ISO_10646_UCS_4_2143;
                        break;
                    }
                    case 255: {
                        if (n5 == 254 && n4 == 0 && n7 == 0) {
                            this.detectedCharset = Constants.CHARSET_UTF_32LE;
                            break;
                        }
                        if (n5 != 254) break;
                        this.detectedCharset = Constants.CHARSET_UTF_16LE;
                    }
                }
                if (this.detectedCharset != null) {
                    this.done = true;
                    return;
                }
            }
        }
        n6 = n2 + n3;
        for (n5 = n2; n5 < n6; ++n5) {
            n4 = byArray[n5] & 0xFF;
            if ((n4 & 0x80) != 0 && n4 != 160) {
                if (this.inputState == InputState.HIGHBYTE) continue;
                this.inputState = InputState.HIGHBYTE;
                if (this.escCharsetProber != null) {
                    this.escCharsetProber = null;
                }
                if (this.probers[0] == null) {
                    this.probers[0] = new MBCSGroupProber();
                }
                if (this.probers[1] == null) {
                    this.probers[1] = new SBCSGroupProber();
                }
                if (this.probers[2] != null) continue;
                this.probers[2] = new Latin1Prober();
                continue;
            }
            if (this.inputState == InputState.PURE_ASCII && (n4 == 27 || n4 == 123 && this.lastChar == 126)) {
                this.inputState = InputState.ESC_ASCII;
            }
            this.lastChar = byArray[n5];
        }
        if (this.inputState == InputState.ESC_ASCII) {
            CharsetProber.ProbingState probingState;
            if (this.escCharsetProber == null) {
                this.escCharsetProber = new EscCharsetProber();
            }
            if ((probingState = this.escCharsetProber.handleData(byArray, n2, n3)) == CharsetProber.ProbingState.FOUND_IT) {
                this.done = true;
                this.detectedCharset = this.escCharsetProber.getCharSetName();
            }
        } else if (this.inputState == InputState.HIGHBYTE) {
            for (n4 = 0; n4 < this.probers.length; ++n4) {
                CharsetProber.ProbingState probingState = this.probers[n4].handleData(byArray, n2, n3);
                if (probingState != CharsetProber.ProbingState.FOUND_IT) continue;
                this.done = true;
                this.detectedCharset = this.probers[n4].getCharSetName();
                return;
            }
        }
    }

    public void dataEnd() {
        if (!this.gotData) {
            return;
        }
        if (this.detectedCharset != null) {
            this.done = true;
            if (this.listener != null) {
                this.listener.report(this.detectedCharset);
            }
            return;
        }
        if (this.inputState == InputState.HIGHBYTE) {
            float f2 = 0.0f;
            int n2 = 0;
            for (int i2 = 0; i2 < this.probers.length; ++i2) {
                float f3 = this.probers[i2].getConfidence();
                if (!(f3 > f2)) continue;
                f2 = f3;
                n2 = i2;
            }
            if (f2 > 0.2f) {
                this.detectedCharset = this.probers[n2].getCharSetName();
                if (this.listener != null) {
                    this.listener.report(this.detectedCharset);
                }
            }
        } else if (this.inputState == InputState.ESC_ASCII) {
            // empty if block
        }
    }

    public void reset() {
        this.done = false;
        this.start = true;
        this.detectedCharset = null;
        this.gotData = false;
        this.inputState = InputState.PURE_ASCII;
        this.lastChar = 0;
        if (this.escCharsetProber != null) {
            this.escCharsetProber.reset();
        }
        for (int i2 = 0; i2 < this.probers.length; ++i2) {
            if (this.probers[i2] == null) continue;
            this.probers[i2].reset();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        int n2;
        if (stringArray.length != 1) {
            System.out.println("USAGE: java UniversalDetector filename");
            return;
        }
        UniversalDetector universalDetector = new UniversalDetector(new CharsetListener(){

            public void report(String string) {
                System.out.println("charset = " + string);
            }
        });
        byte[] byArray = new byte[4096];
        FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
        while ((n2 = fileInputStream.read(byArray)) > 0 && !universalDetector.isDone()) {
            universalDetector.handleData(byArray, 0, n2);
        }
        universalDetector.dataEnd();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InputState {
        PURE_ASCII,
        ESC_ASCII,
        HIGHBYTE;

    }
}

