/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.io.output;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.DeflaterOutputStream;
import org.mariadb.jdbc.internal.io.TraceObject;
import org.mariadb.jdbc.internal.io.output.AbstractPacketOutputStream;
import org.mariadb.jdbc.internal.logging.Logger;
import org.mariadb.jdbc.internal.logging.LoggerFactory;
import org.mariadb.jdbc.internal.util.Utils;

public class CompressPacketOutputStream
extends AbstractPacketOutputStream {
    private static final Logger logger = LoggerFactory.getLogger(CompressPacketOutputStream.class);
    private static final int MAX_PACKET_LENGTH = 0xFFFFFF;
    private static final byte[] EMPTY_ARRAY = new byte[0];
    private static final int MIN_COMPRESSION_SIZE = 100;
    private static final float MIN_COMPRESSION_RATIO = 0.9f;
    private final byte[] header = new byte[7];
    private final byte[] subHeader = new byte[4];
    private int maxPacketLength = 0xFFFFFF;
    private int compressSeqNo;
    private byte[] remainingData = new byte[0];
    private boolean lastPacketExactMaxPacketLength = false;

    public CompressPacketOutputStream(OutputStream out, int maxQuerySizeToLog, long threadId) {
        super(out, maxQuerySizeToLog, threadId);
    }

    @Override
    public int getMaxPacketLength() {
        return this.maxPacketLength;
    }

    @Override
    public void setMaxAllowedPacket(int maxAllowedPacket) {
        this.maxAllowedPacket = maxAllowedPacket;
        this.maxPacketLength = Math.min(0xFFFFFF, maxAllowedPacket + 7);
    }

    @Override
    public void startPacket(int compressSeqNo) {
        this.compressSeqNo = compressSeqNo;
        this.seqNo = 0;
        this.pos = 0;
        this.cmdLength = 0L;
        this.remainingData = EMPTY_ARRAY;
        this.lastPacketExactMaxPacketLength = false;
    }

    @Override
    public int initialPacketPos() {
        return 0;
    }

    @Override
    protected void flushBuffer(boolean commandEnd) throws IOException {
        DeflaterOutputStream deflater;
        ByteArrayOutputStream baos;
        int uncompressSize;
        if (this.pos > 0) {
            if (this.pos + this.remainingData.length > 100) {
                uncompressSize = Math.min(0xFFFFFF, this.remainingData.length + 4 + this.pos);
                this.checkMaxAllowedLength(uncompressSize);
                baos = new ByteArrayOutputStream();
                try {
                    deflater = new DeflaterOutputStream(baos);
                    try {
                        if (this.remainingData.length != 0) {
                            deflater.write(this.remainingData);
                        }
                        this.subHeader[0] = (byte)this.pos;
                        this.subHeader[1] = (byte)(this.pos >>> 8);
                        this.subHeader[2] = (byte)(this.pos >>> 16);
                        this.subHeader[3] = (byte)this.seqNo++;
                        deflater.write(this.subHeader, 0, 4);
                        deflater.write(this.buf, 0, uncompressSize - (this.remainingData.length + 4));
                        deflater.finish();
                    }
                    finally {
                        deflater.close();
                    }
                    byte[] compressedBytes = baos.toByteArray();
                    if (compressedBytes.length < (int)(0.9f * (float)this.pos)) {
                        int compressedLength = compressedBytes.length;
                        this.header[0] = (byte)compressedLength;
                        this.header[1] = (byte)(compressedLength >>> 8);
                        this.header[2] = (byte)(compressedLength >>> 16);
                        this.header[3] = (byte)this.compressSeqNo++;
                        this.header[4] = (byte)uncompressSize;
                        this.header[5] = (byte)(uncompressSize >>> 8);
                        this.header[6] = (byte)(uncompressSize >>> 16);
                        this.out.write(this.header, 0, 7);
                        this.out.write(compressedBytes, 0, compressedLength);
                        this.cmdLength += (long)uncompressSize;
                        if (this.traceCache != null) {
                            if (this.remainingData.length != 0) {
                                this.traceCache.put(new TraceObject(true, 1, this.threadId, Arrays.copyOfRange(this.header, 0, 7), Arrays.copyOfRange(this.remainingData, 0, this.remainingData.length), Arrays.copyOfRange(this.subHeader, 0, 4), Arrays.copyOfRange(this.buf, 0, (uncompressSize > 1000 ? 1000 : uncompressSize) - (this.remainingData.length + 4))));
                            } else {
                                this.traceCache.put(new TraceObject(true, 1, this.threadId, Arrays.copyOfRange(this.header, 0, 7), Arrays.copyOfRange(this.subHeader, 0, 4), Arrays.copyOfRange(this.buf, 0, (uncompressSize > 1000 ? 1000 : uncompressSize) - (this.remainingData.length + 4))));
                            }
                        }
                        if (logger.isTraceEnabled()) {
                            if (this.remainingData.length != 0) {
                                logger.trace("send compress: {}{}", (Object)this.serverThreadLog, (Object)Utils.hexdump(this.maxQuerySizeToLog - (this.remainingData.length + 11), 0, compressedLength, (byte[][])new byte[][]{this.header, this.remainingData, this.subHeader, this.buf}));
                            } else {
                                logger.trace("send compress: {}{}", (Object)this.serverThreadLog, (Object)Utils.hexdump(this.maxQuerySizeToLog - 11, 0, compressedLength, (byte[][])new byte[][]{this.header, this.subHeader, this.buf}));
                            }
                        }
                        this.remainingData = this.pos + this.remainingData.length + 4 - uncompressSize > 0 ? Arrays.copyOfRange(this.buf, uncompressSize - (this.remainingData.length + 4), this.pos) : EMPTY_ARRAY;
                        boolean bl2 = this.lastPacketExactMaxPacketLength = this.pos == 0xFFFFFF;
                        if (commandEnd && this.lastPacketExactMaxPacketLength) {
                            this.writeEmptyPacket();
                        }
                        this.pos = 0;
                        return;
                    }
                    --this.seqNo;
                }
                finally {
                    baos.close();
                }
            }
            int uncompressSize2 = Math.min(0xFFFFFF, this.remainingData.length + 4 + this.pos);
            this.checkMaxAllowedLength(uncompressSize2);
            this.cmdLength += (long)uncompressSize2;
            this.header[0] = (byte)uncompressSize2;
            this.header[1] = (byte)(uncompressSize2 >>> 8);
            this.header[2] = (byte)(uncompressSize2 >>> 16);
            this.header[3] = (byte)this.compressSeqNo++;
            this.header[4] = 0;
            this.header[5] = 0;
            this.header[6] = 0;
            this.out.write(this.header, 0, 7);
            this.cmdLength += (long)uncompressSize2;
            if (this.remainingData.length != 0) {
                this.out.write(this.remainingData);
            }
            this.subHeader[0] = (byte)this.pos;
            this.subHeader[1] = (byte)(this.pos >>> 8);
            this.subHeader[2] = (byte)(this.pos >>> 16);
            this.subHeader[3] = (byte)this.seqNo++;
            this.out.write(this.subHeader, 0, 4);
            this.out.write(this.buf, 0, uncompressSize2 - (this.remainingData.length + 4));
            this.cmdLength += (long)this.remainingData.length;
            if (this.traceCache != null) {
                if (this.remainingData.length != 0) {
                    this.traceCache.put(new TraceObject(true, 2, this.threadId, Arrays.copyOfRange(this.header, 0, 7), Arrays.copyOfRange(this.remainingData, 0, this.remainingData.length), Arrays.copyOfRange(this.subHeader, 0, 4), Arrays.copyOfRange(this.buf, 0, (uncompressSize2 > 1000 ? 1000 : uncompressSize2) - (this.remainingData.length + 4))));
                } else {
                    this.traceCache.put(new TraceObject(true, 2, this.threadId, Arrays.copyOfRange(this.header, 0, 7), Arrays.copyOfRange(this.subHeader, 0, 4), Arrays.copyOfRange(this.buf, 0, (uncompressSize2 > 1000 ? 1000 : uncompressSize2) - (this.remainingData.length + 4))));
                }
            }
            if (logger.isTraceEnabled()) {
                if (this.remainingData.length != 0) {
                    logger.trace("send uncompress: {}{}", (Object)this.serverThreadLog, (Object)Utils.hexdump(this.maxQuerySizeToLog - (this.remainingData.length + 11), 0, this.pos, (byte[][])new byte[][]{this.header, this.remainingData, this.subHeader, this.buf}));
                } else {
                    logger.trace("send uncompress: {}{}", (Object)this.serverThreadLog, (Object)Utils.hexdump(this.maxQuerySizeToLog - 11, 0, this.pos + 4, (byte[][])new byte[][]{this.header, this.subHeader, this.buf}));
                }
            }
            this.remainingData = this.pos + this.remainingData.length + 4 - uncompressSize2 > 0 ? Arrays.copyOfRange(this.buf, uncompressSize2 - (this.remainingData.length + 4), this.pos) : EMPTY_ARRAY;
            this.lastPacketExactMaxPacketLength = this.pos == 0xFFFFFF;
            this.pos = 0;
        }
        if (this.remainingData.length > 0) {
            if (this.remainingData.length > 100) {
                byte[] compressedBytes;
                uncompressSize = Math.min(0xFFFFFF, this.remainingData.length);
                this.checkMaxAllowedLength(uncompressSize);
                this.cmdLength += (long)uncompressSize;
                baos = new ByteArrayOutputStream();
                try {
                    deflater = new DeflaterOutputStream(baos);
                    try {
                        deflater.write(this.remainingData);
                        deflater.finish();
                    }
                    finally {
                        deflater.close();
                    }
                    compressedBytes = baos.toByteArray();
                    this.remainingData = EMPTY_ARRAY;
                }
                finally {
                    baos.close();
                }
                if (compressedBytes.length < (int)(0.9f * (float)this.pos)) {
                    int compressedLength = compressedBytes.length;
                    this.header[0] = (byte)compressedLength;
                    this.header[1] = (byte)(compressedLength >>> 8);
                    this.header[2] = (byte)(compressedLength >>> 16);
                    this.header[3] = (byte)this.compressSeqNo++;
                    this.header[4] = (byte)uncompressSize;
                    this.header[5] = (byte)(uncompressSize >>> 8);
                    this.header[6] = (byte)(uncompressSize >>> 16);
                    this.out.write(this.header, 0, 7);
                    this.out.write(compressedBytes, 0, compressedLength);
                    if (this.traceCache != null) {
                        this.traceCache.put(new TraceObject(true, 1, this.threadId, Arrays.copyOfRange(this.header, 0, 7), Arrays.copyOfRange(this.remainingData, 0, uncompressSize > 1000 ? 1000 : uncompressSize)));
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("send compress: {}{}", (Object)this.serverThreadLog, (Object)Utils.hexdump(this.maxQuerySizeToLog - 7, 0, uncompressSize, (byte[][])new byte[][]{this.header, this.remainingData}));
                    }
                    if (commandEnd && this.lastPacketExactMaxPacketLength) {
                        this.writeEmptyPacket();
                    }
                    return;
                }
            }
            int uncompressSize3 = Math.min(0xFFFFFF, this.remainingData.length);
            this.checkMaxAllowedLength(uncompressSize3);
            this.cmdLength += (long)uncompressSize3;
            this.header[0] = (byte)uncompressSize3;
            this.header[1] = (byte)(uncompressSize3 >>> 8);
            this.header[2] = (byte)(uncompressSize3 >>> 16);
            this.header[3] = (byte)this.compressSeqNo++;
            this.header[4] = 0;
            this.header[5] = 0;
            this.header[6] = 0;
            this.out.write(this.header, 0, 7);
            this.out.write(this.remainingData);
            this.remainingData = EMPTY_ARRAY;
            if (this.traceCache != null) {
                this.traceCache.put(new TraceObject(true, 2, this.threadId, Arrays.copyOfRange(this.header, 0, 7), Arrays.copyOfRange(this.remainingData, 0, this.remainingData.length > 1000 ? 1000 : this.remainingData.length)));
            }
            if (logger.isTraceEnabled()) {
                logger.trace("send uncompress: {}{}", (Object)this.serverThreadLog, (Object)Utils.hexdump(this.maxQuerySizeToLog - 7, 0, this.remainingData.length, (byte[][])new byte[][]{this.header, this.remainingData}));
            }
            if (commandEnd && this.lastPacketExactMaxPacketLength) {
                this.writeEmptyPacket();
            }
        }
    }

    @Override
    public void writeEmptyPacket() throws IOException {
        this.buf[0] = 4;
        this.buf[1] = 0;
        this.buf[2] = 0;
        this.buf[3] = (byte)this.compressSeqNo++;
        this.buf[4] = 0;
        this.buf[5] = 0;
        this.buf[6] = 0;
        this.buf[7] = 0;
        this.buf[8] = 0;
        this.buf[9] = 0;
        this.buf[10] = (byte)this.seqNo++;
        this.out.write(this.buf, 0, 11);
        if (this.traceCache != null) {
            this.traceCache.put(new TraceObject(true, 2, this.threadId, new byte[][]{Arrays.copyOfRange(this.buf, 0, 11)}));
        }
        if (logger.isTraceEnabled()) {
            logger.trace("send uncompress:{}{}", (Object)this.serverThreadLog, (Object)Utils.hexdump(this.maxQuerySizeToLog, 0, 11, (byte[][])new byte[][]{this.buf}));
        }
    }
}

