/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.com.send;

import java.io.IOException;
import java.sql.SQLException;
import org.mariadb.jdbc.internal.com.read.Buffer;
import org.mariadb.jdbc.internal.com.read.ErrorPacket;
import org.mariadb.jdbc.internal.com.read.resultset.ColumnDefinition;
import org.mariadb.jdbc.internal.io.input.PacketInputStream;
import org.mariadb.jdbc.internal.io.output.PacketOutputStream;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.util.dao.ServerPrepareResult;

public class ComStmtPrepare {
    private final Protocol protocol;
    private final String sql;

    public ComStmtPrepare(Protocol protocol, String sql) {
        this.protocol = protocol;
        this.sql = sql;
    }

    public ComStmtPrepare send(PacketOutputStream pos) throws IOException {
        pos.startPacket(0);
        pos.write(22);
        pos.write(this.sql);
        pos.flush();
        return this;
    }

    public ServerPrepareResult read(PacketInputStream reader, boolean eofDeprecated) throws IOException, SQLException {
        Buffer buffer = reader.getPacket(true);
        byte firstByte = buffer.getByteAt(buffer.position);
        if (firstByte == -1) {
            throw this.buildErrorException(buffer);
        }
        if (firstByte == 0) {
            int i2;
            buffer.readByte();
            int statementId = buffer.readInt();
            int numColumns = buffer.readShort() & 0xFFFF;
            int numParams = buffer.readShort() & 0xFFFF;
            ColumnDefinition[] params = new ColumnDefinition[numParams];
            ColumnDefinition[] columns = new ColumnDefinition[numColumns];
            if (numParams > 0) {
                for (i2 = 0; i2 < numParams; ++i2) {
                    params[i2] = new ColumnDefinition(reader.getPacket(false));
                }
                if (numColumns > 0) {
                    if (!eofDeprecated) {
                        this.protocol.skipEofPacket();
                    }
                    for (i2 = 0; i2 < numColumns; ++i2) {
                        columns[i2] = new ColumnDefinition(reader.getPacket(false));
                    }
                }
                if (!eofDeprecated) {
                    this.protocol.readEofPacket();
                }
            } else if (numColumns > 0) {
                for (i2 = 0; i2 < numColumns; ++i2) {
                    columns[i2] = new ColumnDefinition(reader.getPacket(false));
                }
                if (!eofDeprecated) {
                    this.protocol.readEofPacket();
                }
            } else {
                buffer.readByte();
                this.protocol.setHasWarnings(buffer.readShort() > 0);
            }
            ServerPrepareResult serverPrepareResult = new ServerPrepareResult(this.sql, statementId, columns, params, this.protocol);
            if (this.protocol.getOptions().cachePrepStmts && this.protocol.getOptions().useServerPrepStmts && this.sql != null && this.sql.length() < this.protocol.getOptions().prepStmtCacheSqlLimit) {
                String key = this.protocol.getDatabase() + "-" + this.sql;
                ServerPrepareResult cachedServerPrepareResult = this.protocol.putInCache(key, serverPrepareResult);
                return cachedServerPrepareResult != null ? cachedServerPrepareResult : serverPrepareResult;
            }
            return serverPrepareResult;
        }
        throw new SQLException("Unexpected packet returned by server, first byte " + firstByte);
    }

    private SQLException buildErrorException(Buffer buffer) {
        ErrorPacket ep = new ErrorPacket(buffer);
        String message = ep.getMessage();
        if (1054 == ep.getErrorCode()) {
            return new SQLException(message + "\nIf column exists but type cannot be identified (example 'select ? `field1` from dual'). Use CAST function to solve this problem (example 'select CAST(? as integer) `field1` from dual')", ep.getSqlState(), ep.getErrorCode());
        }
        return new SQLException(message, ep.getSqlState(), ep.getErrorCode());
    }
}

