/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.com.send;

import java.io.IOException;
import org.mariadb.jdbc.internal.ColumnType;
import org.mariadb.jdbc.internal.com.send.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.io.output.PacketOutputStream;

public class ComStmtExecute {
    public static void writeCmd(int statementId, ParameterHolder[] parameters, int parameterCount, ColumnType[] parameterTypeHeader, PacketOutputStream pos, byte cursorFlag) throws IOException {
        pos.write(23);
        pos.writeInt(statementId);
        pos.write(cursorFlag);
        pos.writeInt(1);
        if (parameterCount > 0) {
            int i2;
            int nullCount = (parameterCount + 7) / 8;
            byte[] nullBitsBuffer = new byte[nullCount];
            for (int i3 = 0; i3 < parameterCount; ++i3) {
                if (!parameters[i3].isNullData()) continue;
                int n2 = i3 / 8;
                nullBitsBuffer[n2] = (byte)(nullBitsBuffer[n2] | 1 << i3 % 8);
            }
            pos.write(nullBitsBuffer, 0, nullCount);
            boolean mustSendHeaderType = false;
            if (parameterTypeHeader[0] == null) {
                mustSendHeaderType = true;
            } else {
                for (i2 = 0; i2 < parameterCount; ++i2) {
                    if (parameterTypeHeader[i2].equals((Object)parameters[i2].getColumnType())) continue;
                    mustSendHeaderType = true;
                    break;
                }
            }
            if (mustSendHeaderType) {
                pos.write(1);
                for (i2 = 0; i2 < parameterCount; ++i2) {
                    parameterTypeHeader[i2] = parameters[i2].getColumnType();
                    pos.writeShort(parameterTypeHeader[i2].getType());
                }
            } else {
                pos.write(0);
            }
        }
        for (int i4 = 0; i4 < parameterCount; ++i4) {
            ParameterHolder holder = parameters[i4];
            if (holder.isNullData() || holder.canBeLongData()) continue;
            holder.writeBinary(pos);
        }
    }

    public static void send(PacketOutputStream pos, int statementId, ParameterHolder[] parameters, int parameterCount, ColumnType[] parameterTypeHeader, byte cursorFlag) throws IOException {
        pos.startPacket(0);
        ComStmtExecute.writeCmd(statementId, parameters, parameterCount, parameterTypeHeader, pos, cursorFlag);
        pos.flush();
    }
}

