/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.com.read.resultset;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.mariadb.jdbc.BasePrepareStatement;
import org.mariadb.jdbc.ClientSidePreparedStatement;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.ServerSidePreparedStatement;
import org.mariadb.jdbc.internal.ColumnType;
import org.mariadb.jdbc.internal.com.read.dao.Results;
import org.mariadb.jdbc.internal.com.read.resultset.ColumnDefinition;
import org.mariadb.jdbc.internal.com.read.resultset.SelectResultSet;
import org.mariadb.jdbc.internal.com.read.resultset.UpdatableColumnDefinition;
import org.mariadb.jdbc.internal.com.read.resultset.rowprotocol.BinaryRowProtocol;
import org.mariadb.jdbc.internal.com.send.parameters.BigDecimalParameter;
import org.mariadb.jdbc.internal.com.send.parameters.ByteArrayParameter;
import org.mariadb.jdbc.internal.com.send.parameters.ByteParameter;
import org.mariadb.jdbc.internal.com.send.parameters.DateParameter;
import org.mariadb.jdbc.internal.com.send.parameters.DoubleParameter;
import org.mariadb.jdbc.internal.com.send.parameters.FloatParameter;
import org.mariadb.jdbc.internal.com.send.parameters.IntParameter;
import org.mariadb.jdbc.internal.com.send.parameters.LongParameter;
import org.mariadb.jdbc.internal.com.send.parameters.NullParameter;
import org.mariadb.jdbc.internal.com.send.parameters.OffsetTimeParameter;
import org.mariadb.jdbc.internal.com.send.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.com.send.parameters.ReaderParameter;
import org.mariadb.jdbc.internal.com.send.parameters.ShortParameter;
import org.mariadb.jdbc.internal.com.send.parameters.StreamParameter;
import org.mariadb.jdbc.internal.com.send.parameters.StringParameter;
import org.mariadb.jdbc.internal.com.send.parameters.TimeParameter;
import org.mariadb.jdbc.internal.com.send.parameters.TimestampParameter;
import org.mariadb.jdbc.internal.com.send.parameters.ZonedDateTimeParameter;
import org.mariadb.jdbc.internal.io.input.PacketInputStream;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.util.exceptions.ExceptionFactory;

public class UpdatableResultSet
extends SelectResultSet {
    private static final int STATE_STANDARD = 0;
    private static final int STATE_UPDATE = 1;
    private static final int STATE_UPDATED = 2;
    private static final int STATE_INSERT = 3;
    private String database;
    private String table;
    private int notInsertRowPointer;
    private SQLException updateException;
    private SQLException insertException;
    private int state = 0;
    private final ParameterHolder[] parameterHolders;
    private MariaDbConnection connection;
    private PreparedStatement refreshPreparedStatement = null;
    private ClientSidePreparedStatement deletePreparedStatement = null;

    public UpdatableResultSet(ColumnDefinition[] columnsInformation, Results results, Protocol protocol, PacketInputStream reader, boolean callableResult, boolean eofDeprecated) throws IOException, SQLException {
        super(columnsInformation, results, protocol, reader, callableResult, eofDeprecated);
        this.checkIfUpdatable(results);
        this.parameterHolders = new ParameterHolder[this.columnInformationLength];
    }

    @Override
    public int getConcurrency() {
        return 1008;
    }

    private void checkIfUpdatable(Results results) throws SQLException {
        this.database = null;
        this.table = null;
        for (ColumnDefinition columnDefinition : this.columnsInformation) {
            if (columnDefinition.getDatabase() == null || columnDefinition.getDatabase().isEmpty()) {
                this.cannotUpdateInsertRow("The result-set contains fields without without any database information", true);
                return;
            }
            if (this.database != null && !this.database.equals(columnDefinition.getDatabase())) {
                this.cannotUpdateInsertRow("The result-set contains more than one database", true);
                return;
            }
            this.database = columnDefinition.getDatabase();
            if (columnDefinition.getOriginalTable() == null || columnDefinition.getOriginalTable().isEmpty()) {
                this.cannotUpdateInsertRow("The result-set contains fields without without any table information", true);
                return;
            }
            if (this.table != null && !this.table.equals(columnDefinition.getOriginalTable())) {
                this.cannotUpdateInsertRow("The result-set contains fields on different tables", true);
                return;
            }
            this.table = columnDefinition.getOriginalTable();
        }
        if (this.database == null) {
            this.cannotUpdateInsertRow("The result-set does not contain any table information", true);
            return;
        }
        if (this.table == null) {
            this.cannotUpdateInsertRow("The result-set does not contain any table information", true);
            return;
        }
        if (results.getStatement() != null && results.getStatement().getConnection() != null) {
            this.connection = results.getStatement().getConnection();
            Statement stmt = this.connection.createStatement(1004, 1007);
            ResultSet rs = stmt.executeQuery("SHOW COLUMNS FROM `" + this.database + "`.`" + this.table + "`");
            UpdatableColumnDefinition[] updatableColumns = new UpdatableColumnDefinition[this.columnInformationLength];
            boolean primaryFound = false;
            while (rs.next()) {
                String fieldName = rs.getString("Field");
                boolean canBeNull = "YES".equals(rs.getString("Null"));
                boolean hasDefault = rs.getString("Default") != null;
                String extra = rs.getString("Extra");
                boolean generated = extra != null && !extra.isEmpty();
                boolean autoIncrement = "auto_increment".equals(extra);
                boolean primary = "PRI".equals(rs.getString("Key"));
                boolean found = false;
                for (int index = 0; index < this.columnInformationLength; ++index) {
                    ColumnDefinition columnDefinition = this.columnsInformation[index];
                    if (!fieldName.equals(columnDefinition.getOriginalName())) continue;
                    updatableColumns[index] = new UpdatableColumnDefinition(columnDefinition, canBeNull, hasDefault, generated, primary, autoIncrement);
                    found = true;
                }
                if (primary) {
                    primaryFound = true;
                }
                if (found) continue;
                if (primary) {
                    this.cannotUpdateInsertRow("Primary key field `" + fieldName + "` is not in result-set", false);
                    return;
                }
                if (canBeNull || hasDefault || generated) continue;
                this.cannotInsertRow("Field `" + fieldName + "` is not present in query returning fields and cannot be null");
            }
            if (!primaryFound) {
                this.cannotUpdateInsertRow("Table `" + this.database + "`.`" + this.table + "` has no primary key", true);
                return;
            }
            boolean ensureAllColumnHaveMeta = true;
            for (int index = 0; index < this.columnInformationLength; ++index) {
                if (updatableColumns[index] != null) continue;
                this.cannotUpdateInsertRow("Metadata information not available for table `" + this.database + "`.`" + this.table + "`, field `" + this.columnsInformation[index].getOriginalName() + "`", false);
                ensureAllColumnHaveMeta = false;
            }
            if (ensureAllColumnHaveMeta) {
                this.columnsInformation = updatableColumns;
            }
        } else {
            throw new SQLException("abnormal error : connection is null");
        }
    }

    private UpdatableColumnDefinition[] getUpdatableColumns() {
        return (UpdatableColumnDefinition[])this.columnsInformation;
    }

    private void cannotUpdateInsertRow(String reason, boolean exceptionUpdateNotSupported) {
        if (this.updateException == null) {
            this.updateException = exceptionUpdateNotSupported ? new SQLFeatureNotSupportedException("ResultSet cannot be updated. " + reason) : new SQLException("ResultSet cannot be updated. " + reason);
        }
        if (this.insertException == null) {
            this.insertException = exceptionUpdateNotSupported ? new SQLFeatureNotSupportedException("No row can be inserted. " + reason) : new SQLException("No row can be inserted. " + reason);
        }
    }

    private void cannotInsertRow(String reason) {
        if (this.insertException == null) {
            this.insertException = new SQLException("No row can be inserted. " + reason);
        }
    }

    private void checkUpdatable(int position) throws SQLException {
        if (position <= 0 || position > this.columnInformationLength) {
            throw new SQLDataException("No such column: " + position, "22023");
        }
        if (this.state == 0) {
            this.state = 1;
        }
        if (this.state == 1) {
            if (this.getRowPointer() < 0) {
                throw new SQLDataException("Current position is before the first row", "22023");
            }
            if (this.getRowPointer() >= this.getDataSize()) {
                throw new SQLDataException("Current position is after the last row", "22023");
            }
            if (this.updateException != null) {
                throw this.updateException;
            }
        }
        if (this.state == 3 && this.insertException != null) {
            throw this.insertException;
        }
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.checkUpdatable(columnIndex);
        this.parameterHolders[columnIndex - 1] = new NullParameter();
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        this.updateNull(this.findColumn(columnLabel));
    }

    @Override
    public void updateBoolean(int columnIndex, boolean bool) throws SQLException {
        this.checkUpdatable(columnIndex);
        this.parameterHolders[columnIndex - 1] = new ByteParameter(bool ? (byte)1 : 0);
    }

    @Override
    public void updateBoolean(String columnLabel, boolean value) throws SQLException {
        this.updateBoolean(this.findColumn(columnLabel), value);
    }

    @Override
    public void updateByte(int columnIndex, byte value) throws SQLException {
        this.checkUpdatable(columnIndex);
        this.parameterHolders[columnIndex - 1] = new ByteParameter(value);
    }

    @Override
    public void updateByte(String columnLabel, byte value) throws SQLException {
        this.updateByte(this.findColumn(columnLabel), value);
    }

    @Override
    public void updateShort(int columnIndex, short value) throws SQLException {
        this.checkUpdatable(columnIndex);
        this.parameterHolders[columnIndex - 1] = new ShortParameter(value);
    }

    @Override
    public void updateShort(String columnLabel, short value) throws SQLException {
        this.updateShort(this.findColumn(columnLabel), value);
    }

    @Override
    public void updateInt(int columnIndex, int value) throws SQLException {
        this.checkUpdatable(columnIndex);
        this.parameterHolders[columnIndex - 1] = new IntParameter(value);
    }

    @Override
    public void updateInt(String columnLabel, int value) throws SQLException {
        this.updateInt(this.findColumn(columnLabel), value);
    }

    @Override
    public void updateFloat(int columnIndex, float value) throws SQLException {
        this.checkUpdatable(columnIndex);
        this.parameterHolders[columnIndex - 1] = new FloatParameter(value);
    }

    @Override
    public void updateFloat(String columnLabel, float value) throws SQLException {
        this.updateFloat(this.findColumn(columnLabel), value);
    }

    @Override
    public void updateDouble(int columnIndex, double value) throws SQLException {
        this.checkUpdatable(columnIndex);
        this.parameterHolders[columnIndex - 1] = new DoubleParameter(value);
    }

    @Override
    public void updateDouble(String columnLabel, double value) throws SQLException {
        this.updateDouble(this.findColumn(columnLabel), value);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal value) throws SQLException {
        this.checkUpdatable(columnIndex);
        if (value == null) {
            this.parameterHolders[columnIndex - 1] = new NullParameter(ColumnType.DECIMAL);
            return;
        }
        this.parameterHolders[columnIndex - 1] = new BigDecimalParameter(value);
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal value) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnLabel), value);
    }

    @Override
    public void updateString(int columnIndex, String value) throws SQLException {
        this.checkUpdatable(columnIndex);
        if (value == null) {
            this.parameterHolders[columnIndex - 1] = new NullParameter(ColumnType.STRING);
            return;
        }
        this.parameterHolders[columnIndex - 1] = new StringParameter(value, this.noBackslashEscapes);
    }

    @Override
    public void updateString(String columnLabel, String value) throws SQLException {
        this.updateString(this.findColumn(columnLabel), value);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] value) throws SQLException {
        this.checkUpdatable(columnIndex);
        if (value == null) {
            this.parameterHolders[columnIndex - 1] = new NullParameter(ColumnType.BLOB);
            return;
        }
        this.parameterHolders[columnIndex - 1] = new ByteArrayParameter(value, this.noBackslashEscapes);
    }

    @Override
    public void updateBytes(String columnLabel, byte[] value) throws SQLException {
        this.updateBytes(this.findColumn(columnLabel), value);
    }

    @Override
    public void updateDate(int columnIndex, Date date) throws SQLException {
        this.checkUpdatable(columnIndex);
        if (date == null) {
            this.parameterHolders[columnIndex - 1] = new NullParameter(ColumnType.DATE);
            return;
        }
        this.parameterHolders[columnIndex - 1] = new DateParameter(date, TimeZone.getDefault(), this.options);
    }

    @Override
    public void updateDate(String columnLabel, Date value) throws SQLException {
        this.updateDate(this.findColumn(columnLabel), value);
    }

    @Override
    public void updateTime(int columnIndex, Time time) throws SQLException {
        this.checkUpdatable(columnIndex);
        if (time == null) {
            this.parameterHolders[columnIndex - 1] = new NullParameter(ColumnType.TIME);
            return;
        }
        this.parameterHolders[columnIndex - 1] = new TimeParameter(time, TimeZone.getDefault(), this.options.useFractionalSeconds);
    }

    @Override
    public void updateTime(String columnLabel, Time value) throws SQLException {
        this.updateTime(this.findColumn(columnLabel), value);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp timeStamp) throws SQLException {
        this.checkUpdatable(columnIndex);
        if (timeStamp == null) {
            this.parameterHolders[columnIndex - 1] = new NullParameter(ColumnType.DATETIME);
            return;
        }
        this.parameterHolders[columnIndex - 1] = new TimestampParameter(timeStamp, this.timeZone, this.options.useFractionalSeconds);
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp value) throws SQLException {
        this.updateTimestamp(this.findColumn(columnLabel), value);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream inputStream) throws SQLException {
        this.updateAsciiStream(columnIndex, inputStream, Long.MAX_VALUE);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream inputStream) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnLabel), inputStream);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream inputStream, int length) throws SQLException {
        this.updateAsciiStream(columnIndex, inputStream, (long)length);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream inputStream, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnLabel), inputStream, length);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.checkUpdatable(columnIndex);
        if (inputStream == null) {
            this.parameterHolders[columnIndex - 1] = new NullParameter(ColumnType.BLOB);
            return;
        }
        this.parameterHolders[columnIndex - 1] = new StreamParameter(inputStream, length, this.noBackslashEscapes);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnLabel), inputStream, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream inputStream, int length) throws SQLException {
        this.updateBinaryStream(columnIndex, inputStream, (long)length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.checkUpdatable(columnIndex);
        if (inputStream == null) {
            this.parameterHolders[columnIndex - 1] = new NullParameter(ColumnType.BLOB);
            return;
        }
        this.parameterHolders[columnIndex - 1] = new StreamParameter(inputStream, length, this.noBackslashEscapes);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream inputStream, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnLabel), inputStream, (long)length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnLabel), inputStream, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(columnIndex, inputStream, Long.MAX_VALUE);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnLabel), inputStream);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(columnIndex, reader, (long)length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader value) throws SQLException {
        this.updateCharacterStream(columnIndex, value, Long.MAX_VALUE);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnLabel), reader, (long)length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader value, long length) throws SQLException {
        this.checkUpdatable(columnIndex);
        if (value == null) {
            this.parameterHolders[columnIndex - 1] = new NullParameter(ColumnType.BLOB);
            return;
        }
        this.parameterHolders[columnIndex - 1] = new ReaderParameter(value, length, this.noBackslashEscapes);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnLabel), reader, Long.MAX_VALUE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateInternalObject(int parameterIndex, Object obj, int targetSqlType, long scaleOrLength) throws SQLException {
        switch (targetSqlType) {
            case -8: 
            case 70: 
            case 2000: 
            case 2002: 
            case 2003: 
            case 2006: 
            case 2009: {
                throw ExceptionFactory.INSTANCE.notSupported("Type not supported");
            }
        }
        if (obj == null) {
            this.updateNull(parameterIndex);
            return;
        } else if (obj instanceof String) {
            if (targetSqlType == 2004) {
                throw ExceptionFactory.INSTANCE.create("Cannot convert a String to a Blob");
            }
            String str = (String)obj;
            try {
                switch (targetSqlType) {
                    case -7: 
                    case 16: {
                        this.updateBoolean(parameterIndex, !"false".equalsIgnoreCase(str) && !"0".equals(str));
                        return;
                    }
                    case -6: {
                        this.updateByte(parameterIndex, Byte.parseByte(str));
                        return;
                    }
                    case 5: {
                        this.updateShort(parameterIndex, Short.parseShort(str));
                        return;
                    }
                    case 4: {
                        this.updateInt(parameterIndex, Integer.parseInt(str));
                        return;
                    }
                    case 6: 
                    case 8: {
                        this.updateDouble(parameterIndex, Double.parseDouble(str));
                        return;
                    }
                    case 7: {
                        this.updateFloat(parameterIndex, Float.parseFloat(str));
                        return;
                    }
                    case -5: {
                        this.updateLong(parameterIndex, Long.parseLong(str));
                        return;
                    }
                    case 2: 
                    case 3: {
                        this.updateBigDecimal(parameterIndex, new BigDecimal(str));
                        return;
                    }
                    case -16: 
                    case -15: 
                    case -9: 
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: 
                    case 2011: {
                        this.updateString(parameterIndex, str);
                        return;
                    }
                    case 93: {
                        if (str.startsWith("0000-00-00")) {
                            this.updateTimestamp(parameterIndex, null);
                            return;
                        }
                        this.updateTimestamp(parameterIndex, Timestamp.valueOf(str));
                        return;
                    }
                    case 92: {
                        this.updateTime(parameterIndex, Time.valueOf((String)obj));
                        return;
                    }
                    case 2013: {
                        this.parameterHolders[parameterIndex - 1] = new OffsetTimeParameter(OffsetTime.parse(str), this.timeZone, this.options.useFractionalSeconds, this.options);
                        return;
                    }
                    case 2014: {
                        this.parameterHolders[parameterIndex - 1] = new ZonedDateTimeParameter(ZonedDateTime.parse(str, BasePrepareStatement.SPEC_ISO_ZONED_DATE_TIME), this.timeZone, this.options.useFractionalSeconds, this.options);
                        return;
                    }
                    default: {
                        throw ExceptionFactory.INSTANCE.create("Could not convert [" + str + "] to " + targetSqlType);
                    }
                }
            }
            catch (IllegalArgumentException e2) {
                throw ExceptionFactory.INSTANCE.create("Could not convert [" + str + "] to " + targetSqlType, e2);
            }
        } else if (obj instanceof Number) {
            Number bd2 = (Number)obj;
            switch (targetSqlType) {
                case -6: {
                    this.updateByte(parameterIndex, bd2.byteValue());
                    return;
                }
                case 5: {
                    this.updateShort(parameterIndex, bd2.shortValue());
                    return;
                }
                case 4: {
                    this.updateInt(parameterIndex, bd2.intValue());
                    return;
                }
                case -5: {
                    this.updateLong(parameterIndex, bd2.longValue());
                    return;
                }
                case 6: 
                case 8: {
                    this.updateDouble(parameterIndex, bd2.doubleValue());
                    return;
                }
                case 7: {
                    this.updateFloat(parameterIndex, bd2.floatValue());
                    return;
                }
                case 2: 
                case 3: {
                    if (obj instanceof BigDecimal) {
                        this.updateBigDecimal(parameterIndex, (BigDecimal)obj);
                        return;
                    }
                    if (obj instanceof Double || obj instanceof Float) {
                        this.updateDouble(parameterIndex, bd2.doubleValue());
                        return;
                    }
                    this.updateLong(parameterIndex, bd2.longValue());
                    return;
                }
                case -7: {
                    this.updateBoolean(parameterIndex, bd2.shortValue() != 0);
                    return;
                }
                case 1: 
                case 12: {
                    this.updateString(parameterIndex, bd2.toString());
                    return;
                }
                default: {
                    throw ExceptionFactory.INSTANCE.create("Could not convert [" + bd2 + "] to " + targetSqlType);
                }
            }
        } else if (obj instanceof byte[]) {
            if (targetSqlType != -2 && targetSqlType != -3 && targetSqlType != -4) throw ExceptionFactory.INSTANCE.create("Can only convert a byte[] to BINARY, VARBINARY or LONGVARBINARY");
            this.updateBytes(parameterIndex, (byte[])obj);
            return;
        } else if (obj instanceof Time) {
            this.updateTime(parameterIndex, (Time)obj);
            return;
        } else if (obj instanceof Timestamp) {
            this.updateTimestamp(parameterIndex, (Timestamp)obj);
            return;
        } else if (obj instanceof Date) {
            this.updateDate(parameterIndex, (Date)obj);
            return;
        } else if (obj instanceof java.util.Date) {
            long time = ((java.util.Date)obj).getTime();
            if (targetSqlType == 91) {
                this.updateDate(parameterIndex, new Date(time));
                return;
            } else if (targetSqlType == 92) {
                this.updateTime(parameterIndex, new Time(time));
                return;
            } else {
                if (targetSqlType != 93) return;
                this.updateTimestamp(parameterIndex, new Timestamp(time));
            }
            return;
        } else if (obj instanceof Boolean) {
            this.updateBoolean(parameterIndex, (boolean)((Boolean)obj));
            return;
        } else if (obj instanceof Blob) {
            this.updateBlob(parameterIndex, (Blob)obj);
            return;
        } else if (obj instanceof Clob) {
            this.updateClob(parameterIndex, (Clob)obj);
            return;
        } else if (obj instanceof InputStream) {
            this.updateBinaryStream(parameterIndex, (InputStream)obj, scaleOrLength);
            return;
        } else if (obj instanceof Reader) {
            this.updateCharacterStream(parameterIndex, (Reader)obj, scaleOrLength);
            return;
        } else if (obj instanceof LocalDateTime) {
            this.updateTimestamp(parameterIndex, Timestamp.valueOf((LocalDateTime)obj));
            return;
        } else if (obj instanceof Instant) {
            this.updateTimestamp(parameterIndex, Timestamp.from((Instant)obj));
            return;
        } else if (obj instanceof LocalDate) {
            this.updateDate(parameterIndex, Date.valueOf((LocalDate)obj));
            return;
        } else if (obj instanceof OffsetDateTime) {
            this.parameterHolders[parameterIndex - 1] = new ZonedDateTimeParameter(((OffsetDateTime)obj).toZonedDateTime(), this.timeZone, this.options.useFractionalSeconds, this.options);
            return;
        } else if (obj instanceof OffsetTime) {
            this.parameterHolders[parameterIndex - 1] = new OffsetTimeParameter((OffsetTime)obj, this.timeZone, this.options.useFractionalSeconds, this.options);
            return;
        } else if (obj instanceof ZonedDateTime) {
            this.parameterHolders[parameterIndex - 1] = new ZonedDateTimeParameter((ZonedDateTime)obj, this.timeZone, this.options.useFractionalSeconds, this.options);
            return;
        } else {
            if (!(obj instanceof LocalTime)) throw ExceptionFactory.INSTANCE.create("Could not set parameter in setObject, could not convert: " + obj.getClass() + " to " + targetSqlType);
            this.updateTime(parameterIndex, Time.valueOf((LocalTime)obj));
        }
    }

    @Override
    public void updateObject(int columnIndex, Object value, int scaleOrLength) throws SQLException {
        this.checkUpdatable(columnIndex);
        this.updateInternalObject(columnIndex, value, this.columnsInformation[columnIndex - 1].getColumnType().getSqlType(), scaleOrLength);
    }

    @Override
    public void updateObject(int columnIndex, Object value) throws SQLException {
        this.checkUpdatable(columnIndex);
        this.updateInternalObject(columnIndex, value, this.columnsInformation[columnIndex - 1].getColumnType().getSqlType(), Long.MAX_VALUE);
    }

    @Override
    public void updateObject(String columnLabel, Object value, int scaleOrLength) throws SQLException {
        this.updateObject(this.findColumn(columnLabel), value, scaleOrLength);
    }

    @Override
    public void updateObject(String columnLabel, Object value) throws SQLException {
        this.updateObject(this.findColumn(columnLabel), value);
    }

    @Override
    public void updateLong(int columnIndex, long value) throws SQLException {
        this.checkUpdatable(columnIndex);
        this.parameterHolders[columnIndex - 1] = new LongParameter(value);
    }

    @Override
    public void updateLong(String columnLabel, long value) throws SQLException {
        this.updateLong(this.findColumn(columnLabel), value);
    }

    @Override
    public void updateRef(int columnIndex, Ref ref) throws SQLException {
        throw ExceptionFactory.INSTANCE.notSupported("REF not supported");
    }

    @Override
    public void updateRef(String columnLabel, Ref ref) throws SQLException {
        throw ExceptionFactory.INSTANCE.notSupported("REF not supported");
    }

    @Override
    public void updateBlob(int columnIndex, Blob blob) throws SQLException {
        this.checkUpdatable(columnIndex);
        if (blob == null) {
            this.parameterHolders[columnIndex - 1] = new NullParameter(ColumnType.BLOB);
            return;
        }
        this.parameterHolders[columnIndex - 1] = new StreamParameter(blob.getBinaryStream(), blob.length(), this.noBackslashEscapes);
    }

    @Override
    public void updateBlob(String columnLabel, Blob blob) throws SQLException {
        this.updateBlob(this.findColumn(columnLabel), blob);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.updateBlob(columnIndex, inputStream, Long.MAX_VALUE);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.updateBlob(this.findColumn(columnLabel), inputStream, Long.MAX_VALUE);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.checkUpdatable(columnIndex);
        if (inputStream == null) {
            this.parameterHolders[columnIndex - 1] = new NullParameter(ColumnType.BLOB);
            return;
        }
        this.parameterHolders[columnIndex - 1] = new StreamParameter(inputStream, length, this.noBackslashEscapes);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.updateBlob(this.findColumn(columnLabel), inputStream, length);
    }

    @Override
    public void updateClob(int columnIndex, Clob clob) throws SQLException {
        this.checkUpdatable(columnIndex);
        if (clob == null) {
            this.parameterHolders[columnIndex - 1] = new NullParameter(ColumnType.BLOB);
            return;
        }
        this.parameterHolders[columnIndex - 1] = new ReaderParameter(clob.getCharacterStream(), clob.length(), this.noBackslashEscapes);
    }

    @Override
    public void updateClob(String columnLabel, Clob clob) throws SQLException {
        this.updateClob(this.findColumn(columnLabel), clob);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.updateCharacterStream(columnIndex, reader, length);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.updateCharacterStream(columnIndex, reader);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnLabel), reader);
    }

    @Override
    public void updateArray(int columnIndex, Array array) throws SQLException {
        throw ExceptionFactory.INSTANCE.notSupported("Arrays not supported");
    }

    @Override
    public void updateArray(String columnLabel, Array array) throws SQLException {
        throw ExceptionFactory.INSTANCE.notSupported("Arrays not supported");
    }

    @Override
    public void updateRowId(int columnIndex, RowId rowId) throws SQLException {
        throw ExceptionFactory.INSTANCE.notSupported("RowIDs not supported");
    }

    @Override
    public void updateRowId(String columnLabel, RowId rowId) throws SQLException {
        throw ExceptionFactory.INSTANCE.notSupported("RowIDs not supported");
    }

    @Override
    public void updateNString(int columnIndex, String value) throws SQLException {
        this.updateString(columnIndex, value);
    }

    @Override
    public void updateNString(String columnLabel, String value) throws SQLException {
        this.updateString(columnLabel, value);
    }

    @Override
    public void updateNClob(int columnIndex, NClob nclob) throws SQLException {
        this.updateClob(columnIndex, (Clob)nclob);
    }

    @Override
    public void updateNClob(String columnLabel, NClob nclob) throws SQLException {
        this.updateClob(columnLabel, (Clob)nclob);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.updateClob(columnIndex, reader);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.updateClob(columnLabel, reader);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.updateClob(columnIndex, reader, length);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateClob(columnLabel, reader, length);
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw ExceptionFactory.INSTANCE.notSupported("SQlXML not supported");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw ExceptionFactory.INSTANCE.notSupported("SQLXML not supported");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader value, long length) throws SQLException {
        this.updateCharacterStream(columnIndex, value, length);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader reader) throws SQLException {
        this.updateCharacterStream(columnIndex, reader);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.updateCharacterStream(columnLabel, reader);
    }

    @Override
    public void insertRow() throws SQLException {
        if (this.state == 3) {
            boolean hasGeneratedPrimaryFields = false;
            int generatedSqlType = 0;
            HashMap<Integer, ParameterHolder> paramMap = new HashMap<Integer, ParameterHolder>();
            StringBuilder insertSql = new StringBuilder("INSERT `" + this.database + "`.`" + this.table + "` ( ");
            StringBuilder valueClause = new StringBuilder();
            StringBuilder returningClause = new StringBuilder();
            int fieldsIndex = 0;
            boolean firstParam = true;
            for (int pos = 0; pos < this.columnInformationLength; ++pos) {
                UpdatableColumnDefinition colInfo = this.getUpdatableColumns()[pos];
                if (pos != 0) {
                    returningClause.append(", ");
                }
                returningClause.append("`").append(colInfo.getOriginalName()).append("`");
                ParameterHolder parameterHolder = this.parameterHolders[pos];
                if (parameterHolder != null) {
                    if (!firstParam) {
                        insertSql.append(",");
                        valueClause.append(", ");
                    }
                    insertSql.append("`").append(colInfo.getOriginalName()).append("`");
                    valueClause.append("?");
                    paramMap.put(fieldsIndex++ + 1, parameterHolder);
                    firstParam = false;
                    continue;
                }
                if (colInfo.isPrimary()) {
                    if (colInfo.isAutoIncrement() || colInfo.hasDefault()) {
                        if (colInfo.isAutoIncrement()) {
                            hasGeneratedPrimaryFields = true;
                            generatedSqlType = colInfo.getColumnType().getSqlType();
                            continue;
                        }
                        if (this.connection.isServerMariaDb() && this.connection.versionGreaterOrEqual(10, 5, 1)) continue;
                        throw new SQLException(String.format("Cannot call insertRow() not setting value for primary key %s with default value before server 10.5", colInfo.getOriginalName()));
                    }
                    throw new SQLException(String.format("Cannot call insertRow() not setting value for primary key %s", colInfo.getOriginalName()));
                }
                if (colInfo.hasDefault()) continue;
                if (!firstParam) {
                    insertSql.append(",");
                    valueClause.append(", ");
                }
                firstParam = false;
                insertSql.append("`").append(colInfo.getOriginalName()).append("`");
                valueClause.append("?");
                paramMap.put(fieldsIndex++ + 1, new NullParameter());
            }
            insertSql.append(") VALUES (").append((CharSequence)valueClause).append(")");
            if (this.connection.isServerMariaDb() && this.connection.versionGreaterOrEqual(10, 5, 1)) {
                insertSql.append(" RETURNING ").append((CharSequence)returningClause);
            }
            try (BasePrepareStatement insertPreparedStatement = this.row instanceof BinaryRowProtocol ? this.connection.serverPrepareStatement(insertSql.toString()) : this.connection.clientPrepareStatement(insertSql.toString());){
                for (Map.Entry entry : paramMap.entrySet()) {
                    insertPreparedStatement.setParameter((Integer)entry.getKey(), (ParameterHolder)entry.getValue());
                }
                ResultSet insertRs = insertPreparedStatement.executeQuery();
                if (this.connection.isServerMariaDb() && this.connection.versionGreaterOrEqual(10, 5, 1)) {
                    if (insertRs.next()) {
                        byte[] byArray = ((SelectResultSet)insertRs).getCurrentRowData();
                        this.addRowData(byArray);
                    }
                } else if (hasGeneratedPrimaryFields) {
                    ResultSet resultSet = insertPreparedStatement.getGeneratedKeys();
                    if (resultSet.next()) {
                        this.prepareRefreshStmt();
                        this.refreshPreparedStatement.setObject(1, resultSet.getObject(1), generatedSqlType);
                        SelectResultSet rs = (SelectResultSet)this.refreshPreparedStatement.executeQuery();
                        if (rs.next()) {
                            this.addRowData(rs.getCurrentRowData());
                        }
                    }
                } else {
                    this.addRowData(this.refreshRawData());
                }
            }
            Arrays.fill(this.parameterHolders, null);
        }
    }

    @Override
    public void updateRow() throws SQLException {
        if (this.state == 3) {
            throw new SQLException("Cannot call updateRow() when inserting a new row");
        }
        if (this.state == 1) {
            StringBuilder updateSql = new StringBuilder("UPDATE `" + this.database + "`.`" + this.table + "` SET ");
            StringBuilder whereClause = new StringBuilder(" WHERE ");
            boolean firstUpdate = true;
            boolean firstPrimary = true;
            int fieldsToUpdate = 0;
            for (int pos = 0; pos < this.columnInformationLength; ++pos) {
                UpdatableColumnDefinition colInfo = this.getUpdatableColumns()[pos];
                ParameterHolder value = this.parameterHolders[pos];
                if (colInfo.isPrimary()) {
                    if (!firstPrimary) {
                        whereClause.append("AND ");
                    }
                    firstPrimary = false;
                    whereClause.append("`").append(colInfo.getOriginalName()).append("` = ? ");
                }
                if (value == null) continue;
                if (!firstUpdate) {
                    updateSql.append(",");
                }
                firstUpdate = false;
                ++fieldsToUpdate;
                updateSql.append("`").append(colInfo.getOriginalName()).append("` = ? ");
            }
            updateSql.append((CharSequence)whereClause);
            ClientSidePreparedStatement preparedStatement = this.connection.clientPrepareStatement(updateSql.toString());
            int fieldsIndex = 0;
            int fieldsPrimaryIndex = 0;
            for (int pos = 0; pos < this.columnInformationLength; ++pos) {
                UpdatableColumnDefinition colInfo = this.getUpdatableColumns()[pos];
                ParameterHolder value = this.parameterHolders[pos];
                if (value != null) {
                    preparedStatement.setParameter(fieldsIndex++ + 1, value);
                }
                if (!colInfo.isPrimary()) continue;
                preparedStatement.setObject(fieldsToUpdate + fieldsPrimaryIndex++ + 1, this.getObject(pos + 1), colInfo.getColumnType().getSqlType());
            }
            preparedStatement.execute();
            this.state = 2;
            this.refreshRow();
            Arrays.fill(this.parameterHolders, null);
            this.state = 0;
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        if (this.state == 3) {
            throw new SQLException("Cannot call deleteRow() when inserting a new row");
        }
        if (this.updateException != null) {
            throw this.updateException;
        }
        if (this.getRowPointer() < 0) {
            throw new SQLDataException("Current position is before the first row", "22023");
        }
        if (this.getRowPointer() >= this.getDataSize()) {
            throw new SQLDataException("Current position is after the last row", "22023");
        }
        if (this.deletePreparedStatement == null) {
            StringBuilder deleteSql = new StringBuilder("DELETE FROM `" + this.database + "`.`" + this.table + "` WHERE ");
            boolean firstPrimary = true;
            for (int pos = 0; pos < this.columnInformationLength; ++pos) {
                UpdatableColumnDefinition colInfo = this.getUpdatableColumns()[pos];
                if (!colInfo.isPrimary()) continue;
                if (!firstPrimary) {
                    deleteSql.append("AND ");
                }
                firstPrimary = false;
                deleteSql.append("`").append(colInfo.getOriginalName()).append("` = ? ");
            }
            this.deletePreparedStatement = this.connection.clientPrepareStatement(deleteSql.toString());
        }
        int fieldsPrimaryIndex = 1;
        for (int pos = 0; pos < this.columnInformationLength; ++pos) {
            UpdatableColumnDefinition colInfo = this.getUpdatableColumns()[pos];
            if (!colInfo.isPrimary()) continue;
            this.deletePreparedStatement.setObject(fieldsPrimaryIndex++, this.getObject(pos + 1), colInfo.getColumnType().getSqlType());
        }
        this.deletePreparedStatement.executeUpdate();
        this.deleteCurrentRowData();
    }

    private void prepareRefreshStmt() throws SQLException {
        if (this.refreshPreparedStatement == null) {
            StringBuilder selectSql = new StringBuilder("SELECT ");
            StringBuilder whereClause = new StringBuilder(" WHERE ");
            boolean firstPrimary = true;
            for (int pos = 0; pos < this.columnInformationLength; ++pos) {
                UpdatableColumnDefinition colInfo = this.getUpdatableColumns()[pos];
                if (pos != 0) {
                    selectSql.append(",");
                }
                selectSql.append("`").append(colInfo.getOriginalName()).append("`");
                if (!colInfo.isPrimary()) continue;
                if (!firstPrimary) {
                    whereClause.append("AND ");
                }
                firstPrimary = false;
                whereClause.append("`").append(colInfo.getOriginalName()).append("` = ? ");
            }
            selectSql.append(" FROM `").append(this.database).append("`.`").append(this.table).append("`").append((CharSequence)whereClause);
            this.refreshPreparedStatement = this.isBinaryEncoded() ? this.connection.serverPrepareStatement(selectSql.toString()) : this.connection.clientPrepareStatement(selectSql.toString());
        }
    }

    private byte[] refreshRawData() throws SQLException {
        this.prepareRefreshStmt();
        int fieldsPrimaryIndex = 1;
        for (int pos = 0; pos < this.columnInformationLength; ++pos) {
            UpdatableColumnDefinition colInfo = this.getUpdatableColumns()[pos];
            if (!colInfo.isPrimary()) continue;
            ParameterHolder value = this.parameterHolders[pos];
            if (this.state != 0 && value != null) {
                if (this.isBinaryEncoded()) {
                    ((ServerSidePreparedStatement)this.refreshPreparedStatement).setParameter(fieldsPrimaryIndex++, value);
                    continue;
                }
                ((ClientSidePreparedStatement)this.refreshPreparedStatement).setParameter(fieldsPrimaryIndex++, value);
                continue;
            }
            this.refreshPreparedStatement.setObject(fieldsPrimaryIndex++, this.getObject(pos + 1), colInfo.getColumnType().getSqlType());
        }
        SelectResultSet rs = (SelectResultSet)this.refreshPreparedStatement.executeQuery();
        if (rs.next()) {
            return rs.getCurrentRowData();
        }
        return new byte[0];
    }

    @Override
    public void refreshRow() throws SQLException {
        if (this.state == 3) {
            throw new SQLException("Cannot call deleteRow() when inserting a new row");
        }
        if (this.getRowPointer() < 0) {
            throw new SQLDataException("Current position is before the first row", "22023");
        }
        if (this.getRowPointer() >= this.getDataSize()) {
            throw new SQLDataException("Current position is after the last row", "22023");
        }
        if (this.updateException == null) {
            this.updateRowData(this.refreshRawData());
        }
    }

    @Override
    public void cancelRowUpdates() {
        Arrays.fill(this.parameterHolders, null);
        this.state = 0;
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        if (this.insertException != null) {
            throw this.insertException;
        }
        Arrays.fill(this.parameterHolders, null);
        this.state = 3;
        this.notInsertRowPointer = this.getRowPointer();
    }

    @Override
    public void moveToCurrentRow() {
        Arrays.fill(this.parameterHolders, null);
        this.state = 0;
        this.setRowPointer(this.notInsertRowPointer);
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this.state == 3) {
            this.state = 1;
            this.setRowPointer(this.notInsertRowPointer);
        }
        super.beforeFirst();
    }

    @Override
    public boolean first() throws SQLException {
        if (this.state == 3) {
            this.state = 1;
            this.setRowPointer(this.notInsertRowPointer);
        }
        return super.first();
    }

    @Override
    public boolean last() throws SQLException {
        if (this.state == 3) {
            this.state = 1;
            this.setRowPointer(this.notInsertRowPointer);
        }
        return super.last();
    }

    @Override
    public void afterLast() throws SQLException {
        if (this.state == 3) {
            this.state = 1;
            this.setRowPointer(this.notInsertRowPointer);
        }
        super.afterLast();
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (this.state == 3) {
            this.state = 1;
            this.setRowPointer(this.notInsertRowPointer);
        }
        return super.absolute(row);
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        if (this.state == 3) {
            this.state = 1;
            this.setRowPointer(this.notInsertRowPointer);
        }
        return super.relative(rows);
    }

    @Override
    public boolean next() throws SQLException {
        if (this.state == 3) {
            this.state = 1;
            this.setRowPointer(this.notInsertRowPointer);
        }
        return super.next();
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.state == 3) {
            this.state = 1;
            this.setRowPointer(this.notInsertRowPointer);
        }
        return super.previous();
    }

    @Override
    public void close() throws SQLException {
        if (this.refreshPreparedStatement != null) {
            this.refreshPreparedStatement.close();
        }
        super.close();
    }
}

