/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import org.mariadb.jdbc.internal.util.exceptions.ExceptionFactory;

public class SimpleParameterMetaData
implements ParameterMetaData {
    private final int parameterCount;

    public SimpleParameterMetaData(int parameterCount) {
        this.parameterCount = parameterCount;
    }

    @Override
    public int getParameterCount() throws SQLException {
        return this.parameterCount;
    }

    @Override
    public int isNullable(int param) throws SQLException {
        if (param < 1 || param > this.parameterCount) {
            throw ExceptionFactory.INSTANCE.create(String.format("Parameter metadata out of range : param was %s and must be in range 1 - %s", param, this.parameterCount), "07009");
        }
        return 2;
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        if (param < 1 || param > this.parameterCount) {
            throw ExceptionFactory.INSTANCE.create(String.format("Parameter metadata out of range : param was %s and must be in range 1 - %s", param, this.parameterCount), "07009");
        }
        return true;
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        if (param < 1 || param > this.parameterCount) {
            throw ExceptionFactory.INSTANCE.create(String.format("Parameter metadata out of range : param was %s and must be in range 1 - %s", param, this.parameterCount), "07009");
        }
        throw ExceptionFactory.INSTANCE.create("Unknown parameter metadata precision");
    }

    @Override
    public int getScale(int param) throws SQLException {
        if (param < 1 || param > this.parameterCount) {
            throw ExceptionFactory.INSTANCE.create(String.format("Parameter metadata out of range : param was %s and must be in range 1 - %s", param, this.parameterCount), "07009");
        }
        throw ExceptionFactory.INSTANCE.create("Unknown parameter metadata scale");
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        if (param < 1 || param > this.parameterCount) {
            throw ExceptionFactory.INSTANCE.create(String.format("Parameter metadata out of range : param was %s and must be in range 1 - %s", param, this.parameterCount), "07009");
        }
        throw ExceptionFactory.INSTANCE.notSupported("Getting parameter type metadata are not supported");
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        if (param < 1 || param > this.parameterCount) {
            throw ExceptionFactory.INSTANCE.create(String.format("Parameter metadata out of range : param was %s and must be in range 1 - %s", param, this.parameterCount), "07009");
        }
        throw ExceptionFactory.INSTANCE.create("Unknown parameter metadata type name");
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        if (param < 1 || param > this.parameterCount) {
            throw ExceptionFactory.INSTANCE.create(String.format("Parameter metadata out of range : param was %s and must be in range 1 - %s", param, this.parameterCount), "07009");
        }
        throw ExceptionFactory.INSTANCE.create("Unknown parameter metadata class name");
    }

    @Override
    public int getParameterMode(int param) {
        return 1;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            if (this.isWrapperFor(iface)) {
                return iface.cast(this);
            }
            throw new SQLException("The receiver is not a wrapper for " + iface.getName());
        }
        catch (Exception e2) {
            throw new SQLException("The receiver is not a wrapper and does not implement the interface");
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }
}

